package kissme_test;

/* wait/notify test
 */

import java.util.Vector;

public class WaitNotify extends Thread
{

  private Vector list;
  private boolean isThread2;
  private Boolean synchObject;

  private int count;

  public void run ()
  {
	if(!isThread2)
	  {
	    while(count++ < 1000)
	      {
		synchronized(list)
		  {
		    list.addElement (this);
		    list.notify();
		  }
		if(count % 100 == 0)
		  System.err.println("first thread looping");
	      }
	  }
	else
	  {
	    int tossed = 0;
	    while(tossed < 1000)
	      {
		synchronized(list)
		  {
		    try {
		      System.err.println("2nd thread waiting");
		      list.wait(20);
		      tossed += list.size();
		      System.err.println("tossing " + list.size() + " items, tossed is " + tossed);
		      list.removeAllElements();
		    } catch(InterruptedException ie)
		      {
		      }
		  }
		if(count % 100 == 0)
		  System.err.println("second thread looping");
	      }
	  }
      
  }
   
  public WaitNotify (Vector list, Boolean synchObject, boolean lastThread)
  {
    isThread2 = lastThread;
    this.list = list;
    this.synchObject = synchObject;
  }

  public static void main (String[]argv)
  {
    Vector list = new Vector ();
    Boolean synchObject = new Boolean(false);
    WaitNotify m1 = new WaitNotify (list, synchObject, false);
    WaitNotify m2 = new WaitNotify (list, synchObject, true);
        m1.start ();
        m2.start ();
    System.err.println("Main thread exiting");
  }
}
