#include <config.h>

#ifdef CURSES_CONSOLE

#include "teaseme_console_curses_CursesConsole.h"

#include <curses.h>

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    initscr
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_initscr
  (JNIEnv * env, jobject c)
{
  initscr();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    nonl
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_nonl
  (JNIEnv *env, jobject c)
{
  nonl();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    cbreak
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_cbreak
  (JNIEnv *env, jobject c )
{
  cbreak();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    echo
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_echo
  (JNIEnv *env, jobject c )
{
  echo();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    noecho
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_noecho
  (JNIEnv *env, jobject c )
{
  noecho();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    endwin
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_endwin
  (JNIEnv *env , jobject c) 
{
  endwin();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    getrows
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_getrows
  (JNIEnv *env, jobject c)
{
  int maxy;
  int maxx;
  getmaxyx(stdscr,maxx, maxy );
  return maxy;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    getcolumns
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_getcolumns
  (JNIEnv *env, jobject c)
{
  int maxy;
  int maxx;
  getmaxyx(stdscr,maxx, maxy );
  return maxx;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    addch
 * Signature: (C)I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_addch
  (JNIEnv *env, jobject c , jchar thechar)
{
  addch(thechar & 0xff);
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    getch
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_getch
  (JNIEnv *env, jobject c)
{
  return getch();
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    getcury
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_getcury
  (JNIEnv *env, jobject c)
{
  return getcury(stdscr);
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    getcurx
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_getcurx
  (JNIEnv *env, jobject c)
{
  return getcurx(stdscr);
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    move
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_move
  (JNIEnv *env, jobject c , jint x , jint y)
{
  move(y,x);
  return 0;
}

JNIEXPORT jboolean JNICALL Java_teaseme_console_curses_CursesConsole_native_1refresh(JNIEnv *env, jobject c)
{
  refresh();
  return JNI_TRUE;
}

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>



JNIEXPORT jboolean JNICALL Java_teaseme_console_curses_CursesConsole_native_1hasInput(JNIEnv *env, jobject c)
{
  int result;

  fd_set readfds;

  struct timeval timeout;

  FD_ZERO(&readfds);
  FD_SET(0, &readfds);

  timeout.tv_sec = 0;
  timeout.tv_usec = 500;
  result = select(1, &readfds, NULL, NULL, &timeout);

  if(result == 1)
    {
    return JNI_TRUE;
    }
  return JNI_FALSE;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    native_erase
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_native_1erase
  (JNIEnv * env, jobject c)
{
  erase();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    native_clear
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_native_1clear
  (JNIEnv * env, jobject c)
{
  clear();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    native_clrtobot
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_native_1clrtobot
  (JNIEnv * env, jobject c)
{
  clrtobot();
  return 0;
}

/*
 * Class:     teaseme_console_curses_CursesConsole
 * Method:    native_clrtoeol
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_teaseme_console_curses_CursesConsole_native_1clrtoeol
  (JNIEnv *env, jobject c)
{
  clrtoeol();
  return 0;
}

#endif
