#include <config.h>
#include <stdlib.h>
#include <assert.h>
#include "jni.h"

#include "newobject.h"
#include "interp_methods.h"
#include "classfile_methods.h"
#include "../java.lang/Class.h"
#include "../java.lang/Class_Reflection.h"
#include "classex.h"

#include <stdio.h>

jobject java_lang_reflect_Constructor_constructNative(JNIEnv* env, jobject consObject, jobjectArray args,jclass declaringClazz, jint slot)
{
  //We need the jclass object for the class we want to instantiate, plus the method pointer and an array of jargs as values
  //So we need the method pointer

    tClassLoaderTuple* tclass;
    jfieldID fieldID;
    jvalue* jvalue_array;
    jobject ret;
    int i;
    
    tMethod* method;
    
    tclass = CLASS_GetClassStruct(env, declaringClazz);

    assert(tclass);

    //Now we need the method pointer
    assert(slot < tclass->pstClass->u16MethodsCount);
    method = tclass->pstClass->pstMethods + slot;

    //check the number of args is correct
	if( CLASS_CheckNumReflectionMethodArguments(env, method, args) != 0)
	  {
	    return NULL;
	  }

    //Now check that the types given match what the method expects
	if(CLASS_CreateReflectedMethodArguments(env, method, args, &jvalue_array) != 0)
	  {
	    return NULL;
	  }

    ret = (*env)->NewObjectA(env, declaringClazz, method, jvalue_array);
    sys_free(jvalue_array);

    if((*env)->ExceptionOccurred(env))
      {
	return CLASS_CreateInvocationTargetException(env);
      }
    return ret;
}

//	public native int getModifiers();
static int32 flagsMask = ACC_PUBLIC | ACC_PRIVATE | ACC_PROTECTED ;


jint java_lang_reflect_Constructor_getModifiers(JNIEnv* env, jobject consObject)
{
    tClassLoaderTuple* class = ODEREF(consObject)->pstType;
    jclass consClass = class->classObject;
    jfieldID fieldID;
    tMethod* method;

    assert(consClass);
    fieldID = (*env)->GetFieldID(env, consClass, "slot", "I");
    if(fieldID == NULL) { (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/InternalError", "Couldn't get slot field for java.lang.reflect.Constructor")); return 0; }

    method = class->pstClass->pstMethods + (*env)->GetIntField(env, consObject, fieldID);

    if(method == NULL) { (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/InternalError", "Couldn't get method from slot field for java.lang.reflect.Constructor")); return 0; }

    return method->u16AccessFlags & flagsMask;
}












