#include <config.h>
#include <stdlib.h>
#include <assert.h>
#include "jni.h"

#include "classex.h"
#include "interp_methods.h"
#include "classfile_methods.h"
#include "newobject.h"
#include "garbage.h"
#include "../java.lang/java_lang_Class.h"
#include "../java.lang/Class.h"
#include "../java.lang/VMClassLoader.h"
#include "../java.lang/Class_Reflection.h"
#include <stdio.h>


extern tOBREF OOMExceptionObject;

//there is too much repetition in these methods
//we need a method which will extract a tMethod* from a methodObject

tMethod* java_lang_reflect_Method_extractPointer(JNIEnv* env, jobject methodObject)
{
    tClassLoaderTuple* classPtr;
    jclass methodClazz;
    jfieldID fieldID;
    tMethod* method;
    int theslot;
    int isstatic;

    jclass clazzClazz;
    jclass declaringClazz;

    methodClazz  = (*env)->GetObjectClass(env, methodObject); 
    assert(methodClazz);
    fieldID = (*env)->GetFieldID(env, methodClazz, "declaringClass", "Ljava/lang/Class;");
    assert(fieldID);

    declaringClazz = (*env)->GetObjectField(env, methodObject, fieldID);
    clazzClazz = (*env)->GetObjectClass(env, declaringClazz);
    fieldID = (*env)->GetFieldID(env, clazzClazz, "_classStruct", "I");
    assert(fieldID);
    classPtr = (tClassLoaderTuple*) (*env)->GetIntField(env, declaringClazz, fieldID);

    assert(classPtr);

    fieldID = (*env)->GetFieldID(env, methodClazz, "isstatic", "I");
    assert(fieldID);
    isstatic = (*env)->GetIntField(env, methodObject, fieldID);

    fieldID = (*env)->GetFieldID(env, methodClazz, "slot", "I");
    assert(fieldID);
    
    theslot = (*env)->GetIntField(env, methodObject, fieldID);
    assert(theslot >= 0);
    assert(theslot < classPtr->pstClass->u16MethodsCount);
    method = classPtr->pstClass->pstMethods + theslot;

    assert(method);

    return method;
}

#include "newobject.h"

jobjectArray java_lang_reflect_Method_getExceptionTypes(JNIEnv* env, jobject methodObject)
{
    jobjectArray  parameters;
    tClassLoaderTuple* classPtr;
    tMethod* method;
    int j;

    method = java_lang_reflect_Method_extractPointer(env, methodObject);

    assert(method);
    if(method->bHaveResolvedExceptions == 0)
      {
	if(CLASSFILE_ResolveMethodExceptions(env, method) != 0)
	  {
	    //an exception will be thrown by that method
	    return NULL;
	  }
      }
    assert(method->bHaveResolvedExceptions == 1);
//				   if( method->bHaveResolvedExceptions)
    classPtr = method->pstClass;
    parameters = (*env)->NewObjectArray(env, method->u16NumExceptions, (*env)->FindClass(env, "java/lang/Class"), NULL);
			   for(j = 0; j < (method->u16NumExceptions);j++)
			       {
				     (*env)->SetObjectArrayElement(env, parameters, j, CLASS_MakeClassObject(env, method->pstExceptions[j]));
			       }
   return parameters;
}


static int32 flagsMask = ACC_PUBLIC | ACC_PRIVATE | ACC_PROTECTED | ACC_STATIC |  ACC_FINAL | ACC_SYNCHRONISED | ACC_NATIVE | ACC_ABSTRACT;

//not | ACC_INTERFACE | ACC_TRANSIENT  

jint java_lang_reflect_Method_getModifiers(JNIEnv* env, jobject methodObject)
{
    tMethod* method;
    method = java_lang_reflect_Method_extractPointer(env, methodObject);

    return method->u16AccessFlags & flagsMask;
}

jobjectArray java_lang_reflect_Method_getParameterTypes(JNIEnv* env, jobject methodObject)
{
    tMethod* method;

    method = java_lang_reflect_Method_extractPointer(env, methodObject);

    assert(method);
    
    return CLASS_GetClassArrayFromSig(env, method->uidSignature, method->pstClass);
}

//	public native Class getReturnType();

jclass java_lang_reflect_Method_getReturnType(JNIEnv* env, jobject methodObject)
{
  tMethod* method;
  jint count;
  jclass ret;

  method = java_lang_reflect_Method_extractPointer(env, methodObject);

  count = CLASSFILE_CalcNumArguments( method->uidSignature);

  ret = CLASS_GetClassFromSig(env,  method->uidSignature, method->pstClass,count + 1);
  assert(ret);

  return ret;
}

/* We have to wrap the return value if it is primitive 
 */

//	private native Object invokeNative(Object o, Object[] args,
//			Class declaringClass, int slot);
jobject java_lang_reflect_Method_invokeNative(JNIEnv* env, jobject methodObject, jobject obj, jobjectArray args,jclass theclass, jint slot)
{
  //We need the jclass object for the class we want to instantiate, plus the method pointer and an array of jargs as values
  //So we need the method pointer

  tMethod* method;
  jvalue* jvalue_array;
  jobject ret;

  int expectedArguments;
    //Ok now call the method
  method = java_lang_reflect_Method_extractPointer(env, methodObject);

  expectedArguments = CLASSFILE_CalcNumArguments( method->uidSignature);
  if(CLASS_CheckNumReflectionMethodArguments(env, method, args) != 0)
    {
      return NULL;
    }
  if(CLASS_CreateReflectedMethodArguments(env, method, args, &jvalue_array) != 0)
    {
      return NULL;
    }

      //we have to check the return type and then call the relevant JNI method
      if(method->u16AccessFlags & ACC_STATIC)
      {
	switch( method->uidSignature[ strlen(method->uidSignature) - 1] )
	  {
	  case 'V':
	    {
	       (*env)->CallStaticVoidMethodA(env, theclass, method, jvalue_array);
	       ret = NULL;
//	       ret = INTERP_NewObject(env,  CLASS_GetClassStruct(env, java_lang_VMClassLoader_getPrimitiveWrapperClassFromCode(env, T_VOID)));
	       break;
	    }
	  case 'B':
	    {
	      jbyte b = (*env)->CallStaticByteMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveByte(env, b);
	      break;
	    }
	  case 'C':
	    {
	      jchar c = (*env)->CallStaticCharMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveChar(env, c);
	      break;
	    }
	  case 'F':
	    {
	      jfloat f = (*env)->CallStaticFloatMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveFloat(env, f);
	      break;
	    }
	  case 'S':
	    {
	      jshort s = (*env)->CallStaticShortMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveShort(env, s);
	      break;
	    }
	  case 'Z':
	    {
	      jboolean b = (*env)->CallStaticBooleanMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveBoolean(env, b);
	      break;
	    }
	  case 'I':
	    {
	      jint i = (*env)->CallStaticIntMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveInt(env, i);
	      break;
	    }
	  case 'D':
	    {
	      jdouble d = (*env)->CallStaticDoubleMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveDouble(env, d);
	      break;
	    }
	  case 'J':
	    {
	      jlong l = (*env)->CallStaticLongMethodA(env, theclass, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveLong(env, l);
	      break;
	    }
	  case ';':
	    {
	      ret = (*env)->CallStaticObjectMethodA(env, theclass, method, jvalue_array);
	      break;
	    }
	  default:
	    {
	      sys_free(jvalue_array);
	      (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/InternalError", "An internal error occurred in invokeNative, bad signature for (static) method"));
	      return NULL;
	    }
	  }
      }
    else
      {
	/* Check that it isn't a NULL object being used for an instance method */
	if(obj == NULL)
	  {
	      sys_free(jvalue_array);
	      (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/NullPointerException", "NULL object passed to invoke for an instance method"));
	      return NULL;
	  }
	
	//check that the obj is an instance of declaringClazz
	if( Java_java_lang_Class_isInstance(env, theclass, obj) == JNI_FALSE)
	  {
	    char* errMessage;
	    tClassLoaderTuple* pstDesiredClass;
	    tClassLoaderTuple* pstSuppliedClass;

	    sys_free(jvalue_array);
	    pstDesiredClass = CLASS_GetClassStruct(env, theclass );
	    pstSuppliedClass = CLASS_GetClassStruct(env, CLASS_GetClass(env,obj) );

	    errMessage = sys_malloc( 1024 + strlen(pstDesiredClass->uidName) + strlen(pstSuppliedClass->uidName));
	    if(errMessage == NULL) { (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/InternalError")); return NULL; }

	    sprintf(errMessage, "Object passed to invoke was type %s, expected type %s\n", pstSuppliedClass->uidName, pstDesiredClass->uidName);
	    (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/IllegalArgumentException", errMessage));
	    sys_free(errMessage);
	    return NULL;
	  }

	/* We must invoke the instance method for the object that is passed to us */
	method = CLASSFILE_FindMethodInVT(env, CLASS_GetClassStruct( env, CLASS_GetClass(env,obj)), method->uidName, method->uidSignature);

	if(method == NULL)
	  {
	     (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/InternalError"));
	     return NULL;
	  }

	switch( method->uidSignature[ strlen(method->uidSignature) - 1] )
	  {
	  case 'V':
	    {
	       (*env)->CallVoidMethodA(env, obj, method, jvalue_array);
	       ret = NULL;
	       //they just seem to return null for void INTERP_NewObject(env, CLASS_GetClassStruct(env, java_lang_VMClassLoader_getPrimitiveWrapperClassFromCode(env, T_VOID)));
	       break;
	    }
	  case 'B':
	    {
	      jbyte b = (*env)->CallByteMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveByte(env, b);
	      break;
	    }
	  case 'C':
	    {
	      jchar c = (*env)->CallCharMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveChar(env, c);
	      break;
	    }
	  case 'F':
	    {
	      jfloat f = (*env)->CallFloatMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveFloat(env, f);
	      break;
	    }
	  case 'S':
	    {
	      jshort s = (*env)->CallShortMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveShort(env, s);
	      break;
	    }
	  case 'Z':
	    {
	      jboolean b = (*env)->CallBooleanMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveBoolean(env, b);
	      break;
	    }
	  case 'I':
	    {
	      jint i = (*env)->CallIntMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveInt(env, i);
	      break;
	    }
	  case 'D':
	    {
	      jdouble d = (*env)->CallDoubleMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveDouble(env, d);
	      break;
	    }
	  case 'J':
	    {
	      jlong l = (*env)->CallLongMethodA(env, obj, method, jvalue_array);
	      ret = INTERP_wrapPrimitiveLong(env, l);
	      break;
	    }
	  case ';':
	    {
	      ret = (*env)->CallObjectMethodA(env, obj, method , jvalue_array);
	      break;
	    }
	  default:
	    {
	      sys_free(jvalue_array);
	      (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/InternalError", "An internal error occurred in invokeNative, bad signature for method"));
	      return NULL;
	    }
	  }
      }
    sys_free(jvalue_array);
    if(ret != NULL)
      assert( GARBAGE_InHeap(env, ret));
    if((*env)->ExceptionOccurred(env))
      {
	return CLASS_CreateInvocationTargetException(env);
      }
    return ret;
}





