#include <config.h>
/*
 * Native methods for Throwable class.
 *
 */

/*
  private native void printStackTrace0 (Object stream);
  public native Throwable fillInStackTrace();
*/

#include <stdio.h>
#include <assert.h>
#include "interp.h"
#include "jni.h"
#include "interp_methods.h"

#include "thread.h"
#include "classfile_methods.h"
#include "newobject.h"
#include "global.h"
#include "java_lang_Class.h"
#include "Class.h"
#include "Class_Reflection.h"
#include "threadinfo.h"

static jobject createStackTraceObject(JNIEnv* env, jint num_frames, jobjectArray cls_array)
{
  jclass StackTrace_cls = (*env)->FindClass(env, "gnu/vm/stack/StackTrace");
  jobject traceObject = INTERP_NewObject(env, CLASS_GetClassStruct(env,StackTrace_cls));
  jfieldID framesField;
  jfieldID lenField;

#ifdef DEBUG
  assert(traceObject);
#endif
  framesField = (*env)->GetFieldID(env, StackTrace_cls, "frames", "[Lgnu/vm/stack/StackFrame;");
  lenField = (*env)->GetFieldID(env, StackTrace_cls, "len", "I");

#ifdef DEBUG
  assert(framesField);
  assert(lenField);
#endif
  (*env)->SetIntField(env, traceObject, lenField, num_frames); 
  (*env)->SetObjectField(env, traceObject, framesField, (jobject) cls_array); 

  return traceObject;
}

jobject java_lang_Throwable_fillInStackTrace
(
  JNIEnv* env,
  jobject throwableObject
)
{
  tStackFrame* f;
  tOBREF prevStackFrame = NULL;

  /* We need these to set the trace field in the Throwable object*/
  jfieldID traceFieldID;
  jclass Throwable_cls;

  /* The object we're creating */
  jobject stackTraceObject;

  int num_frames = 0;
  int i;
  int j;
  jarray cls_array = NULL;
  jclass StackFrame_cls = (*env)->FindClass(env, "gnu/vm/stack/StackFrame");

  int num_initial_frames = 0;

  num_initial_frames = THREADINFO_countInitialStackFramesFromNode(THREAD_FindThread());

  assert(num_initial_frames > 0);
  for(j = 0; j < (num_initial_frames); j++) 
    {
      tStackFrame* topFrame = THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), j);
      // First count the number of frames
       f = topFrame;
       while (f != NULL) 
	 {
#ifdef HIDE_EXCEPTION_CONSTRUCTION 
	   if(f->pstCurrObject == throwableObject)
	     {
	       //eprintf("Match throwable %i\n", num_frames);
	     }
	   else
#endif
	     num_frames ++;
	   f = f->pstChildFrame;
	 }
    } 

 // eprintf("Creating throwable stack trace, there are %i initial frames and %i frames, object %p\n", num_initial_frames, num_frames, throwableObject);
  cls_array = (*env)->NewObjectArray(env, num_frames, StackFrame_cls, NULL);   //Create an array of StackFrame's
  if(cls_array == NULL)
   {
      return NULL;
   }


  i = 0;

  for(j = 0; j < (num_initial_frames); j++) 
     {
	tStackFrame* topFrame = THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), j);

	f = topFrame;

	while(f != NULL)
	{
	    jfieldID callerField;
	    jfieldID objField;
	    jfieldID methodField;
	    jfieldID lineNumField;
	    jfieldID filenameField;

	    char* sourceFile;

	    //Create each StackFrame
	    tClassLoaderTuple* sfclazz;
	    jobject stackObject;
	    jobject methodObject; 

#ifdef HIDE_EXCEPTION_CONSTRUCTION
            if(f->pstCurrObject == throwableObject)
            {

	    }
	    else
	    {
#endif
	    sfclazz = CLASS_GetClassStruct(env,StackFrame_cls); 
	    if(sfclazz == NULL) //should actually be class not found
	    {
		 return NULL;
	    }
	    stackObject = INTERP_NewObject( env,sfclazz) ;

	    if(stackObject == NULL) 
		{
		 return NULL;
		}
	
	    callerField = (*env)->GetFieldID(env, StackFrame_cls, "caller", "Lgnu/vm/stack/StackFrame;");
	    objField = (*env)->GetFieldID(env, StackFrame_cls, "obj", "Ljava/lang/Object;");
	    methodField = (*env)->GetFieldID(env, StackFrame_cls, "method", "Ljava/lang/reflect/Method;");
	    lineNumField = (*env)->GetFieldID(env, StackFrame_cls, "lineNum", "I");
	    filenameField = (*env)->GetFieldID(env, StackFrame_cls, "filename", "Ljava/lang/String;");

	    (*env)->SetObjectField(env, stackObject, callerField, prevStackFrame);
	    prevStackFrame = stackObject;

	    (*env)->SetObjectField(env, stackObject, objField, f->pstCurrObject);

	    methodObject = Java_java_lang_Class_getMethod(env, CLASS_MakeClassObject(env, f->pstCurrMethod->pstClass), INTERP_NewStringFromAsciz(env, f->pstCurrMethod->uidName),  CLASS_GetClassArrayFromSig(env, f->pstCurrMethod->uidSignature, f->pstCurrMethod->pstClass));
	    (*env)->SetObjectField(env, stackObject, methodField, methodObject);
	    (*env)->SetIntField(env, stackObject, lineNumField, INTERP_FigureOutLineNumber(f));

         /* and get the source file */
         if( f->pstCurrMethod->pstClass->pstClass->u16SourceFile)
	  {
            sourceFile = CONSTGET_UidAsciz( f->pstCurrMethod->pstClass->pstClass, f->pstCurrMethod->pstClass->pstClass->u16SourceFile);
	    (*env)->SetObjectField(env, stackObject, filenameField, INTERP_NewStringFromAsciz(env, sourceFile));
	  }
	  else
	  {
	   (*env)->SetObjectField(env, stackObject, filenameField, NULL);
	  }

//	   eprintf("%i [%i] frame %s.%s%s exception %p\n", num_frames, j, f->pstCurrMethod->pstClass->uidName, f->pstCurrMethod->uidName, f->pstCurrMethod->uidSignature, f->pstException);

	    assert((i) < num_frames);
	    (*env)->SetObjectArrayElement(env, cls_array, (num_frames - i - 1), stackObject);
	    i++;
#ifdef HIDE_EXCEPTION_CONSTRUCTION
            }
#endif
	    f = f->pstChildFrame; 
	}
   }

  stackTraceObject = createStackTraceObject(env, num_frames, cls_array);

  if(stackTraceObject == NULL)
   return NULL;

  Throwable_cls = (*env)->FindClass(env, "java/lang/Throwable");
  traceFieldID = (*env)->GetFieldID(env, Throwable_cls, "trace", "Lgnu/vm/stack/StackTrace;");

  if(traceFieldID == NULL)
  {
   //we can't actually throw an exception
   return NULL;
  }
  (*env)->SetObjectField(env, throwableObject, traceFieldID, stackTraceObject);
  return throwableObject;
}

