#include <config.h>
 
#include <stdlib.h> 
#include <stdio.h>
#include "classfil.h" 
#include <assert.h> 
#include "jni.h" 

#include "classfile_methods.h"
#include "interp_methods.h" 
#include "cptuplelist.h"
#include "newobject.h"
#include "sys_linux_host/wrappers.h"
#include "lib/indigenous/java.lang/java_lang_Class.h"
#include "lib/indigenous/java.lang/Class_Reflection.h"

extern tOBREF OOMExceptionObject;
extern tClassLoaderTuple* pstObjectType; // this can be globally used to get the type for object
 
//java/lang/VMClassLoader.getPrimitiveClass(Ljava/lang/String;)Ljava/lang/Class;              
 
typedef struct primitiveStructure {
  tAType type;
  tClassLoaderTuple* pstType;
  jclass classObject; //the class object for "int", "byte" etc
  jclass wrapperClassObject; //the class object "java/lang/Integer", "java/lang/Byte" etc
} tPrimitiveStructure;

static tPrimitiveStructure primTypes[9];

static char* typeStrings[] = {"boolean", "char", "float", "double", "byte", "short", "int", "long", "void"};
static tAType typeCodes[] = { T_BOOLEAN, T_CHAR, T_FLOAT, T_DOUBLE, T_BYTE, T_SHORT, T_INT, T_LONG, T_VOID };

//an even more elegant way is for those codes to be array indices
//but we share them with the types for the array elements, so we won't change them

jclass java_lang_VMClassLoader_getPrimitiveClassFromCode(JNIEnv* env, tAType code)
{
  int i;
  for( i = 0; i < 9;i++)
    {
      if(primTypes[i].type == code)
	return primTypes[i].classObject;
    }
  return NULL;
}

jclass java_lang_VMClassLoader_getPrimitiveWrapperClassFromCode(JNIEnv* env, tAType code)
{
  int i;
  for( i = 0; i < 9;i++)
    {
      if(primTypes[i].type == code)
	return primTypes[i].wrapperClassObject;
    }
  return NULL;
}

static int primitiveStringToIndex(const char* string)
{
  int i;
  for( i = 0; i < 9;i++)
    {
      if(strcmp(typeStrings[i], string) == 0)
	return i;
    }
  return -1;
}

static jclass primitiveCharToClass(const jchar type)
{
  int i;
  switch (type) {
    case 'Z': /* boolean */
      i = 0;
      break;
    case 'C': /* char */
      i = 1;
      break;
    case 'F': /* float */
      i = 2;
      break;
    case 'D': /* double */
      i = 3;
      break;
    case 'B': /* byte */
      i = 4;
      break;
    case 'S': /* short */
      i = 5;
      break;
    case 'I': /* int */
      i = 6;
      break;
    case 'J': /* long */
      i = 7;
      break;
    case 'V': /* void */
      i = 8;
      break;
    default:
      i = -1;
  }

  if (i >= 0)
    return primTypes[i].classObject;
  else
    return NULL;
}

/* Makes the actual tClass* structure for a primitive type, and also creates a class object 
   Stores the result in a special structure for primitive types
   The prim->type field is already set when this method is called
*/
 
static int java_lang_VMClassLoader_makePrimitiveType(JNIEnv* env, char* name, tPrimitiveStructure* prim)
{
  tClass* c = NULL; 
  tClassLoaderTuple* tuple = NULL;
  tClassLoaderTuple* temp = NULL;

  jclass classObject = NULL; 
  
  c = (tClass*) sys_malloc(sizeof(tClass));
  tuple = (tClassLoaderTuple*) sys_malloc(sizeof(tClassLoaderTuple));
  
  if(c == NULL || tuple == NULL)
    return -1;

  // set all the pointers for the tables to NULL beforehand    

  c->pu32ConstPool = NULL; 
  c->pbConstTags = NULL; 
  c->ppstInterfaces = NULL; 
  c->pstMethods = NULL; 
  
  // set class object to NULL  
  // c->pstClassObject = NULL; 
  tuple->classObject = NULL;
 
#ifdef PERSIST 
  c->persIndex = 0; 
#endif 
 
  // set initialisation flag to 1  
  c->bInitialised = 1; 
 
// set the name  
//  c->uidName = UID_GetUid(name); 
  tuple->uidName = UID_GetUid(name); 
 
  c->u16AccessFlags = ACC_PRIMITIVE | ACC_PUBLIC; 
  c->u16ConstPoolCount = 4; 
  c->u16ConstPoolRealCount = 0; 
  c->u16InterfacesCount = 0; 
  c->u16MethodsCount = 0; 
 
  c->u16MajorVersion = 45; 
  c->u16MinorVersion = 3; 
  c->u16SourceFile = 0; 
  c->u16InstCount = 0; 
  c->u16InstSize = 0; 
  c->pstInstOffsets = NULL; 
  c->u16StatCount = 0; 
  c->u16StatSize = 0; 
  c->pstStatOffsets = 0; 
//  c->pi32StatVars = NULL; 
  tuple->pi32StatVars = NULL;
  tuple->classLoader = NULL;
  tuple->pstClass = c;

  c->u16VTSize = 0; 
  c->ppstVT = NULL; 
//  c->pstClassObject = NULL; 
 tuple->classObject = NULL;
  c->u16NumNatives = 0; 
  c->pstNativeMethods = NULL; 
  c->pstSuperClass = CLASSFILE_FindOrLoad(env, "java/lang/Object", pstObjectType); 
 
  classObject =  (*env)->DefinePrimitiveClass(env, NULL, tuple); 

  prim->classObject = classObject;
  prim->pstType = tuple;

  switch(prim->type)
    {
    case T_BOOLEAN:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Boolean", NULL);
      if(!temp) 
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp);
      break;
    case T_CHAR:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Character", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_FLOAT:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Float", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_DOUBLE:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Double", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_BYTE:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Byte", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_SHORT:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Short", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_INT:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Integer", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_LONG:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Long", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    case T_VOID:
      temp = CLASSFILE_FindOrLoad(env, "java/lang/Void", NULL);
      if(!temp)
	return -1;
      prim->wrapperClassObject = CLASS_MakeClassObject(env, temp); 
      break;
    default:
      prim->wrapperClassObject = NULL;
      assert(2 == 3);
      break;
    
      }
      
  return 0;
}

int java_lang_VMClassLoader_makePrimitiveTypes(JNIEnv* env)
{
  int i;
  for( i = 0; i < 9;i++)
    {
      primTypes[i].type = typeCodes[i];
      if(java_lang_VMClassLoader_makePrimitiveType(env, typeStrings[i], &primTypes[i]) != 0)
	{
	  return -1;
	}
      assert(primTypes[i].wrapperClassObject);
    }
  return 0;
}



/* Looks up the primitive class definitions in the static array */

jclass java_lang_VMClassLoader_getPrimitiveClassFromAsciz ( JNIEnv* env, const char* name)
{ 
    int index = primitiveStringToIndex(name);

    assert(primTypes[0].type == T_BOOLEAN); //just check that the primitive types have been created

    if(index != -1)
      {
	return primTypes[index].classObject;
      }
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/ClassNotFoundException")); 
    return NULL;
}

jclass java_lang_VMClassLoader_getPrimitiveClass( 
  JNIEnv* env, 
  jclass clazz, 
  jchar type
  ) 
{ 
  //Note clazz is allowed to be NULL! 
  jclass ret;

  //just check that the primitive types have been created
  assert(primTypes[0].type == T_BOOLEAN);

  ret = primitiveCharToClass(type);
  if (ret == NULL)
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/NoClassDefFoundError"));

  return ret; 
} 


	/** Helper to resolve all references to other classes from this class.
	 ** @param c the class to resolve.
	 **/

/*	final static native void resolveClass(Class c); */


void java_lang_VMClassLoader_resolveClass( 
  JNIEnv* env, 
  jclass clazz, 
  jclass cls
)
{  
 
  return;
}

jclass java_lang_VMClassLoader_defineClass( 
  JNIEnv* env, 
  jclass clazz, 
  jobject classloader,
  jobject namestring,
  jarray data,
  jint offset,
  jint len
  ) 
{  
  tClass* c;
  tClassLoaderTuple* newtuple;
  jbyte* realData;
  jboolean aboolean;
  uint32 errorCode;
  tOBREF pstExOb;
  char* pszNameString;

  if(data == NULL)
    {
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/ClassFormatError"));
    return NULL;
    }

  realData = (*env)->GetByteArrayElements(env, data, &aboolean);

  if( ADEREF(data)->i32Number <= offset)
    {
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/ClassFormatError"));
    return NULL;
    }

  
  newtuple = CLASSFILE_ClassCreate( env, realData + offset, NULL, classloader, &errorCode );
  c = newtuple->pstClass;

  if(c == NULL) {
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/ClassFormatError"));
    return NULL;
  }

  if(namestring == NULL)
    {
      /*
      eprintf("Null string in defineClass\n");
      (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/NullPointerException"));
      return NULL;

      Apparently this is allowed
      */
      pszNameString = NULL;
    }
  else
    {
      pszNameString = INTERP_AscizFromString(env, namestring);
      if(pszNameString == NULL)
	{
	  (*env)->Throw(env, OOMExceptionObject);
	  return NULL;
	}

      if(strcmp(pszNameString, newtuple->uidName) != 0)
	{
	  (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/NoClassDefFoundError"));
	  eprintf("%s didn't match %s\n", pszNameString, newtuple->uidName);
	  sys_free(pszNameString);
	  return NULL;
	}
      sys_free(pszNameString);
    }

  //Now do the housework stuff
   CPTUPLELIST_Insert(newtuple);
   assert(CPTUPLELIST_Find(newtuple->uidName, newtuple->classLoader) == newtuple);
   pstExOb = CLASSFILE_InitClass(env, newtuple);     
     if(pstExOb)
    {
      //Construct a java.lang.ExceptionInInitializerError
      jobject newExOb;
      jclass exClass = (*env)->FindClass(env, "java/lang/ExceptionInInitializerError");
      
      jmethodID methodID = (*env)->GetMethodID(env, exClass, "<init>", "(Ljava/lang/Throwable;)V");
      if(methodID == NULL)
	{
	  (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, "java/lang/InternalError", "Could not find constructor method for java.lang.ExceptionInInitializerError"));
	  return NULL;
	}
      newExOb = (*env)->NewObject(env, exClass, methodID, pstExOb);
      if(newExOb == NULL) { 	  (*env)->Throw(env, OOMExceptionObject); }
      (*env)->Throw(env, newExOb);
      return NULL;
    }

   eprintf("defined class %s,%p\n", newtuple->uidName, newtuple->classLoader);
   return CLASS_MakeClassObject(env, newtuple);
}
 
 
 
 
 
 
 
 
 
 
