#include <config.h>
/*************************************************************************
 * ResourceBundle.c - Native methods for java.util.ResourceBundle
 *
 * Copyright (c) 1999 Free Software Foundation, Inc.
 * Written by Jochen Hoenicke (jochen@gnu.org)
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 *************************************************************************/

#include <jni.h>
#include <stdio.h>

#include "newobject.h"
#include <assert.h>

//#include "java_util_ResourceBundle.h"

/*
 * This is a wrapper to VMSecurityManager.getClassContext().
 * Note that this relies on the fact that native methods aren't listed
 * in the returned array.
 */


jobjectArray  java_util_ResourceBundle_getClassContext(JNIEnv * env, jclass ourclass )
{
      tJNIData* henv = JNI_getJNIData( pthread_self() );
      tStackFrame* f;
      int num_frames = 0;
      int i;
      jarray cls_array;
      jclass cls_cls = (*env)->FindClass(env, "java/lang/Class");

      f = henv->pstTopFrame; //top_frame;
      while (f != NULL) //henv->stack_highwater)
	{
	  num_frames ++;
	  f = f->pstPrevFrame;
	}

//		printf("GOT HERE %i\n", num_frames);
cls_array = (*env)->NewObjectArray(env, num_frames, cls_cls, NULL);

i = 0;
f = henv->pstTopFrame; //top_frame;
while (f != NULL) //henv->stack_highwater)
				{
    //if (!(f->flags & FRAME_NATIVE))
     jobject work = INTERP_NewObject(env, f->pstCurrMethod->pstClass); 
     jclass classObject = (*env)->GetObjectClass(env, work);
     assert(classObject != NULL);
     (*env)->SetObjectArrayElement(env, cls_array,    i++,	classObject);
     f = f->pstPrevFrame; //parent;
     }

//		printf("GOT HERE %i, returning array %x\n", 0, cls_array);
return cls_array;
}
