// Assumes ethernet & IP
// Other combination will cause odd results.

class ARPPacket extends Packet
{
  final public int HEADER_LEN = 0;
  final public static int ARP_REQ = 1;	// Operations: 	Request
  final public static int ARP_REP = 2;  //		Reply

  int hwa_fmt;		// Hardware Address format
  int prota_fmt;	// Protocol (IP) Address format
  byte hwa_len;		// HW Address length
  byte prota_len; 	// Protocol (IP) Address length
  int  operation;		// ARP operation
  HWAddr hw_src;  	// The source hardware address
  IPAddr ip_src;	//            IP
  HWAddr hw_dest;  	// The destination hardware address
  IPAddr ip_dest;	//            IP

  ARPPacket(byte[] raw)
  {
    hwa_fmt = (raw[0] << 8) + raw[1];
    prota_fmt = (raw[2] << 8) + raw[3];
    hwa_len = raw[4];
    prota_len = raw[5];
    operation = (raw[6] << 8) + raw[7];
    operation = (raw[6] << 8) + raw[7];
    hw_src = new HWAddr(raw[8],raw[9],raw[10],raw[11],raw[12],raw[13]);
    ip_src = new IPAddr(raw[14],raw[15],raw[16],raw[17]);
    hw_dest = new HWAddr(raw[18],raw[19],raw[20],raw[21],raw[22],raw[23]);
    ip_dest = new IPAddr(raw[24],raw[25],raw[26],raw[27]);
    data = raw;
  }
  
  ARPPacket(HWAddr hw_src,IPAddr ip_src,HWAddr hw_dest,IPAddr ip_dest,int op)
  {
    this.hw_src=hw_src;
    this.ip_src=ip_src;
    this.hw_dest=hw_dest;
    this.ip_dest=ip_dest;
    this.operation=op;
    this.hwa_fmt = 1;
    this.prota_fmt=0x800;
    this.hwa_len=(byte)6;
    this.prota_len=(byte)4;
    data=new byte[200];
    update();
  }
  
  public void update()
  {
    data[0]=(byte)(hwa_fmt >> 8);
    data[1]=(byte)(hwa_fmt & 255);
    data[2]=(byte)(prota_fmt >> 8);
    data[3]=(byte)(prota_fmt & 255);
    data[4]=hwa_len;
    data[5]=prota_len;
    data[6]=(byte)(operation >> 8);
    data[7]=(byte)(operation & 255);
    System.arraycopy(hw_src.getData(),0,data,8,6);
    System.arraycopy(ip_src.getData(),0,data,14,4);
    System.arraycopy(hw_dest.getData(),0,data,18,6);
    System.arraycopy(ip_dest.getData(),0,data,24,4);
  }
};
