class ARPTableEntry
{
   public final static int ARP_STATE_PENDING = 1;
   public final static int ARP_STATE_RESOLVED = 2;
   
   private int state;		// Pending or Resolved
   private HWAddr hwaddr;
   private IPAddr ipaddr;
   private ARPTableEntry next;
   private long timestamp;	  // When the entry was last verified. 

   ARPTableEntry(int state,HWAddr hwaddr,IPAddr ipaddr)
   {
     this.state=state;
     this.hwaddr=hwaddr;
     this.ipaddr=ipaddr;
     touch();
   }
   
   public void touch()	/* Update the timestamp*/
   { this.timestamp=System.currentTimeMillis();}

   public int getState() {return state;}
   
   public IPAddr getIPAddr() {return ipaddr;}
   
   public HWAddr getHWAddr() {return hwaddr;}

   public void setHWAddr(HWAddr hwaddr) {this.hwaddr=hwaddr;}

   public ARPTableEntry getNextEntry()  {return next;}
   
   public void setNextEntry(ARPTableEntry next)  {this.next=next;}
    
}

