class EthernetNetworkInterface extends NetworkInterface
{

  private ARP arp;
  private NetworkInterfaceCard driver;
  HWAddr hwaddr;

  EthernetNetworkInterface(NetworkInterfaceCard drvr)
  {
    super();
    driver = drvr;
    hasARP = true;		// Ethernet uses ARP
    if (!init()) {System.out.println("Not inited!");}
    hwaddr=driver.getHWAddr();
    arp = new ARP(this,hwaddr);		
    addProtocol(arp);
  }

  public boolean init()       
  {
    /* Inits the driver */
    if (driver.init() != 0) {return false;}
    else {return true;}
  } 
  
  public Packet readPacket()
  /*
   * Read Ethernet frame and "unpack" it. Used by super.demux()
   */  
  {
    EtherPacket ep = driver.read();
    Packet p=ep.unpack(ep.HEADER_LEN);
    return p;
  }

  void writePacket(Packet p,HWAddr src, HWAddr dest, int protocol)
  {
    if ((p==null) || (src==null) || (dest==null)) 
      { System.out.println("Null pointer?!?!?! in ENI.writePacket");
//        return;
	}
    if (dest==null) {
      System.out.println("Dest invalid");
      }
    if (src==null) {
      System.out.println("Src invalid");
      }
    EtherPacket ep=new EtherPacket(p.pack(14));
    ep.setSrcDestProt(src,dest,protocol);  
      
/*--------------- Test, parse your own packet. It works. */
    System.out.println("Testing packet to send");
    EtherPacket eep= new EtherPacket(ep.data);
    System.out.println(">>>"+eep.dest.toString()+" "+eep.protocol);
    if (eep.protocol==0x800) 
    {
      IPPacket ipp=new IPPacket(eep.unpack(eep.HEADER_LEN));
      System.out.println(">>>"+ipp.toString());
      ICMPPacket icmpp=new ICMPPacket(ipp.unpack(ipp.HEADER_LEN));
      System.out.println(">>>"+icmpp.toString());
    }
    System.out.println("Testing done.");
/*---------------          */
    driver.write(ep);
  }  

  void writeIPPacket(IPPacket ipp)
  {
//    writePacket(ipp,arp.getHWAddr(ipp.src),arp.getHWAddr(ipp.dest),0x800);
    System.out.println("+++"+ipp.toString());
    writePacket(ipp,hwaddr,arp.getHWAddr(ipp.dest),0x800);
  }
}

