class ICMPPacket extends Packet
{
  public final int HEADER_LEN = 8;

  public static byte TYPE_ECHORP= 0;
  public static int TYPE_DESTUR	= 3;
  public static int TYPE_SRCQ	= 4;
  public static int TYPE_REDIRECT=5;
  public static byte TYPE_ECHORQ= 8;
  public static int TYPE_TIMEX	= 11;
  public static int TYPE_PARAMP	= 12;
  public static int TYPE_TIMERQ	= 13;
  public static int TYPE_TIMERP	= 14;
  public static int TYPE_INFORQ	= 15;
  public static int TYPE_INFORP	= 16;
  public static int TYPE_MASKRQ	= 17;
  public static int TYPE_MASKRP	= 18;
  

  byte type;		// ICMP Type
  byte code;		// Subcode;
  int checksum;		// Checksum on header+data;
  int msg_id;		// ID (echo)
  int seq_nr;		// Sequence Number (echo)
  IPAddr gw;		// Gateway (redirect)
  byte ptr;		// Pointer (Parameter Problem)
  
  ICMPPacket()
  {
    super();
  }
  
  ICMPPacket(byte[] raw)
  {
    data = raw;
    parse();
    if (checksum(data.length)!=0)
     { System.out.println("ICMP checksum failure");}
  }

  void parse()
  {
    type= data[0];
    code= data[1];
    checksum = (data[2] << 8) + data[3];
    msg_id = (data[4] << 8) + data[5];
    seq_nr = (data[6] << 8) + data[7];
    gw = new IPAddr(data[4],data[5],data[6],data[7]);
    ptr= data[4];
  }

  ICMPPacket(Packet p)
  {
    this(p.data);
    wrapper=p.wrapper;
  }

  public void update()
  {
    data[0]=type;
    data[1]=code;
    data[2]=0;data[3]=0;
    if ((type == TYPE_ECHORQ) || ((type == TYPE_ECHORP)))
    { data[4]=(byte)(msg_id >> 8);
      data[5]=(byte)(msg_id & 0xff);
      data[6]=(byte)(seq_nr >> 8);
      data[7]=(byte)(seq_nr & 0xff);}
    // ------ other types. Insert here.
    checksum=checksum(data.length);
    data[2]=(byte)(checksum >> 8);
    data[3]=(byte)(checksum & 0xff);
  }
  
  public ICMPPacket reply()
  {
    if (type==TYPE_ECHORQ)
    {
      ICMPPacket rep = new ICMPPacket();
      rep.data=new byte[data.length];
      System.arraycopy(data,0,rep.data,0,data.length);
      rep.protocol=1; //ICMP
      rep.type=TYPE_ECHORP;
      rep.code=code;
      rep.msg_id=msg_id;
      rep.seq_nr=seq_nr;
      rep.update();
      rep.parse();
      return rep;
    }
    return null;
  }

  public String toString()
  {
//    return "Type: "+type;
    return type+"/"+code+"/"+msg_id+"/"+seq_nr;
  }
};
