/*************************************
 * This class is supposed to process *
 * IP datagrams.		     *
 *************************************/

class IP extends Protocol
{
  Protocol firstProtocol;
//  NetworkInterface firstInterface;
  
  int currentId=1234;

  IP()
  {
    protocolNumber=0x800;
    next=null;
    firstProtocol = new ICMP(this);
    firstProtocol.setNextProtocol(new TCP());
    firstProtocol.getNextProtocol().setNextProtocol(new UDP());
  }

/*  public void addInterface(NetworkInterface ni)
  {
    if (firstInterface == null)
    {
      firstInterface = ni;
    }
    else 
    {
      // LL stuff.
    }
  }*/

  public void Handle(Packet p)
  {
    IPPacket ipp = new IPPacket(p.data);
    System.out.println("IP "+ipp.toString());
    Packet pp=ipp.unpack(ipp.HEADER_LEN);
    for (int i=0;i<nrInterfaces;i++)
    {
      if (ipp.dest.equals(interfaces[i].ipaddr)) demux(pp);
    }
  }
  
  void demux(Packet p)
  {
    boolean handled=false;
    Protocol currentProtocol = firstProtocol;
    while ((!handled) && (currentProtocol != null))
    {
      if (currentProtocol.getProtocolNumber()==p.protocol)
      {
        currentProtocol.Handle(p);
	handled=true;
      }
      currentProtocol=currentProtocol.getNextProtocol();
    }
  }
  
  public void send(IPAddr dest,Packet p)
  {
    /*
     * Will do queueing and routing.
     */
    IPPacket ipp=new IPPacket();
    ipp.data=p.pack(20).data;
    ipp.dest=dest;
//    ipp.source= DO ROUTING! Appropriate interface.
    ipp.src=interfaces[0].ipaddr;
    ipp.version=4;
    ipp.hdr_length=5;
    ipp.ttl=(byte)64;
    ipp.tos=0;
    ipp.fragment_offs=0;
    ipp.id=currentId++;
    ipp.length=p.data.length+(ipp.hdr_length*4);
    ipp.protocol=p.protocol;
    // Set fields.
    ipp.update();
    // DO ROUTING!!!
    System.out.println("Writing packet with checksum "+ipp.checksum(20));
    interfaces[0].writeIPPacket(ipp);
  }
};
