#! /bin/zsh -f
CLASSPATHDIR=/home/jleuner/dev/kclasspath/classpath/
LOG4JDIR=../log4j
XTCDIR=../xtc
JAVA_PACKAGES="lang io math net security text util sql"
GNU_PACKAGES="classpath java/io java/lang java/locale java/net java/security java/util java/text"

# Make the binary dist
#
pushd $CLASSPATHDIR
makeme
tar cfv kissme-classpath-binary.tar README
for i in ${=JAVA_PACKAGES} ; do
tar rfv kissme-classpath-binary.tar $(find java/$i -name '*.class')
done
for i in ${=GNU_PACKAGES} ; do
tar rfv kissme-classpath-binary.tar $(find gnu/$i -name '*.class')
done
tar rfv kissme-classpath-binary.tar $(find resource) $(find gnu/java/locale) 
echo "created kissme-classpath-binary.tar.gz in $CLASSPATHDIR"
popd
pushd classes
makeme
tar rfv $CLASSPATHDIR/kissme-classpath-binary.tar $(find kissme/vm -name '*.class')
echo "added kissme vm files to kissme-classpath-binary.tar in $CLASSPATHDIR"
gzip -9 $CLASSPATHDIR/kissme-classpath-binary.tar
echo "gzipped the tar file"
popd

# Make the source dist
#

echo "making source dist"
pushd $CLASSPATHDIR
makeme
tar cfv kissme-classpath.tar README
tar rfv kissme-classpath.tar $(find gnu/gcj -name '*.java') 
for i in ${=JAVA_PACKAGES} ; do
tar rfv kissme-classpath.tar $(find java/$i -name '*.java')
done
for i in ${=GNU_PACKAGES} ; do
tar rfv kissme-classpath.tar $(find gnu/$i -name '*.java')
done
tar rfv kissme-classpath.tar $(find resource) $(find gnu/java/locale) $(find . -name '.makeme')
echo "created kissme-classpath.tar in $CLASSPATHDIR"
popd
pushd classes
makeme
tar rfv $CLASSPATHDIR/kissme-classpath.tar $(find . -name '*.java' ! -path './kissme/testing*') $(find java -name '*.java') $(find gnu/vm -name '.makeme') $(find kissme -name '.makeme')
echo "added kissme vm files to kissme-classpath.tar in $CLASSPATHDIR"
popd
#pushd guiclasses
#makeme
#tar rfv $CLASSPATHDIR/kissme-classpath.tar $(find . -name '*.java') 
#echo "added console GUI files to kissme-classpath.tar in $CLASSPATHDIR"
#popd
#pushd $LOG4JDIR
#tar rfv $CLASSPATHDIR/kissme-classpath.tar $(find org -name '*.java')
#popd
#pushd $XTCDIR
#tar rfv $CLASSPATHDIR/kissme-classpath.tar $(find src -name '*.java')
#popd
gzip -9 $CLASSPATHDIR/kissme-classpath.tar
echo "gzipped the tar file"




