#ifdef USE_DISTRIBUTED_STORE
#ifndef USEOSKIT

#include <pthread.h>

#include "store_communication.h"
#include "beta.h"

int lock_port = 25442;

void connect_to_lock_server(struct thread_context* context)
{
    struct in_addr remoteAddr;
    struct sockaddr_in to;

    to.sin_family = AF_INET;
    if(inet_aton("1.0.0.2", &to.sin_addr) == 0)
	{
	    perror("initialize_remote_socket");
	}
    to.sin_port =  htons(lock_port);
    
    printf("BETA: connecting to lock server %s\n", inet_ntoa(to.sin_addr));

    context->locking_socket = socket(PF_INET, SOCK_STREAM, 0);
    if(context->locking_socket == -1)
	{
	    perror("connect_to_lock_server, socket");
	    exit(9);
	}
    if(connect(context->locking_socket, &to, sizeof(to)) == -1)
	{
	    perror("connect_to_lock_server");
	    exit(8);
	}

}

/* Locks a region on Alpha */

int BETA_lock_region(long long start,long long end, struct thread_context *context)
{
    int buf_len = 4 + 8 * 2;
    int* buf = (int*) malloc( buf_len ); 
    int reply;
    int actual = 1;
    int totalread = 0;

 if(context->locking_socket == -1)
     connect_to_lock_server(context);
    buf[0] = htonl(7099);
    buf[1] = htonl( (int) (start >> 32) );
    buf[2] = htonl( (int) ((start << 32) >> 32 ));

    buf[3] = htonl( (int) (end >> 32) );
    buf[4] = htonl( (int) ((end << 32) >> 32 ));

    //Write request, with start and end addresses
    actual = write(context->locking_socket, buf, buf_len);
    if(actual != buf_len)
	{
	    printf("BETA_lock_region, write actual %i\n", actual);
	    perror("err");
	    exit(7);
	}
    actual = 1;
    while((actual > 0) && (totalread < sizeof(reply)))
	{
	    actual = read(context->locking_socket, ((char*)&reply) + totalread, sizeof(reply) - totalread);
	    totalread += actual;
	}
    
    //    printf("Reply is %i\n", ntohl(reply));
    if(reply == 0)
	{
	    //    printf("BETA_lock_region, lock succeeded %x %x - %x %x\n", buf[1], buf[2], buf[3], buf[4]);
	    free(buf);
	return 0;
	}
    else
	{
	    printf("BETA_lock_region, lock failed %x %x - %x %x\n", buf[1], buf[2], buf[3], buf[4]);
	    free(buf);
	    return -1;
	}
}


int BETA_unlock_region(long long start,long long end, struct thread_context *context)
{
    int buf_len = 4 + 8 * 2;
    int* buf = (int*) malloc( buf_len ); 
    int reply;
    int actual = 1;
    int totalread = 0;

 if(context->locking_socket == -1)
     connect_to_lock_server(context);
 //Code for unlock (or Free Range)
    buf[0] = htonl(7100);
    buf[1] = htonl( (int) (start >> 32) );
    buf[2] = htonl( (int) ((start << 32) >> 32 ));

    buf[3] = htonl( (int) (end >> 32) );
    buf[4] = htonl( (int) ((end << 32) >> 32 ));

    //Write request, with start and end addresses
    actual = write(context->locking_socket, buf, buf_len);
    if(actual != buf_len)
	{
	    printf("BETA_unlock_region, write actual %i\n", actual);
	    perror("err");
	    exit(7);
	}
    actual = 1;
    while((actual > 0) && (totalread < sizeof(reply)))
	{
	    actual = read(context->locking_socket, ((char*)&reply) + totalread, sizeof(reply) - totalread);
	    totalread += actual;
	}
    
    //    printf("BETA_unlock_region Reply is %i\n", ntohl(reply));
    if(reply == 0)
	{
	    //    printf("BETA_unlock_region, unlock succeeded %x %x - %x %x\n", buf[1], buf[2], buf[3], buf[4]);
	    free(buf);
	return 0;
	}
    else
	{
	    printf("BETA_unlock_region, unlock failed %x %x - %x %x\n", buf[1], buf[2], buf[3], buf[4]);
	    free(buf);
	    return -1;
	}
}



#endif
#endif



