#include <config.h>

#ifdef NATIVE_THREADS
#include <pthread.h>
#include <stdio.h>
//#include "garbage.h"

#include "threads_native.h"

#ifndef ALLOCATOR

extern tThreadNode* pstThreadList;


/* Mark the C stacks of the threads */


//How do we know how deep the C stack is?
//1 meg is 0xd800 or something similar

void MarkCStacks()
{
    //First we iterate over each thread
    tThreadNode* iter = pstThreadList;
    while(iter != NULL)
	{
	    int32* pi32TempPtr;

	    #ifdef GARBAGE_VERBOSE
	    fprintf(stderr, "Stack bottom is %x\n", (int) iter->stackBottom);
	    #endif

	    for (pi32TempPtr = iter->stackBottom ; pi32TempPtr > ((int32*)    (iter->stackBottom - 0x1800)); pi32TempPtr--) //was 0x800
		{
		    //		    fprintf(stderr, "Ptr is at %x\n", (int) pi32TempPtr);
		     if (ISHANDLE(*pi32TempPtr))
			 {
			   RecursivelyMark((tOBREF) *pi32TempPtr, 1, GARBAGE_REACHABLE, (tOBREF) (*pi32TempPtr));
			 }
		     else
		       {
			 if (HEAPBOUND(*pi32TempPtr))
			   {
			     /* if the field points into the heap but its contents don't
				then it might be a direct pointer into the heap */
			     //				     #ifdef GARBAGE_VERBOSE
				eprintf("Found direct pointer on C stack (thread %i) %p %p\n", (int) iter->thread_id, pi32TempPtr, (void*) *pi32TempPtr);
			     //			     #endif
							
							//       printf("%s\n",((tObject*) **( (tOBREF*) (pi32TempPtr)))->pstType->uidName);
			     //       assert(2==3);
			     //       exit(1);
			   }
		       }
		}
	    
	    iter = iter->next;
	}
}

/* Mark the stacks of all the threads lying around */


void  MarkThreadStacks()
{
    //First we iterate over each thread
    tThreadNode* iter = pstThreadList;
    while(iter != NULL)
	{
	    //Now for each thread we must get the most current stack frame
	    tStackFrame* currStackFrame = iter->currentFrame;

	    //And for that stack frame we mark it and its predecessors
	     while( currStackFrame != NULL)
		 {
		     //And for each frame we must examine the current object
		     if (currStackFrame->pstCurrObject)
			 RecursivelyMark((tOBREF) currStackFrame->pstCurrObject, 0, GARBAGE_REACHABLE, (tOBREF) currStackFrame);

		     if( currStackFrame->bIsNativeFrame == 0)
			 {		     
		     //And the java operand stack
		     {
			 int i;
			 if(currStackFrame->pstCurrMethod)
			 for (i = 0; i < currStackFrame->pstCurrMethod->pstCode->u16MaxStack + 1; i++)
			     {
				 if (ISHANDLE(currStackFrame->pi32OpBot[i]))
				     {
					 RecursivelyMark((tOBREF) currStackFrame->pi32OpBot[i], 1, GARBAGE_REACHABLE, (tOBREF) currStackFrame->pi32OpBot[i]);
				     }
			     }
		     }

		     //And the local variables
		     {
			 int i32NumLocals;
			 int i;
			 if((currStackFrame->pstCurrMethod) && (currStackFrame->pi32Vars))
			   {
		     i32NumLocals = currStackFrame->pstCurrMethod->u16ArgSize + currStackFrame->pstCurrMethod->pstCode->u16MaxLocals;
		     for (i = 0; i < i32NumLocals; i++)
			 {
			     if (ISHANDLE(currStackFrame->pi32Vars[i]))
				 {
				     RecursivelyMark((tOBREF) currStackFrame->pi32Vars[i], 0, GARBAGE_REACHABLE, (tOBREF) currStackFrame->pi32Vars[i]);
				 }
			 }
		     }
		     }
			 }
		     currStackFrame = currStackFrame->pstPrevFrame;
		 }
	    iter = iter->next;
	}
}



#endif



#endif //ALLOCATOR
