/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Contains the code for the invoke_???????? opcodes 


 */


case invokevirtual:
{
    int16     i16Temp;
    tMethod*  pstMethodTemp;
    int32     i32NativeRet;

    int tmpNumArgs;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread() );
#endif

 i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
#ifdef DEBUG
    assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
    
    /* This first gets the method referenced in the constpool. This
       will, of course, not be the correct method in general because we
       need the method of the same name and type from the handle that is
       on the stack. We then look at the virtual table of the object on
       the stack. We use the virtual table index from the method reference
       we got in order to get the correct method from the correct class. */
    
    /* get the reference */

    pstMethodTemp = CONSTGET_MethodNonVirtual(env, pstCurrClass, i16Temp);

    if((pstMethodTemp->u16AccessFlags & ACC_STATIC))
      {
	eprintf("1. The method %s.%s%s was not meant to be static\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature);
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/IncompatibleClassChangeError");
	    LOADENV();
	    break;
      }

    tmpNumArgs = pstMethodTemp->u16ArgSize;
#ifdef DEBUG
    assert(pstMethodTemp);
#endif
    
    if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
	    break;
        }
    
    assert( DEREF((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1)) != 0);
    
    /* use the reference to find the correct method in the virtual
       table of the object that is on the stack */

    pstMethodTemp = DEREF((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1))->pstType->pstClass->ppstVT[pstMethodTemp->u16VTIndex];

    if((pstMethodTemp->u16AccessFlags & ACC_STATIC))
      {
	eprintf("2. The method %s.%s%s was not meant to be static\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature);
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/IncompatibleClassChangeError");
	    LOADENV();
	    break;
      }

#ifdef VERIFIER
if(!(pstMethodTemp->u16AccessFlags & ACC_VERIFIED))
    {
    int i32Num;
    int result = 0;
    if(!( pstMethodTemp->u16AccessFlags & ACC_NATIVE))
      result = verifyMethod( pstMethodTemp->pstCode->pbCode, &i32Num, pstMethodTemp->pstCode->u32CodeLength, pstMethodTemp, pstMethodTemp->pstClass);
    if(result == 0)
      pstMethodTemp->u16AccessFlags |= ACC_VERIFIED; 
    }
#endif

#ifdef STACKMAP
//if( (strcmp(pstMethodTemp->uidName, "reverseJump") == 0) || 
  //  (strcmp(pstMethodTemp->uidName, "simpleCall") == 0))
    //Generate a stack map
   if(pstMethodTemp->pstCode)
    if(pstMethodTemp->pstCode->pstStackMap == NULL)
      {
	int retLength;
	pstMethodTemp->pstCode->pstStackMap = (struct tstackmap*) generateStackMap( pstMethodTemp->pstCode->pbCode, &retLength, pstMethodTemp->pstCode->u32CodeLength, pstMethodTemp, pstCurrClass);

	if(pstMethodTemp->pstCode->pstStackMap == NULL)
	  {
	  eprintf("Exiting for bum stackmap\n");
	  exit(22);
	  }
      }
#endif

#ifdef SHOW_CALLS
    {
	
	int show = 1;
	
	if(strcmp(pstMethodTemp->uidName, "arraycopy") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "length") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "valueOf") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "append") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "convertToChar") == 0)
	    show = 0;
	if(show)
	    fprintf(stdout, "%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
    }
#endif
    
#ifdef RESURRECT_QUICK
    /* Replace the instruction with the _quick alternative */
    pbPC[-3] = invokevirtual_quick;
    pbPC[-2] = pstMethodTemp->u16VTIndex;
    pbPC[-1] = pstMethodTemp->u16ArgSize; /*number of args*/
#endif
    

    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
	{
#ifdef ENABLE_SVETLANA
#ifdef DEBUG
	    assert((pstMethodTemp->u16AccessFlags & ACC_OPTIMISED) == 0); 
#endif
#endif
#ifdef SHOW_CALLS
	    eprintf( "Invoking native method %s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
#endif
	    //				    printf("Native flags is %i, method flags %i\n", ACC_NATIVE, pstMethodTemp->u16AccessFlags);
	    
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
	}
    else
	{
	    
	    //Not a native method
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
#ifdef DEBUG_LOCKS
			    eprintf("Entering monitor on object %p (%s) from thread %x\n", pstCurrFrame->pstCurrObject, DEREF( pstCurrFrame->pstCurrObject )->pstType->uidName, (int) pthread_self());
#endif
			    
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
        }
    break;
} //end invoke_virtual
#ifdef ENABLE_SVETLANA

/* Execute an invoke_virtual quick opcode, but used an optimised version of the method being invoked
 */

case invokevirtual_quick_optimised:
{

  int (*pMethod) (int32*, tStackFrame*);
  
  int16         i16VTIndex;
  int16         i16ArgSize;
  
  tClassLoaderTuple* pstClassTemp;
  tMethod*      pstMethodTemp;
  
  
  int iCanOptimise = 0;
  
#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread());
#endif

  /* ### watch out for sign extension!!!! */
  i16VTIndex  = (*pbPC++);  /* VT index */
  i16ArgSize = (*pbPC++);  /* no. args */
  
  
  if ((tOBREF) *(optop + 1 - i16ArgSize) == NULL)
    {
      SAVEENV();
      pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
      LOADENV();
    }
  
  /* Get the method from the VT */
  //Jewel sep
  pstClassTemp = (DEREF((tOBREF) (*(optop + 1 - i16ArgSize))))->pstType;
  pstMethodTemp = pstClassTemp->pstClass->ppstVT[i16VTIndex];
  
  
  if(pstMethodTemp->u16AccessFlags & ACC_OPTIMISED)
    {
      iCanOptimise = 1;
      pMethod = (int (*) (int32*, tStackFrame*)) ( pstMethodTemp->pstCode->pOptimisedCode) ;
    }
  else if(pstMethodTemp->u16AccessFlags & ACC_CANNOT_OPTIMISE)
    {
      
    }
  else if( strstr(pstMethodTemp->pstClass->uidName, "cavalry/translator"))
    {
      pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
    }
  else 
    {
      pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
      if( SVETLANA_CanOptimiseMethod( env, pstMethodTemp, pstMethodTemp->pstCode->pbCode, pstMethodTemp->pstCode->u32CodeLength) )
	{
#ifdef SVETLANA_VERBOSE
	  eprintf("1 Calling from %s Created optimised method for %s.%s %s (struct %x)\n", pstCurrClass->uidName, pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature, (int) pstMethodTemp);
#endif
	  
	  pMethod = (int (*) (int32*, tStackFrame*)) SVETLANA_createOptimisedMethod(env, pstMethodTemp, pstMethodTemp->pstCode->pbCode, pstMethodTemp->pstCode->u32CodeLength);
	  
	  if(pMethod == NULL)
	    {
	      pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;			
	      pstMethodTemp->u16AccessFlags &= ~(ACC_OPTIMISED);			
	    }
	  else
	    {
	      pstMethodTemp->pstCode->pOptimisedCode = (int (*) (int32*, void*)) pMethod;
	      
	      pstMethodTemp->u16AccessFlags |= ACC_OPTIMISED;
	      pstMethodTemp->u16AccessFlags &= ~(ACC_CANNOT_OPTIMISE);
	      iCanOptimise = 1;
	    }
	}
    }
  
  if(iCanOptimise)
    {
      int i32OptimisedRet;
      //Ok, quickly push a native stack frame
	  tStackFrame* nativeStackFrame = PushNativeStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
      
#ifdef SVETLANA_VERBOSE
      eprintf( "Calling 1 optimised method %s.%s, arg 0 is %x\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, (int) *(optop - pstMethodTemp->u16ArgSize + 1));
#endif
      //We don't want this to happen just yet

exit(2);
SAVEENV();
i32OptimisedRet = (*pMethod)(optop -  pstMethodTemp->u16ArgSize + 1, nativeStackFrame);
if(i32OptimisedRet != 0)
{
assert ( 3 == 6);
pstCurrFrame = CatchException(env, pstCurrFrame);
}
else
{
  PopStackFrame( nativeStackFrame );
  optop -= (pstMethodTemp->u16ArgSize) - 1;
}
break;
}

   // Now we should actually fall through and do a normal invoke_virtual_quick
   // to do that we should pull back pbPC
   pbPC[-3] = invokevirtual_quick;
   pbPC -= 2;

      }
#endif

#ifdef RESURRECT_QUICK
case invokevirtual_quick:
{
    int16         i16VTIndex;
    int32         i32NativeRet;
    int16         i16ArgSize;
    tClassLoaderTuple*       pstClassTemp;
    tMethod*	    pstMethodTemp;
#ifdef SHOW_CALLS
    int show = 1;
    #endif

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread());
#endif

/* ### watch out for sign extension!!!! */
    i16VTIndex  = (*pbPC++);  /* VT index */
    i16ArgSize = (*pbPC++);  /* no. args */
    
    
    
    if ((tOBREF) *(optop + 1 - i16ArgSize) == NULL)
	{
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
	    
	    //should we break here?
	    break;
	}
    
    /* Get the method from the VT */
    assert( GARBAGE_InHeap( env, (tOBREF) *(optop + 1 - i16ArgSize)) == 1);

    pstClassTemp = (DEREF((tOBREF) (*(optop + 1 - i16ArgSize))))->pstType;

#ifdef DEBUG_CLASS_FOR_GC
  assert(pstClassTemp->magic1 == MAGIC1);
  assert(pstClassTemp->magic2 == MAGIC2);
  assert(pstClassTemp->magic3 == MAGIC3);
#endif

    pstMethodTemp = pstClassTemp->pstClass->ppstVT[i16VTIndex];
    
#ifdef SHOW_CALLS
    {
	
	int show = 1;
	
	if(strcmp(pstMethodTemp->uidName, "arraycopy") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "length") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "indexOf") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "valueOf") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "append") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "convertToChar") == 0)
	    show = 0;
	if(show)
	    fprintf(stdout, "q%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
    }
#endif

   /* Get the current class from the method */
    pstClassTemp = pstMethodTemp->pstClass;
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
	{
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
	}
    else
	{
	    
	    /* Here we see if we can turn this invokevirtual_quick into an optimised method */
	    
#ifdef ENABLE_SVETLANA
	    int iCanOptimise = 0;
	    
	    
	    
	    if( pstMethodTemp->u16AccessFlags & ACC_OPTIMISED)
		{
		    //fprintf(stderr, "invoke_v_quick ACC_OPTIMISED %s\n", pstMethodTemp->uidName);
		    iCanOptimise = 1;
		}
	    else if(pstMethodTemp->u16AccessFlags & ACC_CANNOT_OPTIMISE)
		{
		    //	   fprintf(stderr, "invoke_v_quick ACC_CANNOT_OPTIMISE %s\n", pstMethodTemp->uidName);
		}
	    else if( pstMethodTemp->pstClass->uidName[0] == '[')
		{
		    pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
		}
	    else if( strstr(pstMethodTemp->pstClass->uidName, "cavalry/translator"))
		{
		    pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
		}
	    else if( strstr(pstMethodTemp->pstClass->uidName, "java/"))
		{
		    pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
		}
	    else if( strstr(pstMethodTemp->pstClass->uidName, "gnu/vm/"))
		{
		    pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
		}
	    else if(canStartOptimising)
		{
#ifdef SVETLANA_VERBOSE
		    fprintf(stderr, "Checking whether we can optimise a method %s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
#endif
		    pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;
		    
		    //replace this with a JAVA method call
		    {
			int i;
			jboolean canCompile;
			tClassLoaderTuple* AnalyserClass;
			tClassLoaderTuple* CompilerClass;
			tMethod* analyzeMethod;
			tARREF pstArrayTemp;
			tARREF pstArrayMachineCode;
			jstring methodName;
			jstring methodSig;
			int length = pstMethodTemp->pstCode->u32CodeLength;
			tStackFrame* tempFrame;
			tOBREF exception;
			int carryOnLooking = 1;
			int32 args[8];
			
			
			
			if((pstMethodTemp->u16AccessFlags & ACC_NATIVE) || (pstMethodTemp->u16AccessFlags & ACC_SYNCHRONISED))
			    carryOnLooking = 0;
			
			
//        if(pstMethodTemp->pstCode->u16ExceptionTableLength != 0)
//	       carryOnLooking = 0;
			
			
			if(strstr(pstMethodTemp->pstClass->uidName, "java"))
			    carryOnLooking = 0;
			
			//	if(strstr(pstMethodTemp->pstClass->uidName, "antlr"))
			//	       carryOnLooking = 0;
			
			if(strstr(pstMethodTemp->pstClass->uidName, "cavalry"))
			    carryOnLooking = 0;
			
#ifdef SVETLANA_VERBOSE
			fprintf(stderr, "CarryOnLooking is %i\n", carryOnLooking);
#endif
			if(carryOnLooking)
			    {
				AnalyserClass = CLASSFILE_FindOrLoad(env, "cavalry/translator/Analyzer", NULL);
				
				analyzeMethod = CLASSFILE_FindMethod(env, AnalyserClass, "canCompileMethod", "([BLjava/lang/String;Ljava/lang/String;Z)Z");
				assert(analyzeMethod);
				pstArrayTemp = INTERP_NewArray(env, T_BYTE, length, 0, NULL);
				for(i = 0; i < length;i++)
				    {
					((byte*) ADEREF(pstArrayTemp)->pvElements)[i] = pstMethodTemp->pstCode->pbCode[i];
				    }
				
				methodName = INTERP_NewStringFromAsciz(env, pstMethodTemp->uidName );
				methodSig = INTERP_NewStringFromAsciz(env, pstMethodTemp->uidSignature );
				
				//		args[1] = (int32) INTERP_NewObjectFromName("cavalry/translator/Analyzer");
				args[0] = (int32) pstArrayTemp;
				args[1] = (int32) methodName;
				args[2] = (int32) methodSig;
				args[3] = (int32) 0; //Don't force the check
				
				fprintf(stderr,"<");
				SAVEENV();
				tempFrame = InitialStackFrameHelper(analyzeMethod, NULL, args, pstCurrFrame->pstHeap, 1); //is an orphan frame
				//WE artificially link this frame to the current frame. This is just so that the GC can find this frame
				tempFrame->pstPrevFrame = pstCurrFrame;
				exception = Interpret( env, tempFrame, 1); 
				assert(exception == NULL);
				tempFrame->pstPrevFrame = NULL;
				canCompile = tempFrame->pi32OpTop[0];

#ifdef SVETLANA_VERBOSE
				fprintf(stderr,">");
				fprintf(stderr, "Result of canCompileM is %i (%s.%s)\n", canCompile, pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
#endif

				PopStackFrame(tempFrame);
				LOADENV();
				
				
				if(canCompile)
				    {
					tMethod* compileMethod;
					CompilerClass = CLASSFILE_FindOrLoad(env, "cavalry/translator/FastGenerator", NULL);
					compileMethod = CLASSFILE_FindMethod(env, CompilerClass, "compileMethod", "(Ljava/lang/Class;[BIILjava/lang/String;Ljava/lang/String;Z)[B");
					assert(compileMethod);
					if(pstMethodTemp->pstClass->classObject == NULL)
					    {
						CLASS_MakeClassObject(env, pstMethodTemp->pstClass);
					    }
					assert(pstMethodTemp->pstClass->classObject);
					
					fprintf(stderr, "can optimise a method %s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
					args[0] = (int32) INTERP_NewObjectFromName(env, "cavalry/translator/FastGenerator");
					args[1] = (int32) pstMethodTemp->pstClass->classObject;
					args[2] = (int) pstArrayTemp;
					args[3] = (int) env;
					
					args[4] = (int) pstMethodTemp->pstClass;
					args[5] = (int) INTERP_NewStringFromAsciz(env, pstMethodTemp->uidName);
					args[6] = (int) INTERP_NewStringFromAsciz(env, pstMethodTemp->uidSignature);
					args[7] = JNI_FALSE;
#ifdef SVETLANA_VERBOSE					
					fprintf(stderr,"[");
#endif
					SAVEENV();
					tempFrame = InitialStackFrameHelper(compileMethod, (tOBREF) args[0], args, pstCurrFrame->pstHeap, 1); //is an orphan frame
					//WE artificially link this frame to the current frame. This is just so that the GC can find this frame
					tempFrame->pstPrevFrame = pstCurrFrame;
					
					exception = Interpret( env, tempFrame, 1);
					assert(exception == NULL);
					tempFrame->pstPrevFrame = NULL;
					pstArrayMachineCode = (tARREF) tempFrame->pi32OpTop[0];
					//			assert(pstArrayMachineCode != NULL);
					PopStackFrame(tempFrame);
					LOADENV();

#ifdef SVETLANA_VERBOSE
					fprintf(stderr,"]");
					fprintf(stderr, "Result of compileMethod is %p\n", pstArrayMachineCode);
#endif		
					
					
					if(pstArrayMachineCode == NULL)
					    {
						pstMethodTemp->u16AccessFlags |= ACC_CANNOT_OPTIMISE;			
						pstMethodTemp->u16AccessFlags &= ~(ACC_OPTIMISED);			
					    }
					else
					    {
						void* pMethod = (void*) sys_malloc( ADEREF(pstArrayMachineCode)->i32Number );
						int ctr = 0;
						assert(pMethod);
						
						
						for(ctr = 0; ctr < ADEREF(pstArrayMachineCode)->i32Number;ctr++)
						    {
							((byte*)pMethod)[ctr] = ((byte*) ADEREF(pstArrayMachineCode)->pvElements)[ctr];
						    }
						
						pstMethodTemp->pstCode->pOptimisedCode = (int (*) (int32*, void*)) pMethod;
						
						pstMethodTemp->u16AccessFlags |= ACC_OPTIMISED;
						pstMethodTemp->u16AccessFlags &= ~(ACC_CANNOT_OPTIMISE);
						iCanOptimise = 1;
					    }
				    } //if we can compile
			    } //carryOnLooking
		    } //if we can optimised
		    
		} //if can start optimising
	    
	    if(iCanOptimise)
		{
		    int i32OptimisedRet;
		    tStackFrame* nativeStackFrame ;
		    int (*pMethod) (int32*,tStackFrame*);
		    
		    SAVEENV();
		    
		    //Just for debugging we don't do this yet
		    //	       pbPC[-3] = invokevirtual_quick_optimised;
		    //	       pbPC[-2] = pstMethodTemp->u16VTIndex;
		    //	       pbPC[-1] = pstMethodTemp->u16ArgSize; 
		    
		    
		    //Ok, quickly push a native stack frame
		    nativeStackFrame = PushNativeStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);	   
		    
		    pMethod = pstMethodTemp->pstCode->pOptimisedCode;
#ifdef SHOW_SVETLANA
		    fprintf(stderr, "Calling optimised method %p %s.%s (%s), arg 0 is %x, optop %p\n", pMethod, pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature, (int) *(optop - pstMethodTemp->u16ArgSize + 1), optop - pstMethodTemp->u16ArgSize + 1);
#endif
		    i32OptimisedRet = (*pMethod)(optop -  pstMethodTemp->u16ArgSize + 1, nativeStackFrame);
		    if(i32OptimisedRet != 0)
			{
			    nativeStackFrame->pstException = (tOBREF) i32OptimisedRet;
			    fprintf(stderr, "Got exception %p from optimised method\n", i32OptimisedRet);
			    pstCurrFrame = CatchExternalException(env, nativeStackFrame, (tOBREF) i32OptimisedRet);
			    LOADENV();
			    break;
			    //Excellent!
			    //		       assert( 1 == 2);
			}
		    PopStackFrame( nativeStackFrame );
		    LOADENV();
		    if(pstMethodTemp->u16RetSize == 0)
			optop -= (pstMethodTemp->u16ArgSize);
		    else if(pstMethodTemp->u16RetSize == 1)
			optop -= (pstMethodTemp->u16ArgSize) - 1;
		    else if(pstMethodTemp->u16RetSize == 2)
			{
			    int32 temp;
			    //		       assert( 1  ==2 );
			    optop -= (pstMethodTemp->u16ArgSize) - 2;
			    temp = *optop;
			    *optop = *(optop - 1);
			    *(optop - 1) = temp;
			    fprintf(stderr,"2 ret Optop is %x\n", *optop);
			}
		    else
			assert( 7 == 8);
		    SAVEENV();
#ifdef SHOW_SVETLANA
		    fprintf(stderr, "Called method, %s returned %p\n", pstMethodTemp->uidName, *optop);
		    if(pstMethodTemp->u16RetSize == 2)
			fprintf(stderr, "Called method, %s returned %p (lo) %p (hi)\n", pstMethodTemp->uidName, *(optop - 1), *(optop));
#endif
		    break;
		}
	    
#endif
	    
	    /*
	      #ifdef SHOW_CALLS
	      if(show)
	      fprintf(stderr, "%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
	      #endif
	    */
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
	    
	    if (iMultiThread)
		{
		    if(pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
	}
    break;
}
#endif /* RES_QUICK */

case invokespecial:  // AKA invokenonvirtual
{
    int16         i16Temp;
    tMethod*      pstMethodTemp;
    int32         i32NativeRet;
#ifdef QUICK2
    int16         i16CurrCTIndex;
    int16         i16MethodIndex;
    tClass*       pstClassTemp;
#endif

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap, sys_current_thread() );
#endif
    
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
#ifdef DEBUG
    assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
    
pstMethodTemp = CONSTGET_MethodNonVirtual(env, pstCurrClass, i16Temp);

    if(!(pstMethodTemp))
      {
	tOBREF pstExOb = (*env)->ExceptionOccurred(env);
	if(pstExOb)
	  {
	    SAVEENV();
	    pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
	    LOADENV();
	  }
	else
	  {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NoSuchMethodError");
	    LOADENV();
	  }
	break;
      }
    
if(pstMethodTemp->u16AccessFlags & ACC_STATIC)
  {
	eprintf("3. The method %s.%s%s was meant to be static\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature);
    SAVEENV();
    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/IncompatibleClassChangeError");
    LOADENV();
    break;
  }

#ifdef RESURRECT_QUICK
#ifdef QUICK2
    pstClassTemp = pstMethodTemp->pstClass;
    
    /* Search for it in the Class Table */
    for (i16CurrCTIndex = 0; i16CurrCTIndex < pstCurrClass->u16CTSize; i16CurrCTIndex++)
        {
	    if (pstCurrClass->ppstCT[i16CurrCTIndex] == pstClassTemp)
		{
		    break;
		}
        }
    /* If we still haven't found it, then add it to the CT - but only up to 256 */
    if ((i16CurrCTIndex == pstCurrClass->u16CTSize) && (i16CurrCTIndex < 256))
        {
  				/* Entry is not yet valid - make a new entry in the CT */
	    pstCurrClass->ppstCT[pstCurrClass->u16CTSize++] = pstClassTemp;
        }
#ifndef USEOSKIT
    assert(pstClassTemp == pstCurrClass->ppstCT[i16CurrCTIndex]);
#endif
    /* We now have everything we need - pstMethodTemp will tell us where
       it is in the methods array, and i16CurrCTIndex is the CT index of
       the class */
    i16MethodIndex = (pstMethodTemp - pstClassTemp->pstMethods);
    /* so now create a _quick instruction */
    assert(i16MethodIndex < 256);
    assert(i16CurrCTIndex < 256);
    
    pbPC[-2] = i16MethodIndex;  /* method index */
    /* check to see if class is current class */
    if (pstClassTemp == pstCurrClass)
        {
	    pbPC[-3] = invokenonvirtualcurrclass_quick;
        }
    else
        {
	    pbPC[-3] = invokenonvirtual_quick;
	    pbPC[-1] = i16CurrCTIndex;
        }
#else
    /* overwrite instruction with _quick instruction */
    pbPC[-3] = invokespecial_quick;
    /* The CP slot was automatically overwritten with pstMethodTemp */
    /*        CONSTSET(pstCurrClass, i16Temp, pstMethodTemp);*/
#endif /* QUICK2 */
#endif /* RES_QUICK */
    
    if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
        }
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
	{
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
        }
    else //not native
	{
	    //	if( SVETLANA_CanOptimiseMethod( pstMethodTemp->pstCode->pbCode, pstMethodTemp->pstCode->u32CodeLength) )
	    //	    fprintf(stderr, "Can optimise method %s\n", pstMethodTemp->uidName);
	    
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
	    if (iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
        }
    break;
}
#ifdef RESURRECT_QUICK
#ifdef QUICK2
case invokenonvirtualcurrclass_quick:
{
    int32        i32NativeRet;
    int16        i16MethodIndex;
    tMethod*     pstMethodTemp;
    
    i16MethodIndex = (*pbPC++);    /* method index */
    pbPC++;
    
    pstMethodTemp = &(pstCurrClass->pstMethods[i16MethodIndex]);
    
    if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
        }
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env,pstCurrFrame);
		}
	    LOADENV();
        }
    else
        {
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
	    
	    if(iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
        }
    break;
}

case invokenonvirtual_quick:
{
    int32        i32NativeRet;
    int16        i16MethodIndex;
    int16        i16ClassIndex;
    tClass*      pstClassTemp;
    tMethod* pstMethodTemp;
    int show = 1;


#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pthread_self() );
#endif
    
    i16MethodIndex = (*pbPC++);    /* method index */
    i16ClassIndex = (*pbPC++);    /* class table index */
    
    pstClassTemp = pstCurrClass->ppstCT[i16ClassIndex];
    pstMethodTemp = &(pstClassTemp->pstMethods[i16MethodIndex]);
    
    if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
        }
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env,pstCurrFrame);
		}
	    LOADENV();
        }
    else
        {
	    
#ifdef SHOW_CALLS
	    if(show)
		fprintf(stderr, "%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
#endif
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
	    
	    if(iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
        }
    break;
}
#else
//Here we go
case invokespecial_quick:
{
    int16        i16Temp;
    int32        i32NativeRet;
    tMethod* pstMethodTemp;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread());
#endif
    
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
    pstMethodTemp = (tMethod*) CONSTGET(pstCurrClass->pstClass, i16Temp);
    
    if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
        }
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env,pstCurrFrame);
		}
	    LOADENV();
        }
    else
        {
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
	    LOADENV();
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
	    if (iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
        }
    break;
}
#endif /* QUICK2 */
#endif /* RES_QUICK */

case invokestatic:
{
    int16         i16Temp;
    tMethod*	    pstMethodTemp;
    int32         i32NativeRet;
#ifdef QUICK2
    int16         i16CurrCTIndex;
    int16         i16MethodIndex;
    tClass*       pstClassTemp;
#endif

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread());
#endif
    
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
#ifdef DEBUG
    assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
    
    pstMethodTemp = CONSTGET_MethodStatic(env, pstCurrClass, i16Temp);

    if(!(pstMethodTemp))
      {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NoSuchMethodError");
	    LOADENV();
	    break;
      }

    if(!(pstMethodTemp->u16AccessFlags & ACC_STATIC))
      {
	eprintf("4. The method %s.%s%s was not meant to be static\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, pstMethodTemp->uidSignature);
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/IncompatibleClassChangeError");
	    LOADENV();
	    break;
      }

#ifdef DEBUG
    assert(pstMethodTemp->u16AccessFlags & ACC_STATIC);
#endif
    
    
#ifdef SHOW_CALLS
    {
	
	int show = 1;
	
	if(strcmp(pstMethodTemp->uidName, "arraycopy") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "length") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "valueOf") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "append") == 0)
	    show = 0;
	if(strcmp(pstMethodTemp->uidName, "convertToChar") == 0)
	    show = 0;
	if(show)
	    fprintf(stdout, "~%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
    }
#endif
    
#ifdef QUICK
#ifdef QUICK2
    pstClassTemp = pstMethodTemp->pstClass;
    
    /* Search for it in the CT */
    for (i16CurrCTIndex = 0; i16CurrCTIndex < pstCurrClass->u16CTSize; i16CurrCTIndex++)
        {
	    if (pstCurrClass->ppstCT[i16CurrCTIndex] == pstClassTemp)
		{
		    break;
		}
	}
				/* If we still haven't found it, then add it to the CT - but only up to 256 */
    if ((i16CurrCTIndex == pstCurrClass->u16CTSize) && (i16CurrCTIndex < 256))
        {
	    /* Entry is not yet valid - make a new entry in the CT */
	    pstCurrClass->ppstCT[pstCurrClass->u16CTSize++] = pstClassTemp;
	}
    assert(pstClassTemp == pstCurrClass->ppstCT[i16CurrCTIndex]);
    
    /* We now have everything we need - pstMethodTemp will tell us where it is in the methods array,
       and i16CurrCTIndex is the CT index of the class */
    i16MethodIndex = (pstMethodTemp - pstClassTemp->pstMethods);
    /* so now create a _quick instruction */
    assert(i16MethodIndex < 256);
    assert(i16CurrCTIndex < 256);
    
    pbPC[-2] = i16MethodIndex;  /* method index */
    /* check to see if class is current class */
    if (pstClassTemp == pstCurrClass)
        {
	    pbPC[-3] = invokestaticcurrclass_quick;
        }
    else
        {
	    pbPC[-3] = invokestatic_quick;
	    pbPC[-1] = i16CurrCTIndex;
        }
#else
    pbPC[-3] = invokestatic_quick;
    /*        CONSTSET(pstCurrClass, i16Temp, pstMethodTemp);*/
#endif /* QUICK2 */
#endif /* QUICK */

    if(pstMethodTemp == NULL)
      {
	tOBREF pstExOb;
	
	pstExOb = JNI_getJNIData( sys_current_thread())->pstException;
	if(pstExOb)
	  {
	    /*	    pstCurrFrame->pstException = pstExOb; XXX is this necessary ? */
	    SAVEENV();
	    pstCurrFrame = CatchExceptionHelper(env,pstCurrFrame, pstExOb);	
	    LOADENV();
	    break;
	  }
	else
	  {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/InternalError");
	    LOADENV();
	    break;
	  }
      }
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
	{
#ifdef SHOW_CALLS
	    if(!(strstr(pstMethodTemp->uidName, "arraycopy")))
		fprintf(stderr, "~Invoking native method %s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
#endif
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    
#ifdef DEBUG_EXCEPTIONS
		    printf("INTERP: Calling catch exception from within invokestatic\n");
		    printf("INTERP: The method is ~%s.%s\n", pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
		    printf("INTERP: The current frame is %x, with exception %x\n", pstCurrFrame, pstCurrFrame->pstException); 
		    
#endif
		    pstCurrFrame = CatchException(env,pstCurrFrame);
		}
	    LOADENV();
        }
    else
	{
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	    LOADENV();
	    if (iMultiThread)
		{
		    if(pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			  //this is a static call, so this NULL check is wrong -- jewel
			  //it should actually be a check for the class object
			  jclass sclass =  CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass);
			  assert(sclass);
			  /*			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else*/
				THREAD_SynchroniseEnter(sclass);
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
        }
    break;
}

#ifdef QUICK
#ifdef QUICK2
case invokestaticcurrclass_quick:
{
    int32         i32NativeRet;
    int16         i16MethodIndex;
    tMethod*	    pstMethodTemp;
    
    i16MethodIndex = (*pbPC++);    /* method index */
    pbPC++;
    
    pstMethodTemp = &(pstCurrClass->pstMethods[i16MethodIndex]);
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
	}
    else
        {
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	    LOADENV();
	    
	    if (iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
        }
    break;
}

case invokestatic_quick:
{
    int32         i32NativeRet;
    int16         i16MethodIndex;
    int16         i16ClassIndex;
    tClass*       pstClassTemp;
    tMethod*	    pstMethodTemp;
    
    i16MethodIndex = (*pbPC++);    /* method index */
    i16ClassIndex = (*pbPC++);    /* class table index */
    
    pstClassTemp = pstCurrClass->ppstCT[i16ClassIndex];
    pstMethodTemp = &pstClassTemp->pstMethods[i16MethodIndex];
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
	}
    else
        {
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	    LOADENV();
	    
	    if (iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
        }
    break;
}
#else
case invokestatic_quick:
{
    int16         i16Temp;
    int32         i32NativeRet;
    tMethod*	pstMethodTemp;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint( pthread_self() );
#endif
    
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
    pstMethodTemp = (tMethod*) CONSTGET(pstCurrClass, i16Temp);
    
    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
        {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
	}
    else
        {
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	    LOADENV();
	    
	    if (iMultiThread)
		{
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
			{
			    if(pstCurrFrame->pstCurrObject == NULL)
				{
				    SAVEENV();
				    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
				    LOADENV();
				}
			    else
				THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
			}
		}
	    else
		{
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		}
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
        }
    break;
}
#endif /* QUICK2 */
#endif /* QUICK */
case invokeinterface:
{
	#ifdef TEASEME
	int	     iIsIPC;    //is this an ipc call?
	tAllocatorHeap*	     pstNewHeap = NULL;//heap for new context
	#endif

    int16        i16Temp;
    tMethod*     pstRightMethod = NULL;
    tMethod*     pstFirstMethod;
    tClassLoaderTuple*      pstClassTemp;
    int32        i32NativeRet;
    uint16       u16ArgLen;
    uint16       u16VTGuess;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap, sys_current_thread() );
#endif

#ifdef TEASEME
    iIsIPC = 0;    
#endif
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);

    assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_InterfaceMethodref);
    
    /* get argument length */
    u16ArgLen = (*pbPC++);
    pbPC++;             /* reserved field according to spec */
    
    if ((tOBREF) *(optop - u16ArgLen + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
	    
	    break;
        }

        /* get method normally */
        pstFirstMethod = CONSTGET_MethodInterface(env, pstCurrClass, i16Temp, optop, u16ArgLen);

	/* XXX figure out what to do here
    if(!(pstFirstMethod->u16AccessFlags & ACC_INTERFACE))
      {
	eprintf("5. The method %s.%s%s was meant to be an interface\n", pstFirstMethod->pstClass->uidName, pstFirstMethod->uidName, pstFirstMethod->uidSignature);
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/IncompatibleClassChangeError");
	    LOADENV();
	    break;
      }
      */

        u16VTGuess = pstFirstMethod->u16VTIndex;


        pstClassTemp = DEREF((tOBREF) *(optop - u16ArgLen + 1))->pstType;

	#ifdef TEASEME
	//Check if we have to do a context switch
	if(pstFirstMethod->u16AccessFlags & ACC_IPC_METHOD)
	  {
	    tOBREF targetObject;
	    tClassLoaderTuple* baseClass;
#ifdef SHOW_CONTEXT_SWITCH
	eprintf("doing context switch\n");
#endif

	    //the target object must be an instance of teaseme/system/ipc_interfaces/JOSServer
	    targetObject = (tOBREF) *(optop - u16ArgLen + 1);
	    baseClass = CLASSFILE_FindOrLoad(env, "teaseme/system/ipc_interfaces/JOSServer", NULL); //~XXX fixpstClassType); 

	    if( INTERP_CheckCast(env, baseClass, pstClassTemp))
	      {
		int i = 0;
		int numArgs;
		//We first extract the process pointer
		tOBREF josProcess;
		tField* field;

		
		field = CLASSFILE_InstFieldOffset(env, pstClassTemp, "process");

		//Now get the process object 
		josProcess = (tOBREF) DEREF(targetObject)->pi32Vars[field->u16Offset];

		if(josProcess == NULL)
		    {
#ifdef SHOW_CONTEXT_SWITCH
			eprintf("JOSProcess object was null in ipc_method\n");
#endif
			SAVEENV();
			pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
			LOADENV();
			break;
		    }
		field = CLASSFILE_InstFieldOffset(env, DEREF(josProcess)->pstType, "_heap");
		iIsIPC = 1;

		//now we have to extract the heap pointer from the targetObject
		pstNewHeap = (void*) DEREF(josProcess)->pi32Vars[field->u16Offset];

		numArgs = CLASSFILE_CalcNumArguments( pstFirstMethod->uidSignature );
		//Now create external references for all the non-primitive parameters
		for(i = 1; i < numArgs;i++) //we skip the first ref
		  {
		    int slotOffset;
		    int isRef = CLASSFILE_IsArgumentRef( pstFirstMethod->uidSignature, i, &slotOffset);
		    assert((isRef == 0) || (isRef == 1));
		    if(isRef == 1)
		      {
			tOBREF ref = (tOBREF) (optop - u16ArgLen + 1)[slotOffset];
			if(ref != NULL)
			  {
	#ifdef SHOW_CONTEXT_SWITCH
			    eprintf("Adding ref to %p (originating from %p)\n", ref,pstNewHeap);
	#endif
			  JOSPROCESS_addExternalRef( pstCurrFrame->pstHeap, ref, pstNewHeap);
			  }
		      }
		  }
	      }
	    else
	      {
		//throw an exception or something
		eprintf("******|||||||||||||************* error in ipc_call ************|||||||||||||||***********\n");
	      }
	  }
	else
	  {
#ifdef SHOW_CONTEXT_SWITCH
	    eprintf("%s is not IPC\n", pstFirstMethod->pstClass->uidName);
#endif
	  }
	#endif

        /* must check to see if method that we looked up is actually the
           same method that we need, i.e. check to see if the method at the
           recorded VT index is the same as the one at that index of the
           needed class's VT */
	if (pstFirstMethod->u16VTIndex < pstClassTemp->pstClass->u16VTSize)
        {
	    /* check to see if the method at the guess index has the correct name
	       and signature */
	    if ((uidcmp(pstClassTemp->pstClass->ppstVT[u16VTGuess]->uidName, pstFirstMethod->uidName) == 0)	&&
		(uidcmp(pstClassTemp->pstClass->ppstVT[u16VTGuess]->uidSignature, pstFirstMethod->uidSignature) == 0))
		{
		    pstRightMethod = pstClassTemp->pstClass->ppstVT[u16VTGuess];
		}
	    else
		{
		    pstRightMethod = NULL;
		}
	}
	
        /* find the correct method if we don't have it already */
        while (pstRightMethod == NULL)
	  {
#ifdef SHOW_CONTEXT_SWITCH
	eprintf("Getting method interface (finding correct method %s)\n", pstFirstMethod->uidName);
#endif
	    pstRightMethod = CLASSFILE_UidFindMethod(env, pstClassTemp, pstFirstMethod->uidName, pstFirstMethod->uidSignature);
	    if (pstRightMethod == NULL)
		{
		    /* check if we've still got more superclasses to check */
		    if (pstClassTemp->pstClass->pstSuperClass == NULL)
			{
			    eprintf("InvokeInterface: method reference not resolved %s.%s(%s) %s\n", pstFirstMethod->pstClass->uidName, pstFirstMethod->uidName, pstFirstMethod->uidSignature, pstClassTemp->uidName); ///XXX throw exception
			    exit(1);
			    break;
			}
		    /* go to superclass */
		    pstClassTemp = pstClassTemp->pstClass->pstSuperClass;
		}
        }
    
#ifdef SHOW_CALLS
     eprintf( "*%s.%s\n", pstClassTemp->uidName, pstRightMethod->uidName);
#endif
        #ifdef QUICK
        /* Change this to a _quick instruction with a guess. */
	pbPC[-5] = invokeinterface_quick;
        pbPC[-1] = pstRightMethod->u16VTIndex;
        #endif
	
        if ((tOBREF) *(optop - pstFirstMethod->u16ArgSize + 1) == NULL)
        {
	    SAVEENV();
	    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	    LOADENV();
        }

	if (pstRightMethod->u16AccessFlags & ACC_NATIVE)
	{
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstRightMethod);
	    if (i32NativeRet == -1)
		{
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		}
	    LOADENV();
        }
    else
	{
	    SAVEENV();
	    pstCurrFrame = PushStackFrame(pstRightMethod, (tOBREF) *(optop - pstRightMethod->u16ArgSize + 1), pstCurrFrame);

	    #ifdef TEASEME
	    if(iIsIPC)
	      {
		//Do the context switch
		pstCurrFrame->pstHeap = pstNewHeap;
		//we must also make external refs to any refs passed in this call
		//XXX
	      }
	    #endif
	    LOADENV();
	    if (iMultiThread)
	      {
		if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
		  {
		    if(pstCurrFrame->pstCurrObject == NULL)
		      {
			SAVEENV();
			pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
			LOADENV();
		      }
		    else
		      THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
		  }
	      }
	    else
	      {
#ifdef MDEBUG
		printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	      }
	  }
	break;
      }
case invokeinterface_noguess:
{
    int16        i16Temp;
    tMethod*     pstMethodTemp;
    tMethod*     pstRightMethod;
    tClassLoaderTuple*      pstClassTemp;
    int32        i32NativeRet;
    uint16       u16ArgLen;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap, sys_current_thread() );
#endif
    
    i16Temp = (*pbPC++) * 256;
    i16Temp += (*pbPC++);
    
#ifdef DEBUG
    assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_InterfaceMethodref);
#endif
    
    /* get argument length */
    u16ArgLen = (*pbPC++);
    pbPC++;             /* reserved field according to spec */
    
    /* get method normally */
    pstMethodTemp = CONSTGET_MethodInterface(env, pstCurrClass, i16Temp, optop, u16ArgLen);
    
    /* find the correct method */
    pstRightMethod = NULL;
    pstClassTemp = DEREF((tOBREF) *(optop - u16ArgLen + 1))->pstType;
    while (pstRightMethod == NULL)
        {
          pstRightMethod = CLASSFILE_UidFindMethod(env,pstClassTemp, pstMethodTemp->uidName, pstMethodTemp->uidSignature);
          if (pstRightMethod == NULL)
          {
            /* check if we've still got more superclasses to check */
            if (pstClassTemp->pstClass->pstSuperClass == NULL)
            {
              eprintf( "InvokeInterface: method reference not resolved\n");
              break;
            }
            /* go to superclass */
            pstClassTemp = pstClassTemp->pstClass->pstSuperClass;
          }
        }

        if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
/*          LOADENV();*/
        }

				if (pstRightMethod->u16AccessFlags & ACC_NATIVE)
				{
          SAVEENV();
          i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
          if (i32NativeRet == -1)
          {
					  pstCurrFrame = CatchException(env, pstCurrFrame);
          }
				  LOADENV();
        }
				else
				{
  				SAVEENV();
					pstCurrFrame = PushStackFrame(pstRightMethod, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
					LOADENV();
					if (iMultiThread)
          {
						if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
            {
						  if(pstCurrFrame->pstCurrObject == NULL)
						      {
							  SAVEENV();
							  pstCurrFrame = ThrowNamedException(env,pstCurrFrame, "java/lang/NullPointerException");
							  LOADENV();
						      }
						  else
							THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
						}
					}
					else
          {
					  #ifdef MDEBUG
						printf("Warning - Monitor Enter in single-threaded mode.\n");
						#endif
          }
        }
			  break;
			}

			#ifdef QUICK
			case invokeinterface_quick:
			{
			  #error not yet
				int16        i16Temp;
				int16        i16ArgSize;
				int16        i16VTGuess;
				int32        i32NativeRet;
				tClass*      pstClassTemp;
				tMethod*     pstMethodTemp;
				tMethod*     pstFirstMethod;

#ifdef GARBAGE2
    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap, sys_current_thread() );
#endif

				i16Temp = (*pbPC++) * 256;
				i16Temp += (*pbPC++);

				assert(CONSTTAG(pstCurrClass, i16Temp) == CONSTANT_InterfaceMethodref);

				/* get argument length */
				i16ArgSize = (*pbPC++);
				i16VTGuess = (*pbPC++);  /* Guess. For us this is a VT index. */

        /* get method */
        pstFirstMethod = CONSTGET_MethodInterface(pstCurrClass, i16Temp, optop, i16ArgSize);

				/* retrieve class pointer through handle on stack */
	//Jewel sep
				pstClassTemp = (DEREF((tOBREF) (*(optop + 1 - i16ArgSize))))->pstType;

				/* First try the guess */
        /* check if it's inside the range of the VT */
				if (i16VTGuess < pstClassTemp->u16VTSize)
        {
          /* check to see if the method at the guess index has the correct name
             and signature */
					if ((uidcmp(pstClassTemp->ppstVT[i16VTGuess]->uidName, pstFirstMethod->uidName) == 0)	&&
              (uidcmp(pstClassTemp->ppstVT[i16VTGuess]->uidSignature, pstFirstMethod->uidSignature) == 0))
          {
            pstMethodTemp = pstClassTemp->ppstVT[i16VTGuess];
					}
					else
          {
					  pstMethodTemp = NULL;
					}
				}

				/* Recursive search from current class up its hierachy.
           This will not happen if the above guess was correct, since in that
           case pstMethodTemp != NULL */

				while (pstMethodTemp == NULL && pstClassTemp != NULL)
				{
					pstMethodTemp = CLASSFILE_UidFindMethod(env, pstClassTemp, pstFirstMethod->uidName, pstFirstMethod->uidSignature);
					if (pstMethodTemp == NULL)
					{
            /* check if we have reached the top of the hierarchy */
						if (pstClassTemp->pstSuperClass == NULL)
						{
							pstClassTemp = NULL;
							break;  /* get out of the while loop */
						}
						pstClassTemp = pstClassTemp->pstSuperClass;
					}
				}

        if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL)
        {
          SAVEENV();
          pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
          LOADENV();
        }

	if (pstClassTemp && pstMethodTemp)
	  {
	    if (pstMethodTemp->u16AccessFlags & ACC_NATIVE)
	      {
		SAVEENV();
		i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
		if (i32NativeRet == -1)
		  {
		    pstCurrFrame = CatchException(env, pstCurrFrame);
		  }
		LOADENV();
	      }
	    else
	      {
		SAVEENV();
		pstCurrFrame = PushStackFrame(pstMethodTemp, (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), pstCurrFrame);
		LOADENV();
		
#ifdef DEBUG_TRACE
		iIndent++;
#endif
		
		if (iMultiThread)
		  {
		    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
		      {
			if(pstCurrFrame->pstCurrObject == NULL)
			  {
			    SAVEENV();
			    pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
			    LOADENV();
			  }
			else
			  THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
		      }
		  }
		else
		  {
#ifdef MDEBUG
		    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
		  }
	      }
	  }
	else
	  {
	    eprintf("Interface method %s.%s(%s) not resolved (most derived class: %s)", pstClassTemp->uidName, pstFirstMethod->uidName, pstFirstMethod->uidSignature, pstClassTemp->uidName);
	    exit(1);
	  }
	break;
			}
#endif /* QUICK */
