case ireturn: /* group together the 32-bit returns */
case freturn:
case areturn:
{
      /* Do the monitor release if this is a synchronised method */
      if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
	{
	  if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_STATIC)
	      THREAD_SynchroniseExit(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	  else
	      THREAD_SynchroniseExit(pstCurrFrame->pstCurrObject);
	}

  if(pstCurrFrame->bIsOrphan)
    {
      SAVEENV();
      return pstCurrFrame->pstException;
    }

  /* check if this is an initial stack frame, ie first in a thread */
  if (pstCurrFrame->pstPrevFrame == NULL)
    {
      pstCurrFrame->pi32OpTop = optop;
      if (!pstCurrFrame->pstException && pstThreadList)
	{
	  THREAD_Destroy( (jobject) java_lang_Thread_nativeCurrentThread( NULL, NULL));  /* this thread is dead and we want to change */
	}
      
       return pstCurrFrame->pstException;
    }

  /* push return value onto previous stack */

  *(++(pstCurrFrame->pstPrevFrame->pi32OpTop)) = *optop;

  pstCurrFrame = PopStackFrame(pstCurrFrame);
  LOADENV();
  break;
} //end of areturn, freturn, ireturn

case lreturn: /* group together the 64-bit returns */
case dreturn:
{
  /* Do the monitor release if this is a synchronised method */
  if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
    {
      if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_STATIC)
	{
	  if(pstCurrFrame->pstCurrClass == NULL)
	    {
	      SAVEENV();
	      pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	      LOADENV();
	    }
	  else
	    THREAD_SynchroniseExit(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	}
      else
	{
	  if(pstCurrFrame->pstCurrObject == NULL)
	    {
	      SAVEENV();
	      pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
	      LOADENV();
	    }
	  else
	    THREAD_SynchroniseExit(pstCurrFrame->pstCurrObject);
	}
    }


  if(pstCurrFrame->bIsOrphan)
    {
      SAVEENV();
      return pstCurrFrame->pstException;
    }

  /* check if this is an initial stack frame, ie first in a thread */
  if (pstCurrFrame->pstPrevFrame == NULL)
    {
      pstCurrFrame->pi32OpTop = optop;
      if (!pstCurrFrame->pstException)
	{
	      THREAD_Destroy(NULL);  /* this thread is dead and we want to change */
	      goto LabelLoopTop;
	}
      return pstCurrFrame->pstException;
    }

  /* push return value onto previous stack */
  *(++(pstCurrFrame->pstPrevFrame->pi32OpTop)) = *(optop - 1);
  *(++(pstCurrFrame->pstPrevFrame->pi32OpTop)) = *optop;

  pstCurrFrame = PopStackFrame(pstCurrFrame);
  LOADENV();
  break;
}

case return_:
{
      /* Do the monitor release if this is a synchronised method */
      if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED)
	{
	  if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_STATIC)
	    {
	      THREAD_SynchroniseExit(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	    }
	  else
	    {
	      if(pstCurrFrame->pstCurrObject == NULL)
		{
		  SAVEENV();
		  pstCurrFrame = ThrowNamedException(env, pstCurrFrame, "java/lang/NullPointerException");
		  LOADENV();
		}
	      else
		THREAD_SynchroniseExit(pstCurrFrame->pstCurrObject);
	    }
	}
	    
	    
  if(pstCurrFrame->bIsOrphan)
    {
      SAVEENV();
      return pstCurrFrame->pstException;
    }
	    
  /* check if this is an initial stack frame, ie first in a thread */
	    
  if (pstCurrFrame->pstPrevFrame == NULL)
    {
      pstCurrFrame->pi32OpTop = optop;
      return pstCurrFrame->pstException;
    }	    
	    
  pstCurrFrame = PopStackFrame(pstCurrFrame);
  LOADENV();
  break;
}
