#include "interp.h"

/* function prototypes *****************************************************/


int INTERP_CheckCast(JNIEnv* env, tClassLoaderTuple*, tClassLoaderTuple*);
tOBREF INTERP_Interpret(JNIEnv* env, void* arg1, int arg2);

tOBREF INTERP_RunNonVirtualMethod(  JNIEnv* env, tClassLoaderTuple*, char* classname, char* methodname, char* methodsig, int32* ArgumentStack);
tOBREF INTERP_RunNonVirtualMethodFromPtr(JNIEnv* env, tMethod* pstMethod, int32* pi32Args);
tOBREF INTERP_RunNonVirtualMethodFromPtr_with_native_stack(  JNIEnv* env,tMethod* pstMethod, int32* pi32Args);


tOBREF INTERP_RunVirtualMethod(  JNIEnv* env, tClassLoaderTuple*, char* classname, char* methodname, char* methodsig, int32* ArgumentStack);
tOBREF INTERP_RunVirtualMethodFromPtr(  JNIEnv* env,tMethod* pstMethod, int32* pi32Args);
tOBREF INTERP_RunVirtualMethodFromPtr_with_native_stack
(
  JNIEnv* env,
  tMethod* pstMethod,
  int32* pi32Args
);

tOBREF INTERP_RunSpecialMethodFromPtr(    JNIEnv* env,tMethod* pstTheMethod,   /* @parm Pointer to Java method to execute */
  int32*   pi32Args        /* @parm Pointer to arguments to use */);
tOBREF INTERP_RunSpecialMethodFromPtr_with_native_stack
(
  JNIEnv* env,
  tMethod* pstTheMethod,   /* @parm Pointer to Java method to execute */
  int32*   pi32Args        /* @parm Pointer to arguments to use */
);


tOBREF INTERP_RunStaticMethod(JNIEnv* env, tClassLoaderTuple*, char* classname, char* methodname, char* methodsig, int32* ArgumentStack);
tOBREF INTERP_RunStaticMethodFromPtr(  JNIEnv* env,tMethod* pstMethod, int32* pi32Args);
tOBREF INTERP_RunStaticMethodFromPtr_with_native_stack(  JNIEnv* env,tMethod* pstMethod, int32* pi32Args);


tStackFrame* CatchExternalException(  JNIEnv* env,tStackFrame* pstOldFrame  /* @parm Environment stack frame to use */,
				      tOBREF pstExOb);
tStackFrame* CatchException(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* CatchExceptionHelper(JNIEnv* env, tStackFrame* pstOldFrame,  /* @parm Environment stack frame to use */  tOBREF pstExOb);


tStackFrame* ThrowNamedExceptionWithMessage
(
 JNIEnv* env,
  tStackFrame* pstOldFrame, /* @parm Environment stack frame to use */
  char* pszExName,           /* @parm Name of exception to throw */
  char* message              /* @parm Message for the exception (all exceptions should subclass java/lang/Throwable */
);
tOBREF INTERP_ExceptionObjectFromNameAndMessage(JNIEnv* env,
  char* pszExName,           // @parm Name of exception 
  char* message              /* @parm Message for the exception (all exceptions should subclass java/lang/Throwable */
);
tStackFrame* ThrowNamedException
(
  JNIEnv* env,
  tStackFrame* pstOldFrame, /* @parm Environment stack frame to use */
  char* pszExName           /* @parm Name of exception to throw */
);

int INTERP_FigureOutLineNumber(tStackFrame* pstFrame);
void INTERP_printStackTrace(JNIEnv* env, tOBREF exceptionObject);

int shutdown_machine(tOBREF pstExOb, int forced_shutdown, int retval);

#ifdef PRELOAD
/*
 * @globalv
 * This is a pointer to memory used for static class fields when preloaded
 * classes are being used.
 *
 */
extern int32* INTERP_pi32GlobalStatVars;
extern tOBREF* INTERP_ppstGlobalClassObjects;
extern JNINativeMethod* INTERP_pstGlobalNativeMethods;
extern byte* INTERP_pbGlobalInitialised;
#endif

#ifdef GARBAGE
extern int32* INTERP_pi32MainStack;
extern tStackFrame** INTERP_ppstCurrFrame;
#endif

#ifdef DEBUG_TRACE
extern int INTERP_DebugOn;
#endif


tOBREF Interpret(	JNIEnv* env,	tStackFrame* pstInitFrame,  /* @parm Initial environment frame */	int          iMultiThread   /* @parm 1 for multithread, 0 for single thread */);
tStackFrame* ThrowOOMException(JNIEnv* env, tStackFrame* pstOldFrame);

tOBREF INTERP_ConstructMainThread(JNIEnv* env);

#ifdef DEBUG_TRACE
//static void StackInspect(tStackFrame*, int32*);
#endif




#define SAVEENV() { pstCurrFrame->pbPC = pbPC; \
		    pstCurrFrame->pi32OpTop = optop; \
		  }

#ifdef NATIVE_THREADS
#define LOADENV() { pbPC = pstCurrFrame->pbPC; \
		    optop = pstCurrFrame->pi32OpTop; \
		    pi32Vars = pstCurrFrame->pi32Vars; \
                    pstCurrClass = pstCurrFrame->pstCurrClass; \
		  }
#else
#define LOADENV() { pbPC = pstCurrFrame->pbPC; \
		    optop = pstCurrFrame->pi32OpTop; \
		    pi32Vars = pstCurrFrame->pi32Vars; \
                    pstCurrClass = pstCurrFrame->pstCurrClass; \
		  }
#endif






