/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#ifdef HAVE_JVMDI

#include "thread.h"
#include "jvmdi.h"
#include "jvmdi_methods.h"
#include "threads_native.h"

jlocation alocation;




jvmdiError defaultAllocHook(jint size, jbyte** memPtr)
{
  void* result;
    if(memPtr == NULL)
      {
	return JVMDI_ERROR_NULL_POINTER;
      }

    result = sys_malloc(size);
  if(result == NULL)
    {
      return JVMDI_ERROR_OUT_OF_MEMORY;
    }
  *memPtr = (jbyte*) result;
  return JVMDI_ERROR_NONE;
}

jvmdiError defaultDeallocHook(jbyte* buffer)
{
  if(buffer == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  sys_free(buffer);
  return JVMDI_ERROR_NONE;
}


//These should be stored in a state structure, for now they are global
JVMDI_AllocHook ourAllocHook = &defaultAllocHook;
JVMDI_DeallocHook ourDeallocHook = &defaultDeallocHook;

jvmdiError
JVMDI_SetAllocationHooks(JVMDI_AllocHook ahook, JVMDI_DeallocHook dhook)
{
  if((ahook == NULL) && (dhook == NULL))
    {
      ourAllocHook = &defaultAllocHook;
      ourDeallocHook = &defaultDeallocHook;
    }
  if(ahook == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  if(dhook == NULL)
    return JVMDI_ERROR_NULL_POINTER;

  ourAllocHook = ahook;
  ourDeallocHook = dhook;
  return JVMDI_ERROR_NONE;
}

jvmdiError
JVMDI_Allocate(jint size, jbyte** memPtr)
{
  return ourAllocHook(size, memPtr);
}

jvmdiError
JVMDI_Deallocate(jbyte* mem)
{
  return ourDeallocHook(mem);
}

jvmdiError
GetThreadStatus(jthread thread, jint *threadStatusPtr, jint *suspendStatusPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

/* We access the thread list for the JVM */

extern int totalThreadsInSystem;

jvmdiError
GetAllThreads(jint *threadsCountPtr, jthread **threadsPtr)
{
  jvmdiError tmpError;
  jthread* memptr;
  tThreadNode* threadList;
  int counter = 0;

  tmpError = JVMDI_Allocate(totalThreadsInSystem * sizeof(jthread),(jbyte**) &memptr);
  if(tmpError != JVMDI_ERROR_NONE)
    {
      *threadsCountPtr = 0;
      *threadsPtr = NULL;
      return tmpError;
    }
  
  threadList = THREAD_lockAndGetThreadList();
  
  while(threadList != NULL)
    {
      memptr[counter++] = threadList->object;
      threadList = threadList->next;
    }

  *threadsCountPtr = counter;
  *threadsPtr = memptr;
  THREAD_unlockThreadList();
  return JVMDI_ERROR_NONE;
}

jvmdiError
SuspendThread(jthread thread)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
ResumeThread(jthread thread)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
StopThread(jthread thread, jobject exception)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
InterruptThread(jthread thread)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetThreadInfo(jthread thread, JVMDI_thread_info *infoPtr)
{
  tThreadNode* threadNode;

  threadNode = THREAD_FindThreadByObject(thread);
  if(threadNode == NULL)
    {
      return JVMDI_ERROR_INVALID_THREAD;
    }

//XXX fill in correct values
  infoPtr->name = "thread name goes here";
  infoPtr->priority = 5;
  infoPtr->is_daemon = JNI_FALSE;
  infoPtr->thread_group = NULL;
  infoPtr->context_class_loader = NULL;

  return JVMDI_ERROR_NONE;
}

jvmdiError
GetOwnedMonitorInfo(jthread thread, JVMDI_owned_monitor_info *infoPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetCurrentContendedMonitor(jthread thread, jobject *monitorPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
RunDebugThread(jthread thread, JVMDI_StartFunction proc, void *arg, int priority)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetTopThreadGroups(jint *groupCountPtr, jthreadGroup **groupsPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetThreadGroupInfo(jthreadGroup group, JVMDI_thread_group_info *infoPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetThreadGroupChildren(jthreadGroup group,
		       jint *threadCountPtr, jthread **threadsPtr,
		       jint *groupCountPtr, jthreadGroup **groupsPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetFrameCount(jthread thread, jint *countPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetCurrentFrame(jthread thread, jframeID *framePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetCallerFrame(jframeID called, jframeID *framePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetFrameLocation(jframeID frame, jclass *classPtr, jmethodID *methodPtr,
		 jlocation *locationPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
NotifyFramePop(jframeID frame)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetLocalObject(jframeID frame, jint slot, jobject *valuePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
jvmdiError
GetLocalInt(jframeID frame, jint slot, jint *valuePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetLocalLong(jframeID frame, jint slot, jlong *valuePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetLocalFloat(jframeID frame, jint slot, jfloat *valuePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetLocalDouble(jframeID frame, jint slot, jdouble *valuePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
SetLocalObject(jframeID frame, jint slot, jobject value)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
jvmdiError
SetLocalInt(jframeID frame, jint slot, jint value)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
jvmdiError
SetLocalLong(jframeID frame, jint slot, jlong value)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
jvmdiError
SetLocalFloat(jframeID frame, jint slot, jfloat value)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
jvmdiError
SetLocalDouble(jframeID frame, jint slot, jdouble value)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
SetBreakpoint(jclass clazz, jmethodID method, jlocation location)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
ClearBreakpoint(jclass clazz, jmethodID method, jlocation location)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
ClearAllBreakpoints()
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}


jvmdiError
SetFieldAccessWatch(jclass clazz, jfieldID field)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
ClearFieldAccessWatch(jclass clazz, jfieldID field)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
SetFieldModificationWatch(jclass clazz, jfieldID field)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
ClearFieldModificationWatch(jclass clazz, jfieldID field)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetClassSignature(jclass clazz, char **sigPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetClassStatus(jclass clazz, jint *statusPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetSourceFileName(jclass clazz, char **sourceNamePtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}


jvmdiError
GetClassLoader(jclass clazz, jobject *classloaderPtr)
{
  if(classloaderPtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;

  *classloaderPtr = NULL; //Class has no class loader
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetObjectHashCode(jobject object, jint *hashCodePtr) 
{
  if(object == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
GetMonitorInfo(jobject object, JVMDI_monitor_info *infoPtr)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}



jvmdiError
SetEventHook(JVMDI_EventHook hook)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}

jvmdiError
SetEventNotificationMode(jint mode, jint eventType, jthread thread, ...)
{
  return JVMDI_ERROR_NOT_IMPLEMENTED;
}
#endif



