/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#ifdef HAVE_JVMDI

#include "assert.h"
#include "jvmdi.h"
#include "jni.h"

jvmdiError
GetClassModifiers(jclass clazz, jint *modifiersPtr)
{
  JNIEnv* env;

  if(modifiersPtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  if(clazz == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  
  env = &(JNI_getJNIData(sys_current_thread())->functions);
  *modifiersPtr = Java_java_lang_Class_getModifiers(env, clazz);
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetClassMethods(jclass clazz, jint *methodCountPtr, jmethodID **methodsPtr)
{
  JNIEnv* env;
  jclass clazzclazz;
  jfieldID fieldID;
  tClassLoaderTuple* theClass;
  
  int numMethods;
  int i;

  if((methodCountPtr == NULL) || (methodsPtr == NULL))
    return JVMDI_ERROR_NULL_POINTER;

  env = &(JNI_getJNIData(sys_current_thread())->functions);

  clazzclazz = (*env)->GetObjectClass(env, clazz);
  fieldID = (*env)->GetFieldID(env, clazzclazz, "_classStruct", "I");
    
  assert(fieldID);

  theClass = (tClassLoaderTuple*) (*env)->GetIntField(env, clazz, fieldID);

  numMethods = theClass->pstClass->u16MethodsCount;

  if(JVMDI_Allocate(numMethods * sizeof(jmethodID), methodsPtr) != JVMDI_ERROR_NONE)
    {
      return JVMDI_ERROR_OUT_OF_MEMORY;
    }

  for(i = 0; i < numMethods;i++)
    {
      (*methodsPtr)[i] = &theClass->pstClass->pstMethods[i];
    }
  *methodCountPtr = numMethods;
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetClassFields(jclass clazz, jint *fieldCountPtr, jfieldID **fieldsPtr)
{
  JNIEnv* env;
  jclass clazzclazz;
  jfieldID fieldID;
  tClassLoaderTuple* theClass;
  
  int numInstFields;
  int numStatFields;
  int i;

  if((fieldCountPtr == NULL) || (fieldsPtr == NULL))
    return JVMDI_ERROR_NULL_POINTER;

  env = &(JNI_getJNIData(sys_current_thread())->functions);

  clazzclazz = (*env)->GetObjectClass(env, clazz);
  fieldID = (*env)->GetFieldID(env, clazzclazz, "_classStruct", "I");
    
  assert(fieldID);

  theClass = (tClassLoaderTuple*) (*env)->GetIntField(env, clazz, fieldID);

  numInstFields = theClass->pstClass->u16InstCount;
  numStatFields = theClass->pstClass->u16StatCount;

  if(JVMDI_Allocate((numInstFields + numStatFields) * sizeof(jfieldID), fieldsPtr) != JVMDI_ERROR_NONE)
    {
      return JVMDI_ERROR_OUT_OF_MEMORY;
    }

  for(i = 0; i < numInstFields;i++)
    {
      (*fieldsPtr)[i] = &theClass->pstClass->pstInstOffsets[i];
    }

  for(; i < (numInstFields + numStatFields);i++)
    {
      (*fieldsPtr)[i] = &theClass->pstClass->pstStatOffsets[i - numInstFields];
    }

  *fieldCountPtr = (numInstFields + numStatFields);
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetImplementedInterfaces(jclass clazz,
			 jint *interfaceCountPtr, 
			 jclass **interfacesPtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
IsInterface(jclass clazz, jboolean *isInterfacePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
IsArrayClass(jclass clazz, jboolean *isArrayClassPtr)
{
  return JVMDI_ERROR_NONE;
}


jvmdiError
GetFieldName(jclass clazz, jfieldID field, 
	     char **namePtr, char **signaturePtr)
{

  return JVMDI_ERROR_NONE;
}

jvmdiError
GetFieldDeclaringClass(jclass clazz, jfieldID field, jclass *declaringClassPtr)
{

  return JVMDI_ERROR_NONE;
}

jvmdiError
GetFieldModifiers(jclass clazz, jfieldID field, jint *modifiersPtr)
{

  return JVMDI_ERROR_NONE;
}

jvmdiError
IsFieldSynthetic(jclass clazz, jfieldID field, jboolean *isSyntheticPtr)
{
  return JVMDI_ERROR_NONE;
}


jvmdiError
GetMethodName(jclass clazz, jmethodID method, 
	      char **namePtr, char **signaturePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetMethodDeclaringClass(jclass clazz, jmethodID method,
			jclass *declaringClassPtr)
{

  return JVMDI_ERROR_NONE;
} 


jvmdiError
GetMethodModifiers(jclass clazz, jmethodID method,
		   jint *modifiersPtr)
{
  return JVMDI_ERROR_NONE;
}


jvmdiError
GetMaxStack(jclass clazz, jmethodID method, jint *maxPtr)
{
  return JVMDI_ERROR_NONE;
}


jvmdiError
GetMaxLocals(jclass clazz, jmethodID method,
	     jint *maxPtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetArgumentsSize(jclass clazz, jmethodID method, jint *sizePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetLineNumberTable(jclass clazz, jmethodID method,
		   jint *entryCountPtr, 
		   JVMDI_line_number_entry **tablePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetLocalVariableTable(jclass clazz, jmethodID method,
		      jint *entryCountPtr, 
		      JVMDI_local_variable_entry **tablePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetExceptionHandlerTable(jclass clazz, jmethodID method,
			 jint *entryCountPtr, 
			 JVMDI_exception_handler_entry **tablePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetThrownExceptions(jclass clazz, jmethodID method,
		    jint *exceptionCountPtr, jclass **exceptionsPtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetBytecodes(jclass clazz, jmethodID method, jint *bytecodeCountPtr,
	     jbyte **bytecodesPtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
IsMethodNative(jclass clazz, jmethodID method, jboolean *isNativePtr)
{
  return JVMDI_ERROR_NONE;
}

jvmdiError
IsMethodSynthetic(jclass clazz, jmethodID method, jboolean *isSyntheticPtr)
{
  return JVMDI_ERROR_NONE;
}

#endif
