#include <config.h>
/*
  Sun Jan 30 01:34:40 SAST 2000 - Jewel

  Created this file to separate garbage.c into mostly GC code and persistence code

 */


#ifdef EVICTIONS
static void RecursivelyMarkTPOTOnly
(
  tOBREF o,        /* @parm The handle of the item to mark */
  int32* pi32Total
)
{
  tClass*     pstTempClass;
  int32       i;

  if (ISPID(PDEREF(o)))
  {
    return;
  }

    /* check to see if item has already been marked as reachable from
       anywhere... return if so */
    if (HASFLAG(PDEREF(o), GARBAGE_REACHABLE) ||
        HASFLAG(PDEREF(o), GARBAGE_REACHABLEFROMRPOT) ||
        HASFLAG(PDEREF(o), GARBAGE_REACHABLEFROMTPOTONLY))
    {
      return;
    }

    /* mark it with relevant flag */
    SETFLAG(PDEREF(o), GARBAGE_REACHABLEFROMTPOTONLY);
    /* add its size to the total */
    *pi32Total += ((int32*) PDEREF(o))[-1];

    /* if it's an object then mark all its members if appropriate */
    if ((PDEREF(o)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
    {
      /* go through instance fields */
      pstTempClass = PDEREF(o)->pstType;

      while (pstTempClass)
      {
        for (i = 0; i < pstTempClass->u16InstCount; i++)
        {
          /* if signature says this is an object or array, mark it */
          if ((pstTempClass->pstInstOffsets[i].uidFieldSig[0] == '[') ||
              (pstTempClass->pstInstOffsets[i].uidFieldSig[0] == 'L'))
          {
            if ((PDEREF(o)->pi32Vars[pstTempClass->pstInstOffsets[i].u16Offset] == (int32) NULL) ||
                ISPID(PDEREF(o)->pi32Vars[pstTempClass->pstInstOffsets[i].u16Offset]))
            {
              /* ignore it if it's NULL or a PID */
              continue;
            }
            else
            {
              if (ISPID(PDEREF((tOBREF) PDEREF(o)->pi32Vars[pstTempClass->pstInstOffsets[i].u16Offset])))
              {
                /* if handle contains a PID, ignore */
                continue;
              }
              else
              {
                RecursivelyMarkTPOTOnly((tOBREF) PDEREF(o)->pi32Vars[pstTempClass->pstInstOffsets[i].u16Offset], pi32Total);
              }
            }
          }
        }
        pstTempClass = pstTempClass->pstSuperClass;
      }
    }
    /* if it's an array of arrays or of objects then mark them too */
    else if ((PDEREF(o)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_ARRAY)
    {
      tARREF a = (tARREF) o;
      if ((PDEREF(a)->enType == T_ARRAY) ||
          (PDEREF(a)->enType == T_OBJECT))
      {
        for (i = 0; i < PDEREF(a)->i32Number; i++)
        {
          if ((((tOBREF*) PDEREF(a)->pvElements)[i] == NULL) || ISPID(((tOBREF*) PDEREF(a)->pvElements)[i]))
          {
            continue;
          }
          else
          {
            if (ISPID(PDEREF(((tOBREF*) PDEREF(a)->pvElements)[i])))
            {
              continue;
            }
            else
            {
              RecursivelyMarkTPOTOnly(((tOBREF*) PDEREF(a)->pvElements)[i], pi32Total);
            }
          }
        }
      }
    }
}

static void MarkReachableFromTPOT
(
  int32* pi32Total
)
{
  int i;
  tRPOTElement* temp;

  for (i = 0; i < TPOT_TABLESIZE; i++)
  {
    if (TPOT_table[i].pid)
    {
      if (!ISPID(TPOT_table[i].la))
      {
        RecursivelyMarkTPOTOnly(&(TPOT_table[i].la), pi32Total);
      }
      temp = TPOT_table[i].next;
      while (temp)
      {
        RecursivelyMarkTPOTOnly(&(temp->la), pi32Total);
        temp = temp->next;
      }
    }
  }
}
#endif

#ifdef EVICTIONS

PID WriteStoreFormat
(
  tObject* o,   /* object to write */
  int setPers
  #ifdef PJSLREAL
  , tAllocQueue* pstAQ
  #endif
)
{
  int i;
  tField* field;
  tOBREF refH;
  tArray* a;
  int iFinished = 0;
  tClass* pstCurrType;
  tClass* pstType;
  #ifdef PJSLCOMPAT
  pjsl_obj_info_t info = 0;
  #ifdef PJSLREAL
  pjsl_regime_t regime;
  pjsl_hid_t histID = PJSL_HISTMAN_ILLEGAL_HID;
  #endif
  #endif
  tOBREF hHandleTemp = NULL;

  /*
     What we do here:
     - Overwrite all references with PID if they're not PIDs already. This
       will include allocating PIDs for referenced objects that have not
       already been made persistent or been swopped
     - Don't bother with reswizzling because chances are that this object
       is going to be evicted after it's been written
     - Don't check update flags - assume it's dirty because otherwise this
       procedure probably wouldn't have been called
  */


    /*fprintf(stderr,"WS\n");*/

  #ifdef PJSLREAL
  if (pstAQ == NULL)
  {
    fprintf(stderr, "Must call WriteStoreFormat with an allocation queue under PJSL\n");
    exit(1);
  }
  #endif

  /* sort out this object's class first */
  pstType = o->pstType;
  if (pstType->persIndex == (int32) NULL)
  {
    int nameLen = strlen(pstType->uidName);
    /*fprintf(stderr,"0");*/
    /* not in store so we must add it */
    #ifdef PJSLCOMPAT
    #ifdef PJSLREAL
  /*  fprintf(stderr, "name mapping kind %d of size %d\n", KIND, nameLen);*/
    regime = pjsl_map_kind_to_regime(KIND, nameLen);
    #endif
    PJSL_KIND_OP(KIND,regime,allocate)(STORE_Store, nameLen, info, histID, &(pstType->persIndex));
    AQ_EnQueue(pstAQ, pstType->uidName, nameLen, pstType->persIndex, 1, NULL);
/*    PJSL_KIND_OP(KIND,regime,firstWrite)(STORE_Store, pstType->persIndex, nameLen, info, (uchar*) pstType->uidName, NULL, histID);*/
    #else
    pstType->persIndex = STORE_NewObject(nameLen);
    STORE_UpdateObject(pstType->persIndex, pstType->uidName);
/*    printf("<%s %d>", pstType->uidName, pstType->persIndex);*/
    #endif
  }
  /* set type to class name's PID so that it gets stored like that */
  o->pstType = (tClass*) pstType->persIndex;

  #ifdef PJSLREAL
  #ifdef PJSLDESCS
  if (pstType->descPID == NULL)
  {
    PID descPID;
    descPID = MakeDescriptor(pstType);
    pstType->descPID = descPID;
  }
  info = descPID;
  #endif 
  #endif

    /* if object is a class instance and has variables */
  if ((o->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
  {
    if (o->pi32Vars)
    {
      /* Check the fields (looking at parent classes too) */
      for (pstCurrType = pstType; iFinished == 0; pstCurrType = pstCurrType->pstSuperClass)
      {
        for (i = 0; i < pstCurrType->u16InstCount; i++)
        {
          field = &(pstCurrType->pstInstOffsets[i]);
          switch (field->uidFieldSig[0])
          {
            case '[':
            case 'L':
            {
              refH = (tOBREF) o->pi32Vars[field->u16Offset];
              /*
                 if refH is NULL then leave it alone
                 else if it is a PID then leave it alone too
                 else it is a handle -
                   if the handle contains a PID, use that
                   else if the referenced object has a PID, use that PID
                   else the referenced object does not have a PID, so allocate one
              */
              if (refH)
              {
                if (!ISPID(refH))
                {
                  if (ISPID(PDEREF(refH)))
                  {
                    o->pi32Vars[field->u16Offset] = (int32) PDEREF(refH);
                  }
                  else
                  {
                    if (PDEREF(refH)->pid)
                    {
                      o->pi32Vars[field->u16Offset] = (int32) PDEREF(refH)->pid;
                    }
                    else
                    {
                      tObject* ref = PDEREF(refH);

                      #ifdef MEMSWAP
                      /* this object has never been swopped so we increment
                         its external reference count */
                      ref->i32ExternalRefCount += 1;
                      /* if this is the first time it's being incremented, add
                         the object's size to the global count */
                      if (ref->i32ExternalRefCount == 1)
                      {
                        i32ERSize += ((int32*) ref)[-1];
                      }
                      #endif

                      /* ### we're promoting to get a PID - change this so that
                             it just allocates, doesn't actually write */
/*                      o->pi32Vars[field->u16Offset] = RPOT_PromoteObject(PDEREF(refH));*/

                      if (ref->pid)
                      {
                        o->pi32Vars[field->u16Offset] = ref->pid;
                      }
                      else
                      {
/*                        if (ref->pstType->persIndex == NULL)
                        {
                          ref->pstType->persIndex = STORE_NewObject(strlen(ref->pstType->uidName));
                          STORE_UpdateObject(ref->pstType->persIndex, ref->pstType->uidName);
                        }
                        ref->pstType = (tClass*) ref->pstType->persIndex;*/

                        #ifdef PJSLCOMPAT
/*fprintf(stderr, "ref mapping kind %d of size %d\n", KIND, sizeof(int32) * ((int32*) ref)[-1]);*/
                        regime = pjsl_map_kind_to_regime(KIND, sizeof(int32) * ((int32*) ref)[-1]);
                        /*fprintf(stderr,"1");*/
                        PJSL_KIND_OP(KIND,regime,allocate)(STORE_Store, sizeof(int32) * ((int32*) ref)[-1], info, histID, &(ref->pid));
                        AQ_EnQueue(pstAQ, (char*) ref, sizeof(int32) * ((int32*) ref)[-1], ref->pid, 1, ref->pstType);
                        SETFLAG(ref, PERSIST_PJSL_EnQueued);
                        #else
                        ref->pid = STORE_NewObject(sizeof(int32) * ((int32*) ref)[-1]);
/*                        STORE_UpdateObject(ref->pid, ref);*/  /* don't write */
                        #endif
                        /* set it as dirty, otherwise it looks like it is persistent (coz it has a
                           pid now) and clean, which means it won't get written when it's found */
                        SETFLAG(ref, PERSIST_Dirty);
                        o->pi32Vars[field->u16Offset] = ref->pid;
                        TPOT_Add(ref->pid, ref);
                      }
                    }
                  }
                }
              }
              break;
            }
          }
        }

        /* if we've got up to the Object class or we've got to a class that
           does not inherit anything then we have finished */
        if ((pstCurrType->pstSuperClass == NULL) ||
            ((pstCurrType->pstInstOffsets) && (pstCurrType->pstInstOffsets[0].u16Offset == 0)))
        {
          iFinished = 1;
        }
      }
    }
  }
    /* if object is an array */
    else
    {
      a = (tArray*) o;

      if ((a->enType == T_OBJECT) || (a->enType == T_ARRAY))
      {
        for (i = 0; i < a->i32Number; i++)
        {
          refH = ((tOBREF*) a->pvElements)[i];
          /* if not a null reference */
          if (refH)
          {
            if (!ISPID(refH))
            {
              if (ISPID(PDEREF(refH)))
              {
                ((tOBREF*) a->pvElements)[i] = (tOBREF) PDEREF(refH);
              }
              else
              {
                if (DEREF(refH)->pid)
                {
                  ((tOBREF*) a->pvElements)[i] = (tOBREF) PDEREF(refH)->pid;
                }
                else
                {
                  tObject* ref = PDEREF(refH);

                  #ifdef MEMSWAP
		  assert ( 9 == 10); //jewel
                  /* this object has never been swopped so we increment
                     its external reference count */
                  ref->i32ExternalRefCount += 1;
                  /* if this is the first time it's being incremented, add
                     the object's size to the global count */
                  if (ref->i32ExternalRefCount == 1)
                  {
                    i32ERSize += ((int32*) ref)[-1];
                  }
                  #endif

                  if (ref->pid)
                  {
                    ((tOBREF*) a->pvElements)[i] = (tOBREF) ref->pid;
                  }
                  else
                  {
/*                    if (ref->pstType->persIndex == NULL)
                    {
                      ref->pstType->persIndex = STORE_NewObject(strlen(ref->pstType->uidName));
                      STORE_UpdateObject(ref->pstType->persIndex, ref->pstType->uidName);
                    }
                    ref->pstType = (tClass*) ref->pstType->persIndex;*/

                    #ifdef PJSLCOMPAT
/*fprintf(stderr, "ref mapping kind %d of size %d\n", KIND, sizeof(int32) * ((int32*) ref)[-1]);*/
                    regime = pjsl_map_kind_to_regime(KIND, sizeof(int32) * ((int32*) ref)[-1]);
                        /*fprintf(stderr,"2");*/

                    PJSL_KIND_OP(KIND,regime,allocate)(STORE_Store, sizeof(int32) * ((int32*) ref)[-1], info, histID, &(ref->pid));
                    AQ_EnQueue(pstAQ, (char*) ref, sizeof(int32) * ((int32*) ref)[-1], ref->pid, 1, ref->pstType);
                    SETFLAG(ref, PERSIST_PJSL_EnQueued);
                    #else
                    ref->pid = STORE_NewObject(sizeof(int32) * ((int32*) ref)[-1]);
/*                    STORE_UpdateObject(ref->pid, ref);*/ /* don't write */
                    #endif
                    /* set it as dirty, otherwise it looks like it is persistent (coz it has a
                       pid) and clean, which means it won't get written when it's found */
                    SETFLAG(ref, PERSIST_Dirty);
                    ((tOBREF*) a->pvElements)[i] = (tOBREF) ref->pid;
                    TPOT_Add(ref->pid, ref);
                  }
                }
              }
            }
          }
        }
      }
    }



  if (HASFLAG(o, GARBAGE_PERSISTENT))
  {
    #ifdef PJSLCOMPAT
                        /*fprintf(stderr,"3");*/
    if (HASFLAG(o, PERSIST_PJSL_EnQueued))
    {
      /* just unflag it, don't need to do any more here */
      CLEARFLAG(o, PERSIST_PJSL_EnQueued);
    }
    else
    {
      /* otherwise enqueue it with mustFirstWrite set to 0 */
      AQ_EnQueue(pstAQ, (char*) o, sizeof(int32) * ((int32*) o)[-1], o->pid, 0, pstType);
/*      regime = pjsl_map_kind_to_regime(KIND, sizeof(int32) * ((int32*) o)[-1]);
      PJSL_KIND_OP(KIND,regime,updateAll)(STORE_Store, o->pid, (uchar*) o, NULL, histID);*/
    }
    #else
    hHandleTemp = o->hHandle;
    o->hHandle = NULL;
    STORE_UpdateObject(o->pid, o);
    o->hHandle = hHandleTemp;
    #endif
  }
  else
  {
    if (o->pid)
    {
      if (setPers)
      {
        /* mark it as persistent */
        SETFLAG(o, GARBAGE_PERSISTENT);
        /* don't save the handle */
        if (o->hHandle)
        {
          hHandleTemp = o->hHandle;
          o->hHandle = NULL;
        }
      }
      #ifdef PJSLCOMPAT
/*fprintf(stderr, "object1 %s mapping kind %d of size %d\n", pstType->uidName, KIND, sizeof(int32) * ((int32*) o)[-1]);*/
      regime = pjsl_map_kind_to_regime(KIND, sizeof(int32) * ((int32*) o)[-1]);
      if (HASFLAG(o, PERSIST_PJSL_EnQueued))
      {
                        /*fprintf(stderr,"4");*/
          /* just clear the flag here */
          CLEARFLAG(o, PERSIST_PJSL_EnQueued);
/*        PJSL_KIND_OP(KIND,regime,firstWrite)(STORE_Store, o->pid, sizeof(int32) * ((int32*) o)[-1], info, (uchar*) o, NULL, histID);*/
      }
      else
      {
                        /*fprintf(stderr,"5");*/
          /* if it's not enqueued then enqueue it, assuming that it has
             already been firstwritten. We can assume this because:
             1) it is allocated (because it has a PID)
             2) if it was not firstWritten then it would have been allocated
                during the current stabilise but if it had been allocated during
                the current stabilise then it would be enqueued */
          AQ_EnQueue(pstAQ, (char*) o, sizeof(int32) * ((int32*) o)[-1], o->pid, 0, pstType);
/*        PJSL_KIND_OP(KIND,regime,updateAll)(STORE_Store, o->pid, (uchar*) o, NULL, histID);*/
      }
      #else
      STORE_UpdateObject(o->pid, o);
      #endif
      if (setPers && hHandleTemp)
      {
        o->hHandle = hHandleTemp;
      }
      if (setPers)
      {
        RPOT_Add(o->pid, o);
        RPOT_Remove(o->pid);
      }
    }
    else
    {
      if (setPers)
      {
        /* mark it as persistent */
        SETFLAG(o, GARBAGE_PERSISTENT);
        /* don't save the handle */
        if (o->hHandle)
        {
          hHandleTemp = o->hHandle;
          o->hHandle = NULL;
        }
      }
      #ifdef PJSLCOMPAT
                        /*fprintf(stderr,"6");*/
      /* here we allocated and enqueue with mustFirstWrite set to 1 */
/*fprintf(stderr, "object2 %s mapping kind %d of size %d\n", pstType->uidName, KIND, sizeof(int32) * ((int32*) o)[-1]);*/
      regime = pjsl_map_kind_to_regime(KIND, sizeof(int32) * ((int32*) o)[-1]);
      PJSL_KIND_OP(KIND,regime,allocate)(STORE_Store, sizeof(int32) * ((int32*) o)[-1], info, histID, &(o->pid));
      AQ_EnQueue(pstAQ, (char*) o, sizeof(int32) * ((int32*) o)[-1], o->pid, 1, pstType);
/*      PJSL_KIND_OP(KIND,regime,firstWrite)(STORE_Store, o->pid, sizeof(int32) * ((int32*) o)[-1], info, (uchar*) o, NULL, histID);*/
      #else


      o->pid = STORE_NewObject( ROUND32BIT(sizeof(tObject)) + sizeof(int32) * DEREF(o)->pstType->u16InstSize);
      //sizeof(int32) * ((int32*) o)[-1]);
      STORE_UpdateObject(o->pid, o);
      #endif
      if (setPers && hHandleTemp)
      {
        o->hHandle = hHandleTemp;
      }
      if (setPers)
      {
        RPOT_Add(o->pid, o);
      }
      else
      {
        TPOT_Add(o->pid, o);
      }
    }
  }

  #ifndef PJSLREAL
  /* put its type pointer back */
  o->pstType = pstType;
  #endif

  /* return its pid */
  return o->pid;
}

#ifdef MEMSWAP
PID WriteMemFormat
(
  tObject* o
)
{

  int i;
  tField* field;
  tOBREF refH;
  tArray* a;
  int iFinished = 0;
  tClass* pstCurrType;

/*  printf("WM");*/

  /* must find all resident, not previously swopped, children and
     increase their ERC (external reference count) */

    /* if object is a class instance and has variables */
    if (((o->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT) && o->pi32Vars)
    {
      /* Check the fields (looking at parent classes too) */
      for (pstCurrType = o->pstType; iFinished == 0; pstCurrType = pstCurrType->pstSuperClass)
      {
        for (i = 0; i < pstCurrType->u16InstCount; i++)
        {
          field = &(pstCurrType->pstInstOffsets[i]);
          switch (field->uidFieldSig[0])
          {
            case '[':
            case 'L':
            {
              refH = (tOBREF) o->pi32Vars[field->u16Offset];
              if (refH)
              {
                if (!ISPID(refH))
                {
                  if (!ISPID(PDEREF(refH)))
                  {
/*                    printf("(%d) %s %s | ", i, field->uidFieldSig, field->uidFieldName);*/

                    /* this object has never been swopped so we increment
                       its external reference count */
                    PDEREF(refH)->i32ExternalRefCount += 1;
                    /* if this is the first time it's incremented then we
                       add its size to the global count */
                    if (PDEREF(refH)->i32ExternalRefCount == 1)
                    {
                      i32ERSize += *(((int32*) PDEREF(refH)) - 1);
                    }
                  }
                }
              }
              break;
            }
          }
        }

        /* if we've got up to the Object class or we've got to a class that
           does not inherit anything then we have finished */
        if ((pstCurrType->pstSuperClass == NULL) ||
            ((pstCurrType->pstInstOffsets) && (pstCurrType->pstInstOffsets[0].u16Offset == 0)))
        {
          iFinished = 1;
        }
      }
    }
    /* if object is an array */
    else
    {
      a = (tArray*) o;

      if (a->enType == T_OBJECT)
      {
        for (i = 0; i < a->i32Number; i++)
        {
          refH = ((tOBREF*) a->pvElements)[i];
          /* if not a null reference */
          if (refH)
          {
            if (!ISPID(refH))
            {
              if (!ISPID(PDEREF(refH)))
              {
                /* this object has never been swopped so we increment
                   its external reference count */
                PDEREF(refH)->i32ExternalRefCount += 1;
                /* if this is the first time it's incremented then we
                   add its size to the global count */
                if (PDEREF(refH)->i32ExternalRefCount == 1)
                {
                  i32ERSize += *(((int32*) PDEREF(refH)) - 1);
                }
              }
            }
          }
        }
      }
    }


  if (o->pid)
  {
    STORE_UpdateObject(o->pid, o);
  }
  else
  {
      assert ( 6 == 7); //Jewel
    o->pid = STORE_NewObject(o, sizeof(int32) * ((int32*) o)[-1]);
    TPOT_Add(o->pid, o);
  }
  return o->pid;
}
#endif


static void DoEvictions
(
  int32 i32EvMask,        /* @parm mask containing the categories to be evicted */
  int   iDoTPOTOnly
)
{
  tHeapBlock* pstTempHB;
  int32       i, j;
  int32       i32NewInt, i32NewBit;
  int32*      pi32NewTop;
  tObject*    pstTempObject;
  int x;
  int iCopySize, iSpaceSize;
  int iKeep;

  printf("^ev(%d/%d)", GARBAGE_FREEMEM_NUMER, GARBAGE_FREEMEM_DENOM);

  /* go through all heap blocks */
  for (pstTempHB = pstHeapList; pstTempHB; pstTempHB = pstTempHB->pstNext)
  {
    /* set "new top" of compacted heap to base of heap */
    pi32NewTop = pstTempHB->pi32Heap;

    /* go through bitfield of this heap block */
    for (i = 0; i < pstTempHB->i32BFSize; i++)
    {
      /* check if there are any bits set in this int32 */
      if (pstTempHB->pi32BitField[i])
      {
        /* find the set bit(s) */
        for (j = 0; j < 32; j++)
        {
          if (pstTempHB->pi32BitField[i] & (((int32) 1L) << j))
          {
            /* find object pointer for convenience */
            pstTempObject = (tObject*) &(pstTempHB->pi32Heap[32 * i + j]);

            /* check if it's allowed to stay here */
            if (HASFLAG(pstTempObject, GARBAGE_LEAVEALONE))
            {
              /* it's it's flagged to be left alone, don't do anything
                 with it */
              iKeep = 1;
            }
            else if (HASFLAG(pstTempObject, GARBAGE_DEFKEEP))
            {
              /* it's it's flagged to be kept this time around, don't do
                 anything with it except unflag it */
              CLEARFLAG(pstTempObject, GARBAGE_DEFKEEP);
              iKeep = 1;
              printf("+");
            }
            else if ((pstTempObject->i32Flags & GARBAGE_EVCAT_MASK) == 0)
            {
              if (HASFLAG(pstTempObject, GARBAGE_REACHABLEFROMTPOTONLY))
              {
                if (iDoTPOTOnly)
                {
                /* Unreachable but the child of something swopped out, so
                   will be reachable if that object is reachable but isn't
                   marked as such. We have to look at these objects to see
                   what they are because they have not been put into a
                   category. */

                  #ifdef EVICTVERBOSE
                  printf("?");
                  #endif

                  iKeep = 0;

                  CLEARFLAG(pstTempObject, GARBAGE_REACHABLEFROMTPOTONLY);

                  if (HASFLAG(pstTempObject, GARBAGE_PERSISTENT))
                  {
                    if (HASFLAG(pstTempObject, PERSIST_Dirty))
                    {
                      CLEARFLAG(pstTempObject, (PERSIST_Dirty | PERSIST_RefsDirty));
                      #ifdef PJSLREAL
                      WriteStoreFormat(pstTempObject, 0, NULL);
                      #else
                      WriteStoreFormat(pstTempObject, 0);
                      #endif
                    }
                    RPOT_ChangeLA(pstTempObject->pid, (tOBREF) pstTempObject->pid);
                    if (pstTempObject->hHandle)
                    {
                      *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                    }
                  }
                  else
                  {
                    if (pstTempObject->pid)
                    {
                      if (HASFLAG(pstTempObject, PERSIST_Dirty))
                      {
                        CLEARFLAG(pstTempObject, (PERSIST_Dirty | PERSIST_RefsDirty));
                        #ifdef PJSLREAL
                        WriteStoreFormat(pstTempObject, 0, NULL);
                        #else
                        WriteStoreFormat(pstTempObject, 0);
                        #endif
                      }
                      TPOT_ChangeLA(pstTempObject->pid, (tOBREF) pstTempObject->pid);
                      *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                    }
                    else
                    {
                      SETFLAG(pstTempObject, GARBAGE_BEENSWOPPED);
                      #ifdef PJSLREAL
                      WriteStoreFormat(pstTempObject, 0, NULL);
                      #else
                      WriteStoreFormat(pstTempObject, 0);
                      #endif
                      TPOT_ChangeLA(pstTempObject->pid, (tOBREF) pstTempObject->pid);
                      *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                    }
                  }
                }
                else
                {
                  iKeep = 1;
                }
              }
              else
              {
                /* UT */
                /* totally unreachable - do normal GC stuff */
                #ifdef EVICTVERBOSE
                printf("0");
                #endif

                iKeep = 0;
                #ifdef NOOO
                /* run finalize method if there is one */
                if ((pstTempObject->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
                {
                  /* we need to find if this class or any of its parents have a finalize()
                     method - we search through its virtual table looking for one */
                  for (x = 0; x < pstTempObject->pstType->u16VTSize; x++)
                  {
                    if ((uidcmp(pstTempObject->pstType->ppstVT[x]->uidName, uidFinalizePtr) == 0) &&
                        (uidcmp(pstTempObject->pstType->ppstVT[x]->uidSignature, uidFinalizeSigPtr) == 0))
                    {
                      /* arguments are passed as an array... we only have one argument so make it
                         look like a one-element array by passing its address */
                      INTERP_RunNonVirtualMethodFromPtr(pstTempObject->pstType->ppstVT[x], (int32*) &(pstTempObject->hHandle));
                      break;
                    }
                  }
                }
                #endif
                if (HASFLAG(pstTempObject, GARBAGE_PERSISTENT))
                {
                  #ifdef EVICTVERBOSE
                  printf("!");
                  #endif
                  /* this is a very unfortunate persistent object that's
                     got rather lost... so free its RPOT entry and its handle
                     if it has one because it can't be used */
/*                  RPOT_Remove(pstTempObject->pid);*/
                  RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  if (pstTempObject->hHandle)
                  {
                    *((tOBREF*) pstTempObject->hHandle) = pstTempHB->hFirstFreeHandle;
                    pstTempHB->hFirstFreeHandle = pstTempObject->hHandle;
                  }
                }
                else
                {
                  /* free the object's handle for reuse */
                  /* The free handle list does not have to be in memory order so we can just
                     add this one to the beginning of the list quickly regardless of where
                     it is in memory */
                  /* free the object's TPOT entry if it has one */
                  if (pstTempObject->pid)
                  {
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  else
                  {
                    *((tOBREF*) pstTempObject->hHandle) = pstTempHB->hFirstFreeHandle;
                    pstTempHB->hFirstFreeHandle = pstTempObject->hHandle;
                  }
                }
              }
            }
            else if (pstTempObject->i32Flags & i32EvMask)
            {
              iKeep = 0;

              switch (pstTempObject->i32Flags & GARBAGE_EVCAT_MASK)
              {
                case GARBAGE_EVCAT_2:
                {
                  /* UCP, UCp1 */
                  #ifdef EVICTVERBOSE
                  printf("1");
                  #endif
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_2;
                  #ifdef RPOTREFS
                  /* change RPOT entry if P, change TPOT entry if p1 */
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
/*                    RPOT_Remove(pstTempObject->pid);*/
                  }
                  else
                  {
                    /* this is the p1 case */
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  if (pstTempObject->hHandle)
                  {
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  }
                  #else
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  #endif
                  break;
                }
                case GARBAGE_EVCAT_3:
                {
                  /* UDP, UDp1 */
                  /* change RPOT entry if P, change TPOT entry if p1 */
                  #ifdef EVICTVERBOSE
                  printf("2");
                  #endif
                  pstTempObject->i32Flags &= ~(PERSIST_Dirty | PERSIST_RefsDirty);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_3;
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 0, NULL);
                  #else
                  WriteStoreFormat(pstTempObject, 0);
                  #endif
                  #ifdef RPOTREFS
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
/*                    RPOT_Remove(pstTempObject->pid);*/
                  }
                  else
                  {
                    /* this is the p1 case */
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  if (pstTempObject->hHandle)
                  {
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  }
                  #else
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  #endif
                  break;
                }
                case GARBAGE_EVCAT_4:
                {
                  /* Up0 */
                  /* write in store format, add to TPOT (with PID as LA) */
                  #ifdef EVICTVERBOSE
                  printf("3");
                  #endif

                  pstTempObject->i32Flags &= ~(PERSIST_Dirty | PERSIST_RefsDirty);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_4;
                  pstTempObject->i32Flags |= GARBAGE_BEENSWOPPED;
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 0, NULL);
                  #else
                  WriteStoreFormat(pstTempObject, 0);
                  #endif
                  TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  break;
                }
                case GARBAGE_EVCAT_5:
                {
                  /* RCP, RCp1 */
                  /* change RPOT entry if P, TPOT entry if p1 */
                  #ifdef EVICTVERBOSE
                  printf("4");
                  #endif

                  pstTempObject->i32Flags &= ~(GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_5;

                  #ifdef RPOTREFS
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  if (pstTempObject->hHandle)
                  {
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  }
                  #else
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  #endif

                  break;
                }
                case GARBAGE_EVCAT_6:
                {
                  /* RDP, RDp1 */
                  /* change RPOT entry if P, TPOT entry if p1 */
                  #ifdef EVICTVERBOSE
                  printf("5");
                  #endif

                  pstTempObject->i32Flags &= ~(PERSIST_Dirty | PERSIST_RefsDirty);
                  pstTempObject->i32Flags &= ~(GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_6;
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 0, NULL);
                  #else
                  WriteStoreFormat(pstTempObject, 0);
                  #endif
                  #ifdef RPOTREFS
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  }
                  if (pstTempObject->hHandle)
                  {
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  }
                  #else
                  if (pstTempObject->i32Flags & GARBAGE_PERSISTENT)
                  {
                    /* this is the P case */
                    RPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  else
                  {
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->hHandle);
                  }
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  #endif

                  break;
                }
                case GARBAGE_EVCAT_7:
                {
                  /* Rp0 */
                  #ifdef EVICTVERBOSE
                  printf("6");
                  #endif

                  pstTempObject->i32Flags &= ~(PERSIST_Dirty | PERSIST_RefsDirty);
                  pstTempObject->i32Flags &= ~(GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_7;
                  pstTempObject->i32Flags |= GARBAGE_BEENSWOPPED;
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 0, NULL);
                  #else
                  WriteStoreFormat(pstTempObject, 0);
                  #endif
                  TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                  *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  break;
                }
                case GARBAGE_EVCAT_8:
                {
                  /* RT */
                  #ifdef EVICTVERBOSE
                  printf("7");
                  #endif

                  pstTempObject->i32Flags &= ~(PERSIST_Dirty | PERSIST_RefsDirty);
                  pstTempObject->i32Flags &= ~(GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT);
                  pstTempObject->i32Flags &= ~GARBAGE_EVCAT_8;

                  if (HASFLAG(pstTempObject, GARBAGE_BEENSWOPPED))
                  {
                    #ifdef MEMSWAP
                    pstTempObject->i32Flags |= GARBAGE_MEMSWOPPED;
                    WriteMemFormat(pstTempObject);
                    #else
                    #ifdef PJSLREAL
                    WriteStoreFormat(pstTempObject, 0, NULL);
                    #else
                    WriteStoreFormat(pstTempObject, 0);
                    #endif
                    #endif
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                  }
                  else
                  {
                    #ifdef MEMSWAP
                    pstTempObject->i32Flags |= (GARBAGE_BEENSWOPPED | GARBAGE_MEMSWOPPED);
                    pid = WriteMemFormat(pstTempObject);
                    #error Do more things here, add to TPOT, change handle contents, etc
                    #else
                    pstTempObject->i32Flags |= GARBAGE_BEENSWOPPED;
                    #ifdef PJSLREAL
                    WriteStoreFormat(pstTempObject, 0, NULL);
                    #else
                    WriteStoreFormat(pstTempObject, 0);
                    #endif
                    TPOT_ChangeLA(pstTempObject->pid, (void*) pstTempObject->pid);
                    *(pstTempObject->hHandle) = (tObject*) pstTempObject->pid;
                    #endif
                  }

                  break;
                }
                default:
                {
                  /* these are the unreachable objects that have not been
                     marked at all */
                  #ifdef DEBUG
                  assert((pstTempObject->i32Flags & GARBAGE_EVCAT_MASK) == 0);
                  #endif
                  #ifdef EVICTVERBOSE
                  printf("oops!");
                  exit(1);
                  #endif
                }
              }
            }
            else
            {
              iKeep = 1;
            }

            if (iKeep)
            {
/*              printf("Keeping %s size %d\n", pstTempObject->pstType->uidName, *(((int32*) pstTempObject) - 1));*/
              /* first unmark it */
              pstTempObject->i32Flags &= ~GARBAGE_EVCAT_MASK;
              pstTempObject->i32Flags &= ~GARBAGE_REACHABLE;
              pstTempObject->i32Flags &= ~GARBAGE_REACHABLEFROMRPOT;
              pstTempObject->i32Flags &= ~GARBAGE_REACHABLEFROMTPOTONLY;

              /* check if we need to move this object - we move it if there
                 is space between it and the "new top" of the compacted
                 objects (which should be all cases after the first space
                 has been made) */
              if (((int32*) pstTempObject) - 1 != pi32NewTop)
              {
                /* clear bit for old position in bitfield */
                pstTempHB->pi32BitField[i] &= ~(((int32) 1L) << j);
                /* move to new top */
                /* quick check to see if they overlap - ie if size of object > size of free space */
                iCopySize = (((int32*) pstTempObject) - 1)[0];
                iSpaceSize = ((((int32*) pstTempObject) - 1) - pi32NewTop);
                if (iCopySize < iSpaceSize)
                {
                  /* no overlap... can use memcpy */
                  memcpy(pi32NewTop, ((int32*) pstTempObject) - 1, iCopySize * sizeof(int32));
                }
                else
                {
                  /* otherwise do it manually */
                  for (x = 0; x < iCopySize; x++)
                  {
                    pi32NewTop[x] = (((int32*) pstTempObject) - 1)[x];
                  }
                }
                /* set bit for new position in bitfield (+1 coz object starts one slot after newtop coz the size gets stored there) */
                i32NewInt = ((pi32NewTop + 1) - pstTempHB->pi32Heap) / 32;
                i32NewBit = ((pi32NewTop + 1) - pstTempHB->pi32Heap) - (i32NewInt * 32);
                pstTempHB->pi32BitField[i32NewInt] |= (((int32) 1L) << i32NewBit);

                if (HASFLAG(((tObject*) (pi32NewTop + 1)), GARBAGE_PERSISTENT))
                {
                  RPOT_ChangeLA(((tObject*) (pi32NewTop + 1))->pid, (tObject*) (pi32NewTop + 1));
                  if (((tObject*) (pi32NewTop + 1))->hHandle)
                  {
                    *(((tObject*) (pi32NewTop + 1))->hHandle) = (tObject*) (pi32NewTop + 1);
                  }
                }
                else
                {
                  *(((tObject*) (pi32NewTop + 1))->hHandle) = (tObject*) (pi32NewTop + 1);
                  if (((tObject*) (pi32NewTop + 1))->pid)
                  {
                    TPOT_ChangeLA(((tObject*) (pi32NewTop + 1))->pid, (tObject*) (pi32NewTop + 1));
                  }
                }

                /* change variable / elements pointer */
                if ((((tObject*) (pi32NewTop + 1))->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
                {
                  ((tObject*) (pi32NewTop + 1))->pi32Vars = (int32*) (((byte*) (pi32NewTop + 1)) + ROUND32BIT(sizeof(tObject)));
                }
                else
                {
                  ((tArray*) (pi32NewTop + 1))->pvElements = (void*) (((byte*) (pi32NewTop + 1)) + ROUND32BIT(sizeof(tArray)));
                }
              }
              /* change new top by adding size of object that is after it... this
                 might be an object that has just been moved there or it might be
                 an object that was always there (if no objects have been thrown
                 away yet) */
              pi32NewTop += pi32NewTop[0];
            }
            else
            {
              /* if we're not keeping the object we just need to unset its
                 bitfield entry */
              pstTempHB->pi32BitField[i] &= ~(((int32) 1L) << j);
            }
          }
        }
      }
    }
    pstTempHB->pi32FirstFree = pi32NewTop;
    pi32NewTop[0] = &(pstTempHB->pi32Heap[pstTempHB->i32HeapSize - 1 - pstTempHB->i32NumHandles]) - pi32NewTop;
    pi32NewTop[1] = (int32) NULL;
#if 0
    memset(pi32NewTop + 1, 0xaa, (pi32NewTop[0] - 1) * sizeof(int32));
#endif
  }



  printf("^");

/*  PrintObjects();*/
}

static int EvictCategorise
(
  tObject* o,
  int32 i32Flag,
  int32 ai32CatSizes[]
)
{
   int iCat;

  /* the way things are categorised here depends on the fact that
     program-reachable marking occurs before RPOT-reachable marking */

/*  printf("Categorising object %p of type %s\n",o,o->pstType->uidName);*/

  if (i32Flag == GARBAGE_REACHABLE)
  {
    /* dirty */
    if (HASFLAG(o, PERSIST_Dirty))
    {
      /* persistent */
      if (HASFLAG(o, GARBAGE_PERSISTENT))
      {
        SETFLAG(o, GARBAGE_EVCAT_6);   /* RDP */
        iCat = 6;
        ai32CatSizes[6 - 1] += ((int32*) o)[-1];
      }
      /* transient */
      else
      {
        SETFLAG(o, GARBAGE_EVCAT_8);   /* RT */
        iCat = 8;
        ai32CatSizes[8 - 1] += ((int32*) o)[-1];
      }
    }
    /* clean */
    else
    {
      /* persistent */
      if (HASFLAG(o, GARBAGE_PERSISTENT))
      {
        SETFLAG(o, GARBAGE_EVCAT_5);   /* RCP */
        iCat = 5;
        ai32CatSizes[5 - 1] += ((int32*) o)[-1];
      }
      /* transient */
      else
      {
        SETFLAG(o, GARBAGE_EVCAT_8);   /* RT */
        iCat = 8;
        ai32CatSizes[8 - 1] += ((int32*) o)[-1];
      }
    }
  }
  else if (i32Flag == GARBAGE_REACHABLEFROMRPOT)
  {
    /* dirty */
    if (HASFLAG(o, PERSIST_Dirty))
    {
      /* persistent */
      if (HASFLAG(o, GARBAGE_PERSISTENT))
      {
        /* reachable */
        if (HASFLAG(o, GARBAGE_REACHABLE))
        {
          /* these should have been found previously */
          #ifdef DEBUG
          if (!HASFLAG(o, GARBAGE_EVCAT_6))
          {
            printf("oops 6 (%s)!\n",o->pstType->uidName);
          }
/*          assert(HASFLAG(o, GARBAGE_EVCAT_6));*/
          #endif
/*          SETFLAG(o, GARBAGE_EVCAT_6);*/ /* RDP */
        iCat = 6;
/*          ai32CatSizes[6 - 1] += ((int32*) o)[-1];*/
        }
        /* unreachable */
        else
        {
          SETFLAG(o, GARBAGE_EVCAT_3); /* UDP */
          iCat = 3;
          ai32CatSizes[3 - 1] += ((int32*) o)[-1];
        }
      }
      /* pseudo-persistent */
      else
      {
        /* reachable */
        if (HASFLAG(o, GARBAGE_REACHABLE))
        {
          /* these should have been flagged as cat 8 */
          #ifdef DEBUG
          if (!HASFLAG(o, GARBAGE_EVCAT_8))
          {
            printf("oops 8 (%s)!\n",o->pstType->uidName);
          }
/*          assert(HASFLAG(o, GARBAGE_EVCAT_8));*/
          #endif
          CLEARFLAG(o, GARBAGE_EVCAT_8);
          ai32CatSizes[8 - 1] -= ((int32*) o)[-1];
          if (HASFLAG(o, GARBAGE_BEENSWOPPED))
          {
            SETFLAG(o, GARBAGE_EVCAT_6); /* RDp1 */
            iCat = 6;
            ai32CatSizes[6 - 1] += ((int32*) o)[-1];
          }
          else
          {
            SETFLAG(o, GARBAGE_EVCAT_7); /* Rp0 */
            iCat = 7;
            ai32CatSizes[7 - 1] += ((int32*) o)[-1];
          }
        }
        /* unreachable */
        else
        {
          if (HASFLAG(o, GARBAGE_BEENSWOPPED))
          {
            SETFLAG(o, GARBAGE_EVCAT_3); /* UDp1 */
            iCat = 3;
            ai32CatSizes[3 - 1] += ((int32*) o)[-1];
          }
          else
          {
            SETFLAG(o, GARBAGE_EVCAT_4); /* Up0 */
            iCat = 4;
            ai32CatSizes[4 - 1] += ((int32*) o)[-1];
          }
        }
      }
    }
    /* clean */
    else
    {
      /* persistent */
      if (HASFLAG(o, GARBAGE_PERSISTENT))
      {
        /* reachable */
        if (HASFLAG(o, GARBAGE_REACHABLE))
        {
          /* these should have been found previously */
          #ifdef DEBUG
          if (!HASFLAG(o, GARBAGE_EVCAT_5))
          {
            printf("oops 5 (%s)!\n",o->pstType->uidName);
          }
/*          assert(HASFLAG(o, GARBAGE_EVCAT_5));*/
          #endif
/*          SETFLAG(o, GARBAGE_EVCAT_5);*/ /* RCP */
        iCat = 5;
/*          ai32CatSizes[5 - 1] += ((int32*) o)[-1];*/
        }
        /* unreachable */
        else
        {
          SETFLAG(o, GARBAGE_EVCAT_2); /* UCP */
          iCat = 2;
          ai32CatSizes[2 - 1] += ((int32*) o)[-1];
        }
      }
      /* pseudo-persistent */
      else
      {
        /* reachable */
        if (HASFLAG(o, GARBAGE_REACHABLE))
        {
          /* these should have been flagged as cat 8 */
          #ifdef DEBUG
          if (!HASFLAG(o, GARBAGE_EVCAT_8))
          {
            printf("oops 8 (%s)!\n",o->pstType->uidName);
          }
/*          assert(HASFLAG(o, GARBAGE_EVCAT_8));*/
          #endif
          CLEARFLAG(o, GARBAGE_EVCAT_8);
          ai32CatSizes[8 - 1] -= ((int32*) o)[-1];
          if (HASFLAG(o, GARBAGE_BEENSWOPPED))
          {
            SETFLAG(o, GARBAGE_EVCAT_5); /* RCp1 */
            iCat = 5;
            ai32CatSizes[5 - 1] += ((int32*) o)[-1];
          }
          else
          {
            SETFLAG(o, GARBAGE_EVCAT_7); /* RCp0 */
            iCat = 7;
            ai32CatSizes[7 - 1] += ((int32*) o)[-1];
          }
        }
        /* unreachable */
        else
        {
          if (HASFLAG(o, GARBAGE_BEENSWOPPED))
          {
            SETFLAG(o, GARBAGE_EVCAT_2); /* UCp1 */
            iCat = 2;
            ai32CatSizes[2 - 1] += ((int32*) o)[-1];
          }
          else
          {
            SETFLAG(o, GARBAGE_EVCAT_4); /* UCp0 */
            iCat = 4;
            ai32CatSizes[4 - 1] += ((int32*) o)[-1];
          }
        }
      }
    }
  }
  return iCat - 1;
}

void Evict
(
  int32 i32SpaceNeeded
)
{
  int32 ai32CatSizes[8] = {0,0,0,0,0,0,0,0};
  int32 ai32PrefSizes[8] = {0,0,0,0,0,0,0,0};
  int32 ai32DefSizes[8] = {0,0,0,0,0,0,0,0};
  int32 i32CurrSpace;
  int32 i32CatsNeeded;
  int32 i32EvMask;
  int i;
  int32 i32Total;
  int32 i32OnlyTPOT = 0;
  int iDoOnlyTPOT;

  /* mark reachable objects */
  fprintf(stderr, "m");
  MarkReachableFromMachine(ai32CatSizes, ai32DefSizes, ai32PrefSizes);

  fprintf(stderr, "r");
  MarkReachableFromRPOT(ai32CatSizes);
  fprintf(stderr, "t");
  MarkReachableFromTPOT(&i32OnlyTPOT);
  fprintf(stderr, ".");

  /* find out how many unreachable objects there are */
  i32Total = 0;
  for (i = 1; i < 8; i++)
  {
    i32Total += ai32CatSizes[i];
  }
  ai32CatSizes[0] = pstHeapList->i32HeapSize - pstHeapList->pi32FirstFree[0] - pstHeapList->i32NumHandles - i32Total - i32OnlyTPOT;

  /* always swop out TPOT-only objects, since they don't seem terribly
     likely to be used soon */
  iDoOnlyTPOT = 1;
  i32CurrSpace = i32OnlyTPOT;

  /* find out how many categories we need to evict */
  i32CatsNeeded = 1;
  i32CurrSpace += (ai32CatSizes[i32CatsNeeded - 1] - ai32DefSizes[i32CatsNeeded - 1]);
  while (i32CurrSpace < i32SpaceNeeded)
  {
    if (i32CatsNeeded == 8)
    {
/*      printf("Including TPOT-only objects in gc!\n");
      iDoOnlyTPOT = 1;*/
      printf("Couldn't find enough free space!\n");
      break;
    }
    i32CatsNeeded += 1;
    i32CurrSpace += (ai32CatSizes[i32CatsNeeded - 1] - ai32DefSizes[i32CatsNeeded - 1]);
  }

  printf("(%d,%d,%d,%d,%d,%d,%d,%d):%d", ai32CatSizes[0], ai32CatSizes[1], ai32CatSizes[2], ai32CatSizes[3], ai32CatSizes[4], ai32CatSizes[5], ai32CatSizes[6], ai32CatSizes[7], i32CatsNeeded);

  /* construct an eviction mask */
  i32EvMask = 0;
  if (i32CatsNeeded > 1) i32EvMask |= GARBAGE_EVCAT_2;
  if (i32CatsNeeded > 2) i32EvMask |= GARBAGE_EVCAT_3;
  if (i32CatsNeeded > 3) i32EvMask |= GARBAGE_EVCAT_4;
  if (i32CatsNeeded > 4) i32EvMask |= GARBAGE_EVCAT_5;
  if (i32CatsNeeded > 5) i32EvMask |= GARBAGE_EVCAT_6;
  if (i32CatsNeeded > 6) i32EvMask |= GARBAGE_EVCAT_7;
  if (i32CatsNeeded > 7) i32EvMask |= GARBAGE_EVCAT_8;

  DoEvictions(i32EvMask, iDoOnlyTPOT);
}



void GARBAGE_OldWriteEverything
(
  void
)
{
  tHeapBlock* pstTempHB;
  int         i, j;
  tObject*    pstTempObject;

  /* go through all heap blocks */
  for (pstTempHB = pstHeapList; pstTempHB; pstTempHB = pstTempHB->pstNext)
  {
    /* go through bitfield of this heap block */
    for (i = 0; i < pstTempHB->i32BFSize; i++)
    {
      /* check if there are any bits set in this int32 */
      if (pstTempHB->pi32BitField[i])
      {
        /* find the set bit(s) */
        for (j = 0; j < 32; j++)
        {
          if (pstTempHB->pi32BitField[i] & (((int32) 1L) << j))
          {
            /* found an object */
            pstTempObject = (tObject*) &(pstTempHB->pi32Heap[32 * i + j]);
            if (!HASFLAG(pstTempObject, GARBAGE_LEAVEALONE))
            {
              if (HASFLAG(pstTempObject, PERSIST_Dirty))
              {
                #ifdef PJSLREAL
                WriteStoreFormat(pstTempObject, 1, NULL);
                #else
                WriteStoreFormat(pstTempObject, 1);
                #endif
              }
            }
          }
        }
      }
    }
  }
}


void GARBAGE_WriteEverything
(
  void
)
{
  tHeapBlock* pstTempHB;
  int         i, j;
  tObject*    pstTempObject;
  #ifdef PJSLREAL
  tAllocQueue*     pstAQ;
  tAllocQueueElem* pstAQE;
  pjsl_regime_t    regime;
  pjsl_obj_info_t info = 0;
  pjsl_hid_t histID = PJSL_HISTMAN_ILLEGAL_HID;
  #ifdef PJSL_UPDATES_SEPARATE
  inf finished = 0;
  #endif
  #endif

  int32 ai32CatSizes[8] = {0,0,0,0,0,0,0,0};
  int32 i32OnlyTPOT = 0;


  /* First we mark things. We need to mark everything reachable from the
     RPOT and also everything reachable only from the TPOT. If we want to
     do some garbage collection afterwards, we should mark everything
     reachable from the machine as well (coming later) */

/*  printf("m");
  MarkReachableFromMachine(ai32CatSizes, ai32DefSizes, ai32PrefSizes);*/
  printf("r");
  MarkReachableFromRPOT(ai32CatSizes);
  printf("t");
  MarkReachableFromTPOT(&i32OnlyTPOT);
  printf(".");

  #ifdef PJSLREAL
  pstAQ = AQ_InitQueue();
  #endif

  /* go through all heap blocks */
  for (pstTempHB = pstHeapList; pstTempHB; pstTempHB = pstTempHB->pstNext)
  {
    /* go through bitfield of this heap block */
    for (i = 0; i < pstTempHB->i32BFSize; i++)
    {
      /* check if there are any bits set in this int32 */
      if (pstTempHB->pi32BitField[i])
      {
        /* find the set bit(s) */
        for (j = 0; j < 32; j++)
        {
          if (pstTempHB->pi32BitField[i] & (((int32) 1L) << j))
          {
            /* found an object */
            pstTempObject = (tObject*) &(pstTempHB->pi32Heap[32 * i + j]);

            /* clear the category markings - we're not going to use them and
               we certainly don't want them to be saved */
            CLEARFLAG(pstTempObject, GARBAGE_EVCAT_MASK);

            if (!HASFLAG(pstTempObject, GARBAGE_LEAVEALONE))
            {
              /* if reachable from RPOT:
                   if persistent and dirty, write
                   if not persistent, write
              */
              if (HASFLAG(pstTempObject, GARBAGE_REACHABLEFROMRPOT))
              {
                /* clear markings before it's written */
                CLEARFLAG(pstTempObject, GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT | GARBAGE_REACHABLEFROMTPOTONLY);
                if (pstTempObject->pid)
                {
                  if (HASFLAG(pstTempObject, PERSIST_Dirty))
                  {
                    CLEARFLAG(pstTempObject, PERSIST_DirtyMask);
                    #ifdef PJSLREAL
                    WriteStoreFormat(pstTempObject, 1, pstAQ);
                    #else
                    WriteStoreFormat(pstTempObject, 1);
                    #endif
                  }
                }
                else
                {
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 1, pstAQ);
                  #else
                  WriteStoreFormat(pstTempObject, 1);
                  #endif
                }
              }
              /* if reachable from TPOT only:
                   same as for RPOT
              */
              else if (HASFLAG(pstTempObject, GARBAGE_REACHABLEFROMTPOTONLY))
              {
                /* clear markings before it's written */
                CLEARFLAG(pstTempObject, GARBAGE_REACHABLE | GARBAGE_REACHABLEFROMRPOT | GARBAGE_REACHABLEFROMTPOTONLY);
                if (pstTempObject->pid)
                {
                  if (HASFLAG(pstTempObject, PERSIST_Dirty))
                  {
                    CLEARFLAG(pstTempObject, PERSIST_DirtyMask);
                    #ifdef PJSLREAL
                    WriteStoreFormat(pstTempObject, 1, pstAQ);
                    #else
                    WriteStoreFormat(pstTempObject, 1);
                    #endif
                  }
                }
                else
                {
                  #ifdef PJSLREAL
                  WriteStoreFormat(pstTempObject, 1, pstAQ);
                  #else
                  WriteStoreFormat(pstTempObject, 1);
                  #endif
                }
              }
            }
          }
        }
      }
    }
  }

  #ifdef PJSLREAL
  /* actually write all the objects that have been allocated and put into the queue */

  #ifdef PJSL_UPDATES_SEPARATE
  /* if we are keeping updates separate to firstWrites then we must weed out
     all the updates and put them onto the end of the queue until we have
     finished all the firstWrites */


  do
  {
    if (pstAQ->head)
    {
      if (AQ_HeadMustFirstWrite(pstAQ))
      {
        /* do the firstWrite */
        pstAQE = AQ_DeQueue(pstAQ);
        regime = pjsl_map_kind_to_regime(KIND, pstAQE->size);
        PJSL_KIND_OP(KIND,regime,firstWrite)(STORE_Store, pstAQE->pid, pstAQE->size, info, (uchar*) pstAQE->obj, NULL, histID);
        free(pstAQE);
      }
      else
      {
        /* if we've finished all the firstWrites then do the update, otherwise
           move it to the back of the queue */
        if (pstAQ->mustFirstWriteCount == 0)
        {
          /* do the update */
          pstAQE = AQ_DeQueue(pstAQ);
          regime = pjsl_map_kind_to_regime(KIND, pstAQE->size);
          PJSL_KIND_OP(KIND,regime,updateAll)(STORE_Store, pstAQE->obj->pid, (uchar*) pstAQE->obj, NULL, histID);
          free(pstAQE);
        }
        else
        {
          /* move it to the end */
          AQ_MoveHeadToTail(pstAQ);
        }
      }
    }
    else
    {
      finished = 1;
    }
  } while (!finished);
  #else
  pstAQE = AQ_DeQueue(pstAQ);
  while (pstAQE)
  {
/*fprintf(stderr, "queue mapping kind %d of size %d\n", KIND, pstAQE->size);*/
    regime = pjsl_map_kind_to_regime(KIND, pstAQE->size);
    if (pstAQE->mustFirstWrite == 1)
    {
      /*fprintf(stderr, "doing mustFirstWrite!\n");*/
      PJSL_KIND_OP(KIND,regime,firstWrite)(STORE_Store, pstAQE->pid, pstAQE->size, info, (uchar*) pstAQE->obj, NULL, histID);
    }
    else
    {
      /*fprintf(stderr, "doing update!\n");*/
      PJSL_KIND_OP(KIND,regime,updateAll)(STORE_Store, pstAQE->pid, (uchar*) pstAQE->obj, NULL, histID);
    }
    if (pstAQE->classPtr)
    {
      ((tObject*) pstAQE->obj)->pstType = pstAQE->classPtr;
    }
    free(pstAQE);
    pstAQE = AQ_DeQueue(pstAQ);
  }
  #endif
  #endif

}

#endif

