 #ifdef STACKMAP_WHOOH
    canStartStackMaps = 0;
    /* ------------------------------------------------ */
    {
	jclass clazz = (*jni_env)->FindClass(jni_env, "cavalry/stackmap/MapGenerator");
	if(clazz)
	    {
		jmethodID methodID = (*jni_env)->GetMethodID(jni_env, clazz, "prepareForOperation", "()Z");
		jobject ret;

		assert(methodID);

		pstFrame = InitialStackFrame(methodID, NULL, NULL, system_heap);
		hMainThread = INTERP_NewObjectFromName(jni_env, "java/lang/Thread");
		THREAD_InitMainThread(hMainThread, 5, pstFrame, pstJNIData);

		fprintf(stderr," calling stackmap bootstrap in interp.c\n");

		assert(THREADINFO_addInitialStackFrameToNode( node, pstFrame ) == 0);
		ret = Interpret(jni_env,pstFrame, 1);
		assert(THREADINFO_removeInitialStackFrameFromNode( node, pstFrame ) == 0);

		if(ret == NULL)
		    {
		    fprintf(stderr," did stackmap bootstrap in interp.c\n");
		    canStartStackMaps = 1;
		    }
		else
    		    fprintf(stderr," FAILED stackmap bootstrap in interp.c\n");
		if( (*jni_env)->ExceptionOccurred(jni_env) )
		    {
			(*jni_env)->ExceptionDescribe(jni_env);
			(*jni_env)->ExceptionClear(jni_env);
		    }
	    }
	fprintf(stderr," finished stackmap bootstrap in interp.c\n");
    }
    /* ------------------------------------------------ */
#endif
