/*
 * @doc TYPE
 * @struct
 * This structure stores all the information needed about code in a method.
 *
 */

/* Structure to represent the stack map at each point of a method's execution 
 *
 * The format is an integer containing the number of entries. We are basically storing a table:
 *
 * Instruction range			Map
 *
 *    0 - 1				
 *    2 - 5				I
 *    6 - 7				III
 *    etc
 *
 *  The number of entries is the number of rows in this table.
 *
 *  Then we encode each instruction range as a byte, with the high bit set to 0.
 *  The Map is encoded with the following 2-bit values:
 *
 *	00 - End of sequence
 *	01 - Literal value on stack
 *	10 - Address on stack
 *	11 - Unused
 *
 *  It is just a repetition of 01, 10 values until ended by 00. 
 *
 *  The information for the next row follows directly in the bit stream.
 *
 *  If the range of instructions is greater than 128, we use an integer with the high bit set to 1
 *
 */
/* Once we've built stack maps for each instruction , we compact the data into this structure */

#ifdef STACKMAP
struct tstackmap 
{
  //Private data used for building map
  int bitsUsed;
  int bitsAllocated;
  //Public data
  unsigned char* data;
  int i32NumEntries;
};
#endif 



struct tcode
{
  #ifdef CLASSPERSIST
  PID pid;
  #endif
  #ifdef ENABLE_SVETLANA
    int (*pOptimisedCode) (int32*,void*); /* Pointer to the optimised method */
  #endif
  uint16  u16MaxStack;     /* @field Maximum size of operand stack */
  uint16  u16MaxLocals;    /* @field Maximum number of local variables */
  uint32 u32CodeLength;  /* @field Length of byte code */
  byte*  pbCode;         /* @field Pointer to actual byte code */
  uint16 u16ExceptionTableLength;             /* @field Number of exceptions */
  tExceptionInfo* pstExceptionTable;          /* @field Exception info */
  tLineNumberTable* pstLineNumberTable;       /* @field Line number info */
  tLocalVariableTable* pstLocalVariableTable; /* @field Local variable info */
  #ifdef STACKMAP
   struct tstackmap* pstStackMap;
  #endif
};


