#include <config.h>

#include <stdio.h>
#include <assert.h>
#include <string.h>

//This code is meant to analyse the java bytecode for a java function and see whether it can be compiled or not
#include "svetlana.h"

#include "../jni.h"
#include "../interp.h"
#include "../newobject.h"
#include "../opcodes.h"
#include "../disass.h"

#include "assemble.h"

#ifdef ANALYSE_OPS

void SVETLANA_printstats(JNIEnv* env)
{
    #ifdef USE_FAST_GENERATOR
    fprintf(stderr, "Printing stats %x\n", env);
    {
    	jclass clazz  = (*env)->FindClass(env, "cavalry/translator/Analyzer");
	
	if(clazz)
	    {
		jmethodID methodID = (*env)->GetStaticMethodID(env, clazz, "showStats", "()Z");
		jboolean retval ;

		assert(methodID);
		assert(clazz);

		retval = (*env)->CallStaticBooleanMethod (env, clazz, methodID);
	    }
    }
    #else
  int i;
  for( i = 0; i < 226;i++)
    {
	if( buckets[i] > 0)
	    {
		fprintf(stderr, "%i\t");
		DISASS_PrintInstructionName(stderr, i);
		fprintf(stderr, "\t %i\n", buckets[i]);
	    }
    }

  fprintf(stderr, "Percentage of methods optimised: %3.0f%% (%i out of %i)\n", (float) canoptimise * 100.0f / (float) (canoptimise + cantoptimise), canoptimise, cantoptimise + canoptimise);
#endif
}
#endif

int SVETLANA_CanOptimiseMethod(JNIEnv* env, tMethod* method, byte* pCode, int length) {

    exit(33);
    if((method->u16AccessFlags & ACC_NATIVE) || (method->u16AccessFlags & ACC_SYNCHRONISED))
	return 0;


        if(method->pstCode->u16ExceptionTableLength != 0)
	    {
		fprintf(stderr, "Can't compile method %s.%s because it has exception handlers\n", method->pstClass->uidName, method->uidName);
		return 0;
	    }

	if(strstr(method->pstClass->uidName, "java"))
	    return 0;
#ifdef USE_FAST_GENERATOR
    {
    	jclass clazz  = (*env)->FindClass(env, "cavalry/translator/Analyzer");
	
	if(clazz)
	    {
		jmethodID methodID = (*env)->GetMethodID(env, clazz, "canCompileMethod", "([BLjava/lang/String;Ljava/lang/String;)Z");
		tARREF pstArrayTemp;
		jstring methodName;
		jstring methodSig;

		jboolean retval ;
		int i;

		assert(methodID);
		assert(clazz);

		pstArrayTemp = INTERP_NewArray(env, T_BYTE, length, 0, NULL);
		for(i = 0; i < length;i++)
		    {
			((byte*) ADEREF(pstArrayTemp)->pvElements)[i] = pCode[i];
		    }

		methodName = INTERP_NewStringFromAsciz( env, method->uidName );
		methodSig = INTERP_NewStringFromAsciz( env, method->uidSignature );

		//				fprintf(stderr, "method name is %s\n", method->uidName);
		retval = (*env)->CallStaticBooleanMethod (env, clazz, methodID, pstArrayTemp, methodName, methodSig);

		if(retval == JNI_FALSE)
		    return 0;
		return 1;
	    }
	else
	    {
		fprintf(stderr, "Couldn't find class kissme/code_generator/fast_generator/Analyzer\n");
		return 0;
	    }
    }
#else
#error Where is the fast one?

#endif //FAST_GEN
    return 0;
}

int eatme(int32* optop)
{
    int i32Temp = (DEREF((tOBREF) *optop))->pi32Vars[203];
    return 0;
}


int bobo(int32* optop)
{
    tOBREF pstObject;
    if(*optop == 0)
	{
	    return 1;
	}
    else
	return 2;

    if(pstObject != 0)
	return 0;
    return (int) pstObject + 2;
}
 

