#include <config.h>
#include "../interp.h"
#include "../stdtypes.h"
#include "control.h"
#include <stdio.h>
#include <assert.h>
/* Methods used for control flow

   ie
   
   ifeq
   ifne
   iflt
   ifge
   ifgt
   ifle
   
   ifnull
   ifnonnull


 */
/* Plan for generating branches 

Simple branch (no goto)

Method int oneBranch(boolean)
   0 iconst_0
   1 istore_2
   2 iload_1
<--3 ifeq 8
   6 iconst_1
   7 istore_2
-->8 iload_2
   9 ireturn     

with goto:
Method int controlMethod(boolean)
   0 iconst_0
      1 istore_2
      2 iload_1
**    3 ifeq 11
      6 iconst_1
      7 istore_2
**    8 goto 13
      11 iconst_0
      12 istore_2
      13 iload_2
      14 ireturn      

   Well, when we hit a branch instruction, ie 
   ifeq then we know we need to insert a conditional branch.

   We're branching to a known java instruction number (here 11).

   So we push this number (and a pointer) on the stack (if it appears in a later java instruction we patch in the address).

   When we hit instruction 11 we record its address (or the difference between the two). And create the forward jump.

   When we hit goto we do the same thing. 

 */


void* gen_c_ifeq(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;

    // d:   3d 00 00 00 00          cmpl   $0x0,%eax         
    *(pbIter++) = 0x3d;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //    18:   0f 84 13 00 00 00       je     31 <label1>   
    //	12:   0f 85 00 00 00 00       jne    18 <label1>
    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x84;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
      return pbIter;
}

/*
  LT

 */

void* gen_c_iflt(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

		    fprintf(stderr, "Generating lt jump 2\n");

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;


    // d:   ba 00 00 00 00          movl   $0x0,%edx

    *(pbIter++) = 0xba;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //	  12:   39 c2                   cmpl   %eax,%edx
    //    12:   39 d0                   cmpl   %edx,%eax
    //    719:   83 7d fc 00             cmpl   $0x0,0xfffffffc(%ebp) 	  

    // d:   ba 00 00 00 00          movl   $0x0,%edx
    //	  12:   39 d0                   cmpl   %edx,%eax
	   
    *(pbIter++) = 0x39;
    *(pbIter++) = 0xd0;

    //    14:   0f 8d 13 00 00 00       jge    2d <label1>  this is equivalent to jnl
    //    722:   7d 07                   jnl    72b <dobranch+0x2f>     
    //    14:   0f 8c 13 00 00 00       jl     2d <label1>
    //	  14:   0f 8f 13 00 00 00       jg     2d <label1> 
    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x8c;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
      return pbIter;
}

/*
  JLE

 */

void* gen_c_ifle(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;

    //    12:   f7 d8                   negl   %eax
    *(pbIter++) = 0xf7;
    *(pbIter++) = 0xd8;

    // d:   3d 00 00 00 00          cmpl   $0x0,%eax         
    *(pbIter++) = 0x3d;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //    18:   0f 84 13 00 00 00       je     31 <label1>   
    //	12:   0f 85 00 00 00 00       jne    18 <label1>
    //    3b8:   7d 07                   jnl    3c1 <dobranch+0x15> 
    //    12:   0f 8d 13 00 00 00       jge    2b <label1>   
    //    12:   0f 8f 13 00 00 00       jg     2b <label1>

    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x8f;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
      return pbIter;
}

/*
  NE

 */

void* gen_c_ifne(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;

    // d:   3d 00 00 00 00          cmpl   $0x0,%eax         
    *(pbIter++) = 0x3d;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //    18:   0f 84 13 00 00 00       je     31 <label1>   
    //	12:   0f 85 00 00 00 00       jne    18 <label1>
    //    3b8:   7d 07                   jnl    3c1 <dobranch+0x15> 
    //    12:   0f 8d 13 00 00 00       jge    2b <label1>   
    //    12:   0f 8f 13 00 00 00       jg     2b <label1>

    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x85;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
    return pbIter;
}


/*
  GE

 */

void* gen_c_ifge(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;

    // d:   3d 00 00 00 00          cmpl   $0x0,%eax         
    *(pbIter++) = 0x3d;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //    18:   0f 84 13 00 00 00       je     31 <label1>   
    //	12:   0f 85 00 00 00 00       jne    18 <label1>
    //    3b8:   7d 07                   jnl    3c1 <dobranch+0x15> 
    //    12:   0f 8d 13 00 00 00       jge    2b <label1>   
    //    12:   0f 8f 13 00 00 00       jg     2b <label1>

    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x8d;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
      return pbIter;
}

/*
  GT

 */

void* gen_c_ifgt(byte* pbCode, int current_op, byte* pbIter, tList *pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate the test code 

    //First pop the stack to eax
    //    9:   58                      popl   %eax 
    *(pbIter++) = 0x58;

    // d:   3d 00 00 00 00          cmpl   $0x0,%eax         
    *(pbIter++) = 0x3d;

    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    //    18:   0f 84 13 00 00 00       je     31 <label1>   
    //	12:   0f 85 00 00 00 00       jne    18 <label1>
    //    3b8:   7d 07                   jnl    3c1 <dobranch+0x15> 
    //    12:   0f 8d 13 00 00 00       jge    2b <label1>   
    //    12:   0f 8f 13 00 00 00       jg     2b <label1>

    *(pbIter++) = 0x0f;
    *(pbIter++) = 0x8f;

    //If it is not equal then branch to this java instruction
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated branch for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
      return pbIter;
}


/* A simple goto instruction */

void* gen_c_goto(byte* pbCode, int current_op, byte* pbIter, tList* pstLabels)
{
    jumplabel* label;
    int branch_to = *(pbCode + 1) * 256;
    branch_to += *(pbCode + 2);

    //This is a relative branch, make sure it is forward
    assert(branch_to >= 0);

    branch_to += current_op;

    label = malloc( sizeof(jumplabel));
    assert(label);
    label->java_instruction = branch_to;

    label->patch_location = (void*) -1;
    
    //Now generate jump code 
    //    25:   e9 00 00 00 00          jmp    2a <label2>  
    *(pbIter++) = 0xe9;

    //Stick in the branch
    label->patch_location = pbIter;
    LLIST_AddAtHead(pstLabels, label);

#ifdef DEBUG_BRANCHES
    fprintf(stderr, "Generated jmp for java instruction %i, list count %i\n", label->java_instruction, pstLabels->count);
#endif
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;
    *(pbIter++) = 0x00;

    label->address = (void*) pbIter;
    return pbIter;
}

void dobranch(int32* optop)
{
    int b = 77;
    if(b < 0 )
	{
	    b = 1;
	 }
    b = -b;

}
