#ifdef USE_DISTRIBUTED_STORE
/*
    This is the implementation of the part of the Virtual Disk Cache that talks to the Virtual Disk Proxy
    
    John Leuner
 */


#define DEBUG_PROXY

#include <pthread.h>
#include "virtual_disk_cache.h"
#include "storemanager.h"
#include "store_communication.h"

#include <assert.h>
#include "gamma.h"



/*Start lock service*/

int initialized_lock_service = 0;

/*Global variables for all threads*/

char remoteHost[] = "svetlana";
int sequence = 555;

static int BUFFER_SIZE = 65 * 1024; 
void service_proxy_thread(char** arg);

int running_port = 26787;

void pinitialize_thread_context(struct thread_context *acontext)
{
    struct sockaddr_in to;

    to.sin_family = AF_INET;
    if(inet_aton("1.0.0.2", &to.sin_addr) == 0)
	{
	    perror("initialize_remote_socket");
	}


    acontext->free_object_entry = -1;
    acontext->free_data_block = 0;
    acontext->low_object_entry_lock = -1;
    acontext->high_object_entry_lock = -1;


    acontext->listen_thread_ready = 0;
    acontext->lock_listen_thread_ready = 0;

    acontext->our_id_host = to.sin_addr.s_addr;
    acontext->our_id_port = htons(9009);

    acontext->locking_socket = -1;
}

  int proxy_listen_socket = -1;

void listen_for_proxy_thread(char** arg)
{

  struct sockaddr_in sin;
  int len;
  int fd;
  int finished = 0;
  pthread_t service_tid;

  int connection_counter = 0;



	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(PROXY_PORT);

	if(( proxy_listen_socket = socket(PF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror("Error opening socket for store manager ");
		exit(1);
	}

	setsockopt(proxy_listen_socket, SOL_SOCKET, SO_REUSEADDR, NULL, sizeof(int));
	if(bind(proxy_listen_socket, (struct sockaddr*) &sin, sizeof(sin)) < 0)
	{
	        printf("Failure on port %i\n", PROXY_PORT);
		perror("Error binding socket for store proxy");
		exit(1);
	}

	printf("About to listen in store manager on port %i\n", PROXY_PORT);

	listen(proxy_listen_socket,5);

	len = sizeof(sin);

while(1)
    {
	if(( fd = accept(proxy_listen_socket, (struct sockaddr *) &sin, &len)) < 0)
	{
		perror("error accepting connection in Server");
		exit(1);
	}

	printf("** Accepted socket in store manager\n");
	printf("** Spawning thread ... (%i) \n", connection_counter); 
	connection_counter++;
	if(pthread_create(&service_tid, NULL,  & (service_proxy_thread), (void*) &fd) == -1)
	    {
		perror("storemanager failed to create service thread for proxy");
	    }
	printf("** Spawn thread ... \n"); 
    }

    close(proxy_listen_socket);
    printf("Thread listening for proxy connections is shutting down, accepted %i connections\n", connection_counter);
    
	
}



char page_buffer[BLOCK_SIZE];

void service_proxy_thread(char** arg)
{
    int fd;
    pthread_t listen_t;
    struct virtual_disk_command *command;
    struct thread_context context;
    int amt_read = 0;
    void* buffer;
  
    int finished = 0;
    int command_counter = 0;

    pthread_mutex_t mut = PTHREAD_MUTEX_INITIALIZER;

    fd = *((int*) arg);

    /*Initialize buffer !!!! */
    buffer = (void*) malloc (BUFFER_SIZE);



    if(buffer == NULL)
      {
	perror("Malloc failed in storemanager service_proxy_thread");
	printf("BUFFER_SIZE is %i\n", BUFFER_SIZE);
	exit(777);
      }
    pinitialize_thread_context(&context);
    context.mut = &mut;

    /*Initialize mutex*/
    pthread_mutex_init(context.mut, NULL);

    //    printf("testing id %i %i\n", context.our_id_host, context.our_id_port);


  printf("** All systems go \n");
    command = (struct virtual_disk_command*) buffer;
  
while(finished == 0)
    {
    amt_read = read(fd, command, sizeof(struct virtual_disk_command));
    if(amt_read == -1)
	{
	    perror("virtual_disk_cache: reading command");
	    break;
	}
    //    printf("virtual_disk_cache: amt_read %i\n", amt_read);
    assert(amt_read >= 0);
    while(amt_read < sizeof(struct virtual_disk_command))
      {
	  int add = read(fd, ((char*) command) + amt_read, sizeof(struct virtual_disk_command) - amt_read);
	  if(add <= 0)
	      {
		  finished = 1;
		  break;
	      }
	  assert(add > 0);
	  amt_read += add;
	  printf("Reading .....\n");
      }

	    if(amt_read != sizeof(struct virtual_disk_command))
	      {
		printf("Error, couldn't read the whole command, read %i, should be %i\n", amt_read, sizeof(struct virtual_disk_command));
		if(amt_read == -1)
		    {
		    perror("");
		    printf("Errno is %i, E_FAULT %i\n", errno, EFAULT);
		    }
		if(amt_read == 0)
		    {
			finished = 1;
			break;
		    }
		exit(254);
	      }

	    if(!(command->command > 0 && command->command <= 255))
	      {
		printf("Command out of range %i", command->command);
		exit(4);
	      }

	    command_counter++;

	    if(command->command == VIRTUAL_DISK_READ)
		{
		    int amt_written, result;
		    pthread_mutex_lock(context.mut);

#ifdef DEBUG_PROXY
		    printf("virtual_disk_cache doing READ l %i,a %x %x:o %i\n", command->length, (int) ((command->address) >> 32), (int) (((command->address)<< 32) >> 32), command->offset);		    
#endif
		    if((command->address >= 0x300000000000L))
			assert (command->address >= 0x400000000000L);
		    //		    printf("virtual_disk_cache doing READ %i\n", command->length);
		    result = GAMMA_read(command->address, page_buffer, command->offset, command->length);
		    if(result == command->length)
			{
			    amt_written = write(fd, &result, sizeof(result));
			    assert(amt_written == sizeof(result));

			    amt_written = write(fd, page_buffer, command->length);
			    assert(amt_written == command->length);
			    //			    printf("virtual_disk_cache wrote %i to proxy\n", command->length);
			}
		    else
			{
			    amt_written = write(fd, &result, sizeof(result));
			    assert(amt_written == sizeof(result));
			}

		    pthread_mutex_unlock(context.mut);
		}
	    else if(command->command == VIRTUAL_DISK_WRITE)
		{
		    int amt_read, result;
		    pthread_mutex_lock(context.mut);
#ifdef DEBUG_PROXY
		    printf("virtual_disk_cache doing WRITE %i, %x %x: %i\n", command->length, (int) ((command->address) >> 32), (int) (((command->address)<< 32) >> 32), command->offset);		    
#endif
		    if((command->address >= 0x300000000000L))
			assert (command->address >= 0x400000000000L);


		    amt_read = read(fd, page_buffer, command->length);
		    while(amt_read < command->length)
			{
			    amt_read += read(fd, page_buffer + (command->length - amt_read), command->length- amt_read);
			}
#ifdef DEBUG_PROXY
		    printf("vdc read %i %i\n", amt_read, command->length);
#endif
		    assert(amt_read == command->length);
		    result = GAMMA_write(command->address, page_buffer, command->offset, command->length);
		    amt_read = write(fd, &result, sizeof(result));
		    assert(amt_read == sizeof(result));
		    pthread_mutex_unlock(context.mut);
		}
	    else if(command->command == VIRTUAL_DISK_CLOSE_PROXY_CONNECTION)
		{
		    finished = 1;
		    GAMMA_flush(0, 0x700000000000L);
   		}
	    else
		{
		    printf("Unknown command %i\n", command->command);
		    exit(207);
		}
    }
	close(fd);
	printf("Thread listening to proxy is shutting down, processed %i commands\n", command_counter);
}

int main(int argc,char** argv)
{
    /* Thread ids for threads */
  pthread_t proxy_tid;
  pthread_t alpha_tid;
  char** buffer_arg;


  printf("Virtual Disk Cache started\n");
    /*Initialize lock service */

    if(initialized_lock_service == 0)
      {
    printf("main intializing ALPHA and ETA\n");
      ALPHA_initialize(  );
      ETA_initialize();
      GAMMA_initialize();
      initialized_lock_service = 1;
    printf("main intialized ALPHA and ETA\n");
      }


  //Start thread to listen for proxies connecting to us

  if(pthread_create(&proxy_tid, NULL, & (listen_for_proxy_thread), buffer_arg) == -1)
    {
      perror("storemanager create_thread for proxy");
    }

  {
      int readchar = -1;
      while((readchar != 0x0a))
	  {
	      if(read(0, &readchar, sizeof(readchar)) == 0)
		 readchar = 0x0a;
	      printf("Read %x %x\n", readchar, EOF);
	  }

  }

  printf("Virtual Disk Cache shutting down\n");
  if(close(proxy_listen_socket) != 0)
      perror("Virtual Disk Cache could not close proxy_listen_socket");
  proxy_listen_socket = -1;
  GAMMA_shutdown();
  ETA_shutdown();
  ALPHA_shutdown();
  printf("Virtual Disk Cache finished\n");

}



#endif
