#ifdef USE_ZIP_CLASSLOADER

#include "lib/minizip/unzip.h"

#include <stdio.h>

#define UNZ_OK                                  (0)


int ZIP_CLASSLOADER_LoadAndLink(char* pszClassName, char* pszZipFileName, void** classData)
{
        const char *zipfilename= pszZipFileName; //"kissme_bare.zip"; //bobo.zip";
	char extractFileName[256];
	int success = 0;
	unzFile uf;
	char filename_inzip[256];

	unz_file_info file_info;
	int uncompressed_size = 0;



	/* Open up the main zipfile, hardcoded to kissme.zip */

	uf = unzOpen(zipfilename);
	if(uf == NULL)
	    {
		printf("Could not open zip file %s\n", zipfilename);
		return -1; //failure
	    }

	/* Locate this class file inside that zip file */

	strcpy(extractFileName, ""); 
	strcat(extractFileName, pszClassName);
	strcat(extractFileName, ".class");

	if (unzLocateFile(uf,extractFileName, 0)!= UNZ_OK)
	    {
		strcpy(extractFileName, "./"); 
		strcat(extractFileName, pszClassName);
		strcat(extractFileName, ".class");
		if (unzLocateFile(uf,extractFileName, 0)!= UNZ_OK)
		    {
			printf("file %s not found in the zipfile\n",extractFileName);
			return 2;
		    }
	    }

	/* Retrieve info about this file entry */

	success = unzGetCurrentFileInfo(uf,&file_info,filename_inzip,sizeof(filename_inzip),NULL,0,NULL,0);

	if (success !=UNZ_OK)
	{
		printf("error %d with zipfile in unzGetCurrentFileInfo\n",success);
		return -1; //Failure
	}

	//Get the size
	uncompressed_size = file_info.uncompressed_size;

    
	//malloc the buffer  for the class data
	*classData = malloc(uncompressed_size);
	 if(*classData == NULL)
	     {
	     fprintf(stderr, "Error doing malloc in zip_classloader %i\n",uncompressed_size);
	     return -1; //failure
	     }
	else
	    {
		//Load this entry 
		int err = unzOpenCurrentFile(uf);
		if (err!=UNZ_OK)
		{
			printf("error %d with zipfile in unzOpenCurrentFile\n",err);
		}
		
		//Read the class data into the buffer
		err = unzReadCurrentFile(uf,*classData, uncompressed_size);
		if (err<0)	
		{
               		printf("error %d with zipfile in unzReadCurrentFile\n",err);
			return -1;
		}
		//		printf("read class ok\n");
	    }

	 //Be polite
	unzCloseCurrentFile(uf);

	//Thank the sisters of mercy
	return 0; //success
}


int ZIP_CLASSLOADER_CanFindClass(char* pszClassName, char* pszZipFileName)
{
        const char *zipfilename= pszZipFileName; 
	char extractFileName[256];
	int success = 0;
	unzFile uf;
	char filename_inzip[256];

	unz_file_info file_info;
	int uncompressed_size = 0;



	/* Open up the main zipfile, hardcoded to kissme.zip */

	uf = unzOpen(zipfilename);
	if(uf == NULL)
	    {
		printf("Could not open zip file %s\n", zipfilename);
		return -1; //failure
	    }

	/* Locate this class file inside that zip file */

	strcpy(extractFileName, ""); 
	strcat(extractFileName, pszClassName);
	strcat(extractFileName, ".class");

	if (unzLocateFile(uf,extractFileName, 0)!= UNZ_OK)
	    {
		strcpy(extractFileName, "./"); 
		strcat(extractFileName, pszClassName);
		strcat(extractFileName, ".class");
		if (unzLocateFile(uf,extractFileName, 0)!= UNZ_OK)
		    {
			return -1; //Failure
		    }
	    }
	
	return 0; //success
}

#endif //#ifdef USE_ZIP_CLASSLOADER


