/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include "config.h"
#include "klamav.h"
#include <kapplication.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <stdlib.h>
#include <kstandarddirs.h>
#include <kurl.h>

QString databasepath;
QString quarantinepath;



void
FirstRunWizard::init()
{

    //aesthetics
    cancelButton()->setFixedSize( cancelButton()->sizeHint() );
    helpButton()->hide();

    QString homepath = getenv("HOME");
    databasepath = homepath + "/.klamav/database";
    DatabaseLocation->setURL(databasepath);

    quarantinepath = homepath + "/.klamav/quarantine";
    QuarantineLocation->setURL(quarantinepath);

    preview->setPixmap( QPixmap(locate("data", "klamav/about/klam.png")) );


//     picture1->setPixmap( getJPG( "amarok_rocks" ) );
//     picture4->setPixmap( *picture1->pixmap() );

    ClamBanner->setText(QString("<a href=\"http://ads.clamav.net/adclick.php?n=a9141dd1\" target=\"_blank\"><img src=\"%1\" border=\"0\" alt=\"ClamAV banner\" /></a>").arg(locate("data", "klamav/about/tshirt.png")));


    setFinishEnabled ( WizardPage_1,		       true );

}

void
FirstRunWizard::showPage( QWidget *w ) //virtual
{
    QWizard::showPage( w );



    cancelButton()->setText( w == WizardPage ? i18n("&Skip") : i18n("&Cancel") );
}


// void
// FirstRunWizard::destroy()
// {
// 
// 
//     KConfig* config = klamav->KGlobal::config();
//     config->setGroup("Freshklam");
// 
//     //Configure Database Path
//     QStringList lastDownloadPaths;
//     if (DatabaseLocation->url() != "")
//         lastDownloadPaths.prepend( QString("%1").arg(DatabaseLocation->url()));
//     else
//         lastDownloadPaths.prepend( QString("%1").arg(databasepath));
//     config->writeEntry("lastDownloadPaths", lastDownloadPaths);
//     config->sync();
// 
//     //Configure Quarantine Path
//     QStringList lastQuarLocations;
// 
//     config->setGroup("Kuarantine");
// 
//     if (QuarantineLocation->url() != "")
//         lastQuarLocations.prepend( QString("%1").arg(QuarantineLocation->url()));
//     else
//         lastQuarLocations.prepend( QString("%1").arg(quarantinepath));
//     config->writeEntry("KuarantineLocations", lastQuarLocations);
//     config->sync();
// 
//     //Download an updated database?
//     if (CheckForDatabaseUpdates->isChecked())
//         kmain->firstDownload = true;
// }

KURL
FirstRunWizard::databasePath( ) //virtual
{
    return DatabaseLocation->url();
}

KURL
FirstRunWizard::quarantinePath( ) //virtual
{
    return QuarantineLocation->url();
}

QString
FirstRunWizard::defaultDatabasePath( ) //virtual
{
    return databasepath;
}

QString
FirstRunWizard::defaultQuarantinePath( ) //virtual
{
    return quarantinepath;
}


bool
FirstRunWizard::downloadDatabase( ) //virtual
{
    if (CheckForDatabaseUpdates->isChecked())
        return true;
    return false;
}

bool
FirstRunWizard::downloadClamAV( ) //virtual
{
    if (CheckForClamAVUpdates->isChecked())
        return true;
    return false;
}


