/*****************************************************************************/
/*  Klavaro - a flexible touch typing tutor                                  */
/*  Copyright (C) 2005, 2006, 2007, 2008 Felipe Castro                       */
/*  Copyright (C) 2009 Free Software Foundation                              */
/*                                                                           */
/*  This program is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/

#include <glib.h>

#define ACCUR_LOG_FILE "accuracy.log"
#define MAX_CHARS_EVALUATED 50
#define ERROR_INERTIA 60
#define ERROR_LIMIT 200
#define UTF8_BUFFER 7

void accur_init (void);
void accur_reset (void);
gint accur_n_get (void);
gchar * accur_char_utf8 (gint i);
gulong accur_wrong_get (gint i);
void accur_correct (gunichar uchr);
void accur_wrong (gunichar uchr);
gulong accur_error_total (void);
void accur_sort (void);
gboolean accur_create_word (gunichar *word);
void accur_close (void);
