/***************************************************************************
                          abprocess.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "abprocess.h"
#include <qdatetime.h>

#include <kmessagebox.h>
#include "info.h"

ABProcess::ABProcess(bool se){
	showerror = se;
 	connect(this, SIGNAL(receivedStdout(KProcess *,char *, int))
		,SLOT(slotReceivedStdout(KProcess *,char *,int )));
	connect(this, SIGNAL(receivedStderr(KProcess *,char *, int))
		,SLOT(slotReceivedStderr(KProcess *,char *,int )));
  connect(this, SIGNAL(processExited(KProcess *))
		,SLOT(slotProcessExited()));
	output = new QStrList();
	output -> setAutoDelete(true);

	init();
}

ABProcess::~ABProcess(){
}

void ABProcess::init(){
	std_out = "";
	std_err = "";
	output -> clear();
}

void ABProcess::exec(bool block){
	init();
	file.setName(dataDir() + "log");
	file.open(IO_WriteOnly | IO_Append);
	log.setDevice( &file );

	QDateTime t;
	t = t.currentDateTime();
	log << t.toString() << "  ";
	for (unsigned int i = 0; i < arguments.count(); i++)
		log << arguments.at(i) << " ";
	log << "\n";
	if (block)
		start(KProcess::Block,KProcess::AllOutput);
	else
		start(KProcess::NotifyOnExit,KProcess::AllOutput);
}



void ABProcess::slotReceivedStdout(KProcess *,char * b, int l){
  char * nb = new char[l+1];
  for (int i = 0; i <= l - 1; i++)
      nb[i] = b[i];
  nb[l] = '\0';

  std_out.append(nb);
	delete nb;
  uint i = 1;
  while (i <= std_out.length())	{
		if (std_out.mid(i,1) == "\n"){
	 		output -> append(std_out.left(i));
			std_out = std_out.right( std_out.length() - i - 1);
			i = 0;
		}
		i++;
  }	
	emit receivedOutput(output -> count(),output -> current());
}

void ABProcess::slotReceivedStderr(KProcess *,char * b, int l){
  char * nb = new char[l+1];
  for (int i = 0; i <= l - 1; i++)
      nb[i] = b[i];
  nb[l] = '\0';
	std_err.append(nb);
}

QString ABProcess::errorText(){
	return std_err;
}

bool ABProcess::error(){
	if (std_err.isEmpty())
		return false;
	else
		return true;
}


void ABProcess::slotProcessExited(){
	if (error()){
		log << "Error: ";
		log << std_err;
		log << "\n";
	if (showerror)
			KMessageBox::error(0,std_err);
	}
}

