/***************************************************************************
                          configuredialog.cpp  -  description
                             -------------------
    begin                : Thu Jan 18 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuredialog.h"
#include <stdlib.h>
#include <iostream.h>

#include <qcheckbox.h>
#include <qlineedit.h>
#include "qfileinfo.h"

#include <kstddirs.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>

#include "abprocess.h"
#include "kleandisk.h"

#include "udg.h"

ConfigureDialog::ConfigureDialog():ConfigureBase(0,0,true){
	slotInstallPathChanged();
  KConfig * config = KGlobal::config();
  config -> setGroup("INS");
	LineEdit1 -> setText(config -> readEntry("python Folder"));
	slotInstallPathChanged();

  config -> setGroup("UDG");
	QStrList list;
	config -> readListEntry("Update Folders",list);
 	ListBox1 -> insertStrList(&list);
 	CheckBox2 -> setChecked(config -> readBoolEntry("Automatic Update"));

  config -> setGroup("DUP");
 	LineEdit3 -> setText(config -> readEntry("Update Folder"));

  config -> setGroup("Archive");
	LineEdit4 -> setText(config -> readEntry("Folder"));
}

ConfigureDialog::~ConfigureDialog(){
}

void ConfigureDialog::accept(){
	if (CheckBox1 -> isChecked()){
		if (!wrapped()){
			Batch b;
			ABProcess * p = new ABProcess();
			*p << "mv" << "-f" << fileName1() << fileName2();
			b.append(p);

			p = new ABProcess();
			*p << "cp" << "-f" << KGlobal::dirs() -> findResource("data","kleandisk/install.kleandisk") << fileName1();
			b.append(p);

			p = new ABProcess();
			*p << "chmod" << "a+x" << fileName1();
			b.append(p);
			
			b.start(true);
		}
	}

	if (!CheckBox1 -> isChecked()){
		if (wrapped()){
			ABProcess p;
			p <<"mv" << fileName2() << fileName1();
			p.exec(true);
		}
	}
	
	//save UDG Settings
  KConfig * config = KGlobal::config();
  config -> setGroup("UDG");

	QStrList list;
	for (int i = 0; i < ListBox1 -> numRows(); i++)
		list.append(ListBox1 -> text(i));
 	config -> writeEntry("Update Folders",list);
 	config -> writeEntry("Automatic Update",CheckBox2 -> isChecked());

  config -> setGroup("Archive");
 	config -> writeEntry("Folder",LineEdit4 -> text());
 	
  config -> setGroup("DUP");
 	config -> writeEntry("Update Folder",LineEdit3 -> text());
  	
 	setResult(0);
	hide();
}

void ConfigureDialog::reject(){
	setResult(1);
	hide();
}

QString ConfigureDialog::fileName1(){
	QString fn = LineEdit1 -> text();
	return fn;
}

QString ConfigureDialog::fileName2(){
	QString fn = fileName1() + ".kd";
	return fn;
}

bool ConfigureDialog::wrapped(){
	bool b = false;
	QFileInfo fi(fileName2());
	if (fi.exists())
		b = true;
	return b;
}
void ConfigureDialog::slotGuessInstallPath(){
	KProcess * p = new KProcess();
	connect(p, SIGNAL(receivedStdout(KProcess *,char *, int))	,SLOT(slotWhichOutput(KProcess *,char *,int )));
	p -> clearArguments();
	*p << "which";
	*p << "install";
	p -> start(KProcess::Block,KProcess::AllOutput);
	delete p;
}

void ConfigureDialog::slotWhichOutput(KProcess *, char * b, int l){
	b[l-1] = '\0';
	LineEdit1 -> setText(b);
}

void ConfigureDialog::slotInstallPathChanged(){
	QString fn1 = LineEdit1 -> text();
	QFileInfo fi(fn1);
	if (fi.exists() & !fi.isDir())
		CheckBox1 -> setEnabled(true);
	else
		CheckBox1 -> setEnabled(false);
	CheckBox1 -> setChecked(wrapped());
}

void ConfigureDialog::slotBrowse(){
	ListBox1 -> insertItem(KFileDialog::getExistingDirectory(getenv("HOME")),-1);
}

void ConfigureDialog::slotBrowse2(){
	LineEdit3 -> setText(KFileDialog::getExistingDirectory(LineEdit3 -> text()));
}

void ConfigureDialog::slotBrowse3(){
	LineEdit4 -> setText(KFileDialog::getExistingDirectory(LineEdit4 -> text()));
}

void ConfigureDialog::slotDeletePath(){
	ListBox1 -> removeItem(ListBox1 -> currentItem());
}
