/***************************************************************************
                          info.cpp  -  description
                             -------------------
    begin                : Tue Dec 21 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "info.h"
#include <qfileinfo.h>
#include <qdir.h>
#include <qstringlist.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <iostream.h>
#include "udg.h"

QString newFileName(QString name){
	bool ended = false;
	unsigned int num = 0;
	QString numstr,s;
	while (!ended){
		numstr.setNum(num);
		s = name + numstr;
		QFileInfo fi(s);
		if (fi.exists())
			num++;
		else
			ended = true;
	}
	return s;
}

QString newInsBaseFileName(){
	bool ended = false;
	unsigned int num = 0;
	QString numstr,s;
	while (!ended){
		numstr.setNum(num);
		s = insDir() + "install" + numstr;
		QFileInfo fi(s + ".files");
		if (fi.exists())
			num++;
		else
			ended = true;
	}
	return s;
}

QString dataDir(){
	KStandardDirs * d;
	d = KGlobal::dirs();
	QStringList list = d -> findDirs("data","");
	QString s;
  for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ){
		s = *it + appName + "/";
		if (s.find(getenv("HOME")) == 0)
			break;
	}
	return s;
} 	

QString defaultArchiveDir(){
	QString s = dataDir();
	s += "archive/";
	return s;
}

QString archiveDir(){
  KConfig * config = KGlobal::config();
  config -> setGroup("Archive");
	return config -> readEntry("Folder");
}

QString udgDir(){
	QString s = dataDir();
	s += "udg/";
	return s;
}

QString tgzDir(){
	QString s = dataDir();
	s += "tgz/";
	return s;
}
	
QString insDir(){
	QString s = dataDir();
	s += "install/";
	return s;
}
QString getUDGBaseFileName(QString n){
	QDir d(udgDir());
	QString r; // return value
	QStringList * l = new QStringList(d.entryList()); // dir list
//	QString b; // containing block after loading
	for (unsigned int i = 0; i < l -> count(); i++){
		QFileInfo f(udgDir() + *l -> at(i));
		QString s(f.fileName());
		if (s.right(7) == ".config"){
			QString bn(f.baseName());
			UDG * u = new UDG(bn);
			u -> loadConfig();
			if (u -> name() == n){
				r = bn;
				break;
			}
			delete u;
		}
	}
	delete l;
	return r;
}
