/***************************************************************************
                          rpmtree.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RPMTREE_H
#define RPMTREE_H

#include <qlistview.h>
#include <qtimer.h>
#include <qobject.h>
#include "grouptree.h"
#include "rpm.h"

/**
  *@author Arjan Buursink
  */

class RPMTree : public GroupTree  {
	Q_OBJECT
public:
	RPMTree(GroupViewWidget *);
	~RPMTree();
	unsigned int rpmSafetyLevel(){return _rpmSafetyLevel;};
	void setRPMSafetyLevel(unsigned int i){_rpmSafetyLevel = i;};
private:
	void groupToItem(FileGroupBase *, QListViewItem *);
	void updateReady();
	void itemClicked(QListViewItem *, const QPoint &, int);
	unsigned int counter;
	void setup();
	unsigned int _rpmSafetyLevel;
	QTimer * timer;
	RPM * _rpm;
	ButtonLabelWidget2 * updateProgress;
private slots:
	void slotRPM();
	void slotCancel();
	void slotRPMQueryEnded();
};

#endif
