/***************************************************************************
                          settingsdialog.h  -  description
                             -------------------
    begin                : Sun Feb 17 2002
    copyright            : (C) 2002 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

/**
  *@author Olaf Lueg
  */

class BaseSetting;
class AlertSetting;
class BlockedSetting;
class KMsnApp;
class Account;

class SettingsDialog : public KDialogBase  {
   Q_OBJECT
public: 
	SettingsDialog(QWidget *parent=0, const char *name=0);
	~SettingsDialog();
	KMsnApp *theApp;

	void init(KMsnApp* thisApp);
private:
	BaseSetting *baseSetting;
	AlertSetting *alertSetting;
	BlockedSetting *blockedSetting;
	
	QList <Account>accountList;
	
	void readConfig();
	void saveConfig();
	
private slots:
	void slotOk();
	void slotCancel();
	void slotAddAccount();
	void slotEditAccount();
	void slotRemoveAccount();
	void slotAllowContact();


signals:
	void changePublicName(QString);
	void closed();
};



class Account : public QObject {
Q_OBJECT
public:
	Account(){}
	~Account(){}
	QString handle;
	QString password;
	QString name;
};
#endif