#!/bin/sh

cd `dirname $0`/..

# second sed expression fixes Mac OS X 10.4
appver="`egrep 'SET.*KMESS_VERSION' CMakeLists.txt | sed -e 's/.*"\([^"]*\)".*/\1/'`"
date="`date +%Y%m%d`"

# Make sure we have the right repository
if [ ! -f kmess.kdevelop ]; then
  /bin/echo -n "svn (unknown)"
  exit
fi

# Display normal version if subversion is not installed
if [ ! -x `which svnversion 2>/dev/null` ]; then
  /bin/echo -n "$appver"
  exit
fi

# Display subversion version if this is a working copy
svnver=`LANG=C svnversion`

# see if this is not a repository.
if [ "$svnver" = "exported" ]; then
  if [ -z "$KMESS_VER" ]; then
    /bin/echo -n "$appver";
  else
    /bin/echo -n "$KMESS_VER";
  fi
  exit;
fi

# display subversion version and date
/bin/echo -n "$appver-svn (`svnversion` >= $date)"
