/***************************************************************************
                          kmessview.h  -  description
                             -------------------
    begin                : Thu Jan 9 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSVIEW_H
#define KMESSVIEW_H

#include "model/contactlistmodelitem.h"
#include "ui_kmessview.h"

#include <QPixmap>
#include <QTimer>
#include <QToolTip>
#include <QWidget>


// Forward declarations
class CurrentAccount;
class Contact;
class ContactListModelFilter;
class Group;
class KMessView;

class QItemSelectionModel;
class QSignalMapper;
class QToolTip;

class KAction;
class KActionMenu;
class KMenu;



/**
 * @brief The main view area, displaying the user status area and contact list.
 *
 * This class implements the actions of the inherited user interface class.
 * It contains the contact list view, user status and email displays.
 * The KMessViewInterface class is automatically generated from it's <code>.ui</code> file.
 *
 * @author Mike K. Bennett
 * @ingroup Root
 */
class KMessView : public QWidget, private Ui::KMessView
{
  Q_OBJECT

  friend class KMessTest;

  public:
    // The constructor
                     KMessView( QWidget *parent=0 );
    // The destructor
    virtual         ~KMessView();
    // The currently playing song was changed.
    void             changedSong( const QString &artist, const QString &album, const QString &track, bool playing );
    // Initialize the class
    bool             initialize( QAbstractItemModel *viewModel );
    // The "show history box" menu item has been toggled.
    void             toggleShowHistoryBox( bool show );
    // The "show search in contact list" menu item has been toggled.
    void             toggleShowSearchFrame( bool show );

  protected:
    // The personal status message received an event.
    bool             eventFilter(QObject *obj, QEvent *ev);

  private: // Private methods
    // Get the specified item's or the current item's data
    const ModelDataList getItemData( const QModelIndex &index = QModelIndex() );
    // Initialize the contact list view
    bool                initContactListView( QAbstractItemModel *viewModel );
    // Initialize the contact popup
    bool                initContactPopup();
    // Initialize the group popup
    bool                initGroupPopup();

  public slots: // Public slots
    // Show the context menu
    void             showContextMenu( const QPoint &point );

  private slots: // Private slots
    // Called when a contact is now online/offline
    void             slotContactChangedStatus( Contact *contact, bool showNotify );
    // Show the contact & group tool tip
    void             showToolTip( const QPoint &point );
    // The connection was closed, clean up before deletion
    void             slotDisconnected();
    // Send an email to the current contact.
    void             slotEmailContact();
    // The email label was clicked so open the user's preferred email url
    void             slotEmailLabelClicked();
    // A group was expanded or collapsed
    void             slotGroupChanged( const QModelIndex &index );
    // An item was clicked
    void             slotItemClicked( const QModelIndex &index, const bool accidental = false );
    // An item was single clicked
    void             slotItemSingleClicked( const QModelIndex &index );
    // An item was double clicked
    void             slotItemDoubleClicked( const QModelIndex &index );
    // Forward the "add contact" menu action
    void             slotForwardAddContact();
    // Forward the "allow contact" menu action
    void             slotForwardAllowContact();
    // Forward the "block contact" menu action
    void             slotForwardBlockContact();
    // Called when a contact should be copied
    void             slotForwardCopyContact( const QString &groupId );
    // Called when a contact should be moved
    void             slotForwardMoveContact( const QString &groupId );
    // Forward the "remove contact" menu action
    void             slotForwardRemoveContact();
    // Forward the "remove group" menu action
    void             slotForwardRemoveGroup();
    // Forward the "remove contact from group" action
    void             slotForwardRemoveFromGroup();
    // Forward the "rename group" menu action
    void             slotForwardRenameGroup();
    // Forward the "start chat" menu action
    void             slotForwardStartChat();
    // Forward the "unblock contact" menu action
    void             slotForwardUnblockContact();
    // Move down the selected group
    void             slotMoveGroupDown();
    // Move up the selected group
    void             slotMoveGroupUp();
    // Update the friendly name from the inline editing label
    void             updateFriendlyName( bool refreshOnly = false );
    // Update the personal message from the inline editing label
    void             updatePersonalMessage( bool refreshOnly = false );
    // Generate the lists of actions for the "copy/move contact to group" menus
    void             rebuildContactActions();
    // Delay a bit updating the groups status
    void             slotScheduleGroupUpdate();
    // Slot for searching contact
    void             slotSearchContact( const QString& searchFor );
    // Display the chat history of the current contact
    void             slotShowChatHistory();
    // Display the profile of the current contact
    void             slotShowContactProfile();
    // Display the properties of the current contact
    void             slotShowContactProperties();
    // Update the users display pic
    void             slotUpdateDisplayPicture();
    // Change whether the email label is displayed based on account settings.
    void             slotUpdateEmailDisplay();
    // Update the expanded status of the list groups
    void             slotUpdateGroups();
    // Update the email count.
    void             slotUpdateNoEmails();
    // Update the user's status.
    void             slotUpdateUserStatus();
    // Update the contact list widgets
    void             slotUpdateView();
    // Copy some details of the contact to the clipboard
    void             copyText();

  private: // Private attributes
    // KActions used in the contact popup menu
    KAction         *addContact_;
    KAction         *allowContact_;
    KAction         *blockContact_;
    KAction         *unblockContact_;
    KAction         *chatWithContact_;
    KAction         *msnProfile_;
    KAction         *chatHistory_;
    KAction         *removeContact_;
    KAction         *removeFromGroup_;
    KAction         *emailContact_;
    KAction         *contactProperties_;
    // KActions uses in the group popup menu
    KAction         *moveGroupDown_;
    KAction         *moveGroupUp_;
    KAction         *removeGroup_;
    KAction         *renameGroup_;
    // KAction uses in the copy popup menu
    KActionMenu     *popupCopyMenu_;
    KAction         *popupCopyFriendlyName_;
    KAction         *popupCopyPersonalMessage_;
    KAction         *popupCopyHandle_;
    KAction         *popupCopyMusic_;
    QList<KAction*>  groupCopyLinkActionsList_;
    // The menu of actions possible to perform on a given contact
    KMenu      *contactActionPopup_;
    // The menu of actions possible to perform on a given group
    KMenu      *groupActionPopup_;
    // KSelectActions used in the contact popup menu
    KActionMenu     *moveContactToGroup_;
    KActionMenu     *copyContactToGroup_;
    // Signal mapper needed to identify the single copy actions
    QSignalMapper   *contactCopyMapper_;
    // Signal mapper needed to identify the single move actions
    QSignalMapper   *contactMoveMapper_;
    // A pointer to the instance of the current account
    CurrentAccount  *currentAccount_;
    // List of groups between which the user can copy contacts
    QList<KAction*>  groupCopyActionsList_;
    // List of groups between which the user can move contacts
    QList<KAction*>  groupMoveActionsList_;
    // Whether or not the object has been initialized
    bool             initialized_;
    // The background pixmap
    QPixmap          backgroundPixmap_;
    // Selection model used to access selected items in the list
    QItemSelectionModel *selectionModel_;
    // Timed used to posticipate update events
    QTimer           updateTimer_;
    // Quick ref to the tree view's filter model
    ContactListModelFilter *viewModel_;

  signals:
    // Request to add a contact
    void             addContact(QString handle);
    // Request to allow a contact
    void             allowContact(QString handle);
    // Request to block a contact
    void             blockContact(QString handle);
    // Request to change the friendly name
    void             changeFriendlyName( QString friendlyName );
    // Request to change the personal message.
    void             changePersonalMessage(QString personalMessage);
    // Request a private chat with a contact
    void             requestChat( QString handle );
    // Show the settings of the current account.
    void             showSettings();
    // Request to copy a contact
    void             copyContact(QString handle, QString groupId);
    // Request to move a contact
    void             moveContact(QString handle, QString fromGroupId, QString toGroupId);
    // Request to remove a contact
    void             removeContact(QString handle);
    // Request to remove a contact from a single group
    void             removeContactFromGroup(QString handle, QString groupId);
    // Request to remove a group.
    void             removeGroup(QString groupId);
    // Request to rename a group.
    void             renameGroup(QString groupId);
    // Notify about a change in the selection within the contact list view
    void             selectionChanged( const QItemSelection &selection );
    // Request to unblock a contact.
    void             unblockContact(QString handle);
};

#endif
