/* -*- c++ -*-
 *
 * preview.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_preview_h__
#define __kmldonkey_preview_h__

#include <qwidget.h>
#include <qstring.h>
#include <kurl.h>
#include <kparts/part.h>
#include <kxmlguibuilder.h>

class QBoxLayout;
class QLabel;
class KXMLGUIFactory;
class QHBox;

class KDE_EXPORT PreviewWidget : public QWidget, public KXMLGUIBuilder
{
    Q_OBJECT
public:

    PreviewWidget(const KURL& url, const QString& realName, QWidget* parent = 0, const char* name = 0);
    ~PreviewWidget();

public slots:

    void loadPlayer();

protected:

    void showEvent(QShowEvent* event);

private:

    KURL m_url;
    QString m_name;
    QBoxLayout* layout;
    QHBox* toolbarContainer;
    KParts::ReadOnlyPart* part;
    QLabel *na, *loading;
    KXMLGUIFactory* fac;

};

#endif // __kmldonkey_preview_h__
