/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "device.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h> 
#include <unistd.h> 
#include <string.h>
#include <iostream>
#include <kdebug.h>

#include <qstring.h> 
#include <qregexp.h> 

#include "c_config.h"

extern c_config* Config;

using namespace std;

Device::Device(const char* path)
 : QObject(NULL, path)
{
	locked=false;
	modem=-1;
	modem = open( path, O_RDWR | O_NOCTTY | O_NONBLOCK );
	setupModem();
	sendCommand("\x1A\r",5);
	sendCommand(Config->getInitString(),5);
 if ( Config->getInitString_2().length() >0 ) sendCommand(Config->getInitString_2(),5);
	sendCommand("AT+CMEE=1\r",5);
	sendCommand("AT+CMEE=2\r",5);
// #ifdef KMT_USE_PDU
	kdDebug() << "Testing PDU mode..." << endl;
	if ( sendCommand("AT+CMGF=0\r", 60) ) pdu=false; else pdu=true;
// #endif
// 	sendCommand("AT+CMGF=1\r",5);
	sendCommand( QString( "AT+CSCS=\"" + Config->getEncoding() + "\"\r").latin1(), 5);
	if( Config->getSMSMode2() ) sendCommand( "AT+MODE=2\r", 40 );
// 	else sendCommand( "AT+MODE=0\r", 40 );
/*	if(strlen(buffer)>0) 
		cout << "Device created: " << path << "; " << modem << endl;
		else 
		{
			cout << "Device error for " << path << "; modem handle=" << modem << endl; 
			perror (NULL);
// 			modem=0;
		}
		*/
}


Device::~Device()
{
	if ( close(modem)==0 )
		kdDebug() << "Device closed correctly\n";
	else kdDebug() << "Forcing device to close\n";
}

#include "device.moc"

void Device::setupModem()
{
  struct termios newtio;
   #define baudrate B115200
//	#define baudrate B230400
  #define rtscts 1
  bzero(&newtio, sizeof(newtio));
  newtio.c_cflag = CRTSCTS | CS8 | CLOCAL | CREAD | O_NDELAY;
  cfsetispeed(&newtio,Config->getBaudRate() );
  cfsetospeed(&newtio,Config->getBaudRate() );
//   cout << "Speed: " << cfgetispeed( &newtio ) << ", " << cfgetospeed( &newtio ) << endl;
  if (! rtscts)
  newtio.c_cflag &= ~CRTSCTS;
  newtio.c_iflag = IGNPAR;
  newtio.c_oflag = 0;
  newtio.c_lflag = 0;
  newtio.c_cc[VTIME]    = 1;
  newtio.c_cc[VMIN]     = 0;
  tcflush(modem, TCIOFLUSH);
  tcsetattr(modem,TCSANOW,&newtio);
}



int Device::sendCommand(const char* cmd, int timeout)
{
// Return values: -x = device error; 0 = OK answer; >0: ERROR answer
	QRegExp find_err;
	if(modem==-1) return -1;
	mutex.lock();
	unsigned int toread=0;
//	int status=0;
	int timeoutcnt=0;
	char temp[256];
	if ( Config->isVerbose() ) 
		cout << ">>>" << cmd << endl;
	memset(buffer,0,sizeof(buffer));
	
	for(unsigned int i=0;i<strlen(cmd);i+=30) 
	// it seems that sending more than 32 bytes without a tcdrain can hung the connection, so we're dividing the command string.
	{
		if(i>=strlen(cmd)) break;
		memset(temp,0,sizeof(temp));
		if(strlen(&cmd[i])>=30) { strncpy(temp,&cmd[i],30); } else { strncpy(temp,&cmd[i],strlen(&cmd[i])); }
		write(modem,temp,strlen(temp)); // write commands to the modem
		tcdrain(modem);

	}
	// We've sent the command, now wait for an answer
	timeoutcnt=0;
	usleep(100000);
	int cycles=0;
	char* buffer_p=buffer;
	for(timeoutcnt=0;timeoutcnt<timeout;timeoutcnt++) // Now let's get the answer
	{
// 		for(int i=0;i<sizeof(temp);i++) temp[i]='\0';
 		memset(temp,0,sizeof(temp));
		toread=0;
		if( ioctl(modem,FIONREAD,&toread)== -1) perror(NULL);
		if(toread<1)
		{
			usleep(100000);
//			if( ioctl(modem,FIONREAD,&toread)== -1) perror(NULL);
//			cout << toread << ", " << timeoutcnt << endl;
			if (strlen(buffer)>0) cycles++; 
		} else
		{
			if( toread >= sizeof(temp) ) 
				toread=sizeof(temp)-1;
//			cout << toread << endl;
			if(read(modem,temp,toread)) 
				buffer_p = (char*) mempcpy(buffer_p,temp, toread);
// 			cout << answer << endl;
			cycles=0;

		}
		if(strstr(buffer,"\nOK\r")!=NULL) break;
		find_err.setPattern("\\+\\w* ERROR:");
		if( strstr(buffer,"\nERROR\r")!=NULL || find_err.search(buffer)!=-1 )
		{
			if ( Config->isVerbose() ) 
				cout << "<<<" << buffer << "(returning error)" << endl;
			mutex.unlock();
			return 2;
		};
	} 
	if ( Config->isVerbose() ) 
		cout << "<<<" << buffer << endl;
	mutex.unlock();
	if(strstr(buffer, "\nOK\r")!=NULL) return 0;
	return 1;

}


/*!
    \fn Device::sendChar(char c)
 */
int Device::sendChar(unsigned char c)
{
// Return values: -x = device error; 0 = OK answer; >0: ERROR answer
	if(modem==-1) return -1;
	mutex.lock();
	if ( Config->isVerbose() ) 
	{
// 		if(c!='\r') cout << c << "[" << (int) c << "]"; else cout << "[" << (int) c << "]\n";
		if(c!='\r') cout << c ; else cout <<"\n";
	}
	int s;
	do {
		s = write(modem,&c,1); // write commands to the modem
		if(s<0) {
			mutex.unlock();
			kdError() << "write() in Device::sendChar failed" << endl;
			return s;
		}
	} while(s == 0);
// 	tcdrain(modem);
	mutex.unlock();
	return 1;
}


/*!
    \fn Device::getDevBuffer()
 */
char* Device::getDevBuffer()
{
	mutex.lock();
	char* buffer=new char[2048*2048];
	memset(buffer,0,2048*2048);

	read(modem,buffer,2048*2048);

	mutex.unlock();
	return buffer;
}
