//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfaceicmp.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>

// Project includes
#include "../core/kmfgenericdoc.h"


KMFGenericInterfaceIcmp::KMFGenericInterfaceIcmp( QWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceIcmp( parent, name, f ) {
connect( c_allow_ping, SIGNAL( toggled( bool ) ),
	this, SLOT( slotEnablePingReplyToggled( bool ) ) );
connect( c_limit_ping, SIGNAL( toggled( bool ) ),
	this, SLOT( slotEnablePingReplyLimitToggled( bool ) ) );
}


KMFGenericInterfaceIcmp::~KMFGenericInterfaceIcmp() {}

/*!
    \fn KMFGenericInterfaceIcmp::slotUpdateView()
 */
void KMFGenericInterfaceIcmp::slotUpdateView() {
	c_allow_ping->setChecked( m_doc->allowPingReply() );
	c_limit_ping->setChecked( m_doc->limitPingReply() );

}
void KMFGenericInterfaceIcmp::loadDoc( KMFGenericDoc* doc ) {
	kdDebug() << "void KMFGenericInterfaceIcmp::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}

void KMFGenericInterfaceIcmp::slotEnablePingReplyToggled( bool onoff ) {
	kdDebug() << "KMFGenericInterfaceIcmp::slotEnablePingReplyToggled( bool onoff )" << endl;
	if ( onoff ) {
		m_doc->setAllowPingReply( onoff );
		if ( c_limit_ping->isChecked() ) {
			m_doc->setLimitPingReply( onoff );
		}
	} else {
		m_doc->setAllowPingReply( onoff );
	}
}
void KMFGenericInterfaceIcmp::slotEnablePingReplyLimitToggled( bool onoff ) {
	kdDebug() << "KMFGenericInterfaceIcmp::slotEnablePingReplyLimitToggled( bool onoff )" << endl;
	m_doc->setLimitPingReply( onoff );
}



#include "kmfgenericinterfaceicmp.moc"
