//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfacelogging.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qtimer.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <krestrictedline.h>

// Project includes
#include "../core/kmfgenericdoc.h"

KMFGenericInterfaceLogging::KMFGenericInterfaceLogging( QWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceLogging( parent, name, f ) {
	connect( m_c_log, SIGNAL( toggled( bool ) ),
		this,SLOT( slotLoggingChanged( bool ) ) );

	connect( m_c_limitLog, SIGNAL( toggled( bool ) ),
		this,SLOT( slotLimitChanged( bool ) ) );

	timer = new QTimer( this );
	connect( timer, SIGNAL( timeout() ),
		this, SLOT( slotTimerShot() ) );
}


KMFGenericInterfaceLogging::~KMFGenericInterfaceLogging() {}

/*!
    \fn KMFGenericInterfaceLogging::slotUpdateView()
 */
void KMFGenericInterfaceLogging::slotUpdateView() {
	m_c_log->setChecked( m_doc->logDropped() );
	m_c_limitLog->setChecked( m_doc->limitLog() );
	m_le_logPrefix->setText( m_doc->logPrefix() );
}

/*!
    \fn KMFGenericInterfaceLogging::loadDoc( KMFGenricDoc* )
 */
void KMFGenericInterfaceLogging::loadDoc( KMFGenericDoc* doc ) {
	kdDebug() << "void KMFGenericInterfaceLogging::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	timer->start( 2000, FALSE );
	slotUpdateView();
}

void KMFGenericInterfaceLogging::slotLoggingChanged( bool onoff ) {
	m_doc->setLogDropped( onoff );
}

void KMFGenericInterfaceLogging::slotLimitChanged( bool onoff ) {
	m_doc->setLimitLog( onoff );
}

void KMFGenericInterfaceLogging::slotTimerShot() {
// 	kdDebug() << "KMFGenericInterfaceLogging::slotTimerShot()" << endl;
	if ( m_doc->logPrefix() != m_le_logPrefix->text() ) {
		kdDebug() << "Updating Log Prefix to: " << m_le_logPrefix->text() << endl;
		m_doc->setLogPrefix( m_le_logPrefix->text() );
	}
}


#include "kmfgenericinterfacelogging.moc"
