/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditlimit.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../interfaces/kmfruleeditinterface.h"
#include "kmfruleeditorlimit.h"


KMFRuleOptionEditLimit::KMFRuleOptionEditLimit(QObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditLimit::KMFRuleOptionEditLimit(QObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorLimit( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigAddRuleOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddRuleOption(QString*, QPtrList< QString >* ) ) );
	connect( m_edit,SIGNAL(sigAddTargetOpt(QString*, QPtrList< QString >* ) ), 
		this,SLOT( slotAddTargetOption(QString*, QPtrList< QString >* ) ) );
	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditLimit::~KMFRuleOptionEditLimit() {}


void KMFRuleOptionEditLimit::slotAddRuleOption(QString* name, QPtrList< QString >* values ) {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->addRuleOption( name, values );
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotAddRuleOption(): parent() not of type KMFRuleEditInterface" << endl;
	}
}
void KMFRuleOptionEditLimit::slotAddTargetOption(QString* name, QPtrList< QString >* values ) {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->addRuleTargetOption( name, values );
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotAddTargetOption(): parent() not of type KMFRuleEditInterface" << endl;
	}
}
void KMFRuleOptionEditLimit::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}







const QString& KMFRuleOptionEditLimit::optionEditName() const {
	return *( new QString( i18n("Limit Option") ) );
}
const QString& KMFRuleOptionEditLimit::description() const {
	return *( new QString( i18n("This plugin manages the Limit options of iptables.") ) );
}

void KMFRuleOptionEditLimit::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditLimit::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleOptionEditLimit::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditLimit::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditLimitFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditLimitFactory::s_about = 0L;

KMFRuleOptionEditLimitFactory::KMFRuleOptionEditLimitFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditLimitFactory" );
}

QObject* KMFRuleOptionEditLimitFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleOptionEditLimit( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditLimitFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditLimitFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_limit() {
		return new KMFRuleOptionEditLimitFactory;
	}
}




#include "kmfruleoptioneditlimit.moc"
