//
// C++ Interface: $MODULE$
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFPROTOCOL_H
#define KMFPROTOCOL_H

#include "netfilterobject.h"

// QT includes
#include <qstringlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qptrlist.h>
#include <qvaluelist.h>
#include <qmap.h>

// KDE includes
#include <kdemacros.h>
#include <kurl.h>

// Project includes
#include "kmfprotocolcategory.h"

/**
@author Christian Hubinger
*/

namespace KMF {
class KMFGenericDoc;
class KMFNetZone;
class KMFError;
class KMFProtocolCategory;
class KMFProtocolUsage;

class KDE_EXPORT KMFProtocol : public NetfilterObject {
	friend class KMFProtocolCategory;
	
public:
   
    ~KMFProtocol();
	virtual int type();
	virtual void clear();

	void addPort( const QString& , int );
	void delPort( const QString&, int );
	void setCustomProtocol( bool );
	void setCategory( KMFProtocolCategory* );
	
	virtual const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );
	
	bool customProtocol() const {
		return m_customProtocol;
	};
	
	KMFProtocolCategory* category() const {
		return m_category;
	}
	
	QValueList<int>&  udpPorts() {
		return m_udpPorts;
	}

	QValueList<int>&  tcpPorts() {
		return m_tcpPorts;
	}

	
	const QString& udpPortsList();
	const QString& tcpPortsList();
	
	bool replaceTCPPort( int oldPort, int newPort );
	bool replaceUDPPort( int oldPort, int newPort );

	bool isEquivalent( KMFProtocol *other );

	enum { TCP, UDP /*, ICMP */ } Protocol;
	
	KMFProtocolUsage *createUsage();
	
private:	
	 KMFProtocol( KMFProtocolCategory* parent, const char* name );
	 
private:
	QValueList<KMFProtocolUsage*> m_usages;
	KMFProtocolCategory* m_category;
	QValueList<int> m_udpPorts;
	QValueList<int> m_tcpPorts;
	bool m_customProtocol;
};
}
#endif
