/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#include "kmftargetconfig.h"

// QT includes
#include <qstring.h>
#include <qdom.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "kmftarget.h"
#include "xmlnames.h"

namespace KMF {

KMFTargetConfig::KMFTargetConfig ( KMFTarget* target,  const char* name ) : NetfilterObject ( target, name ) {
	m_target = target;
	m_OS = "linux";
	m_Backend = "iptables";
}

KMFTargetConfig::~KMFTargetConfig() {}


int KMFTargetConfig::type() {
	// kdDebug() << "KMFTargetConfig::type()" << endl;
	return NetfilterObject::KMFTARGETCONFIG;
}

void KMFTargetConfig::clear() {
}

bool KMFTargetConfig::isValid() const {
	if ( 
		distribution().isEmpty() ||
		IPTPath().isEmpty() ||
		initPath().isEmpty() ||
		modprobePath().isEmpty() ||
		rcDefaultPath().isEmpty() /* ||
		interfaces().isEmpty() */
	) {
		kdDebug() << "KMFTargetConfig::isValid() " << false << endl; 
		return false;
	} else {
		kdDebug() << "KMFTargetConfig::isValid() " << true << endl; 
		return true;
	}
}

void KMFTargetConfig::setBackend ( const QString & v ) {
	if ( m_Backend == v ) {
		return;
	}
	m_Backend = v;
	changed();
}

void KMFTargetConfig::setInterfaces ( const QStringList & v ) {
	if ( m_Interfaces == v ) {
		return;
	}
	m_Interfaces = v;
	changed();
}

void KMFTargetConfig::setModprobePath ( const QString & v ) {
	if ( m_ModprobePath == v ) {
		return;
	}
	m_ModprobePath = v;
	changed();
}

void KMFTargetConfig::setIPTPath ( const QString & v ) {
	if ( m_IPTPath == v ) {
		return;
	}
	m_IPTPath = v;
	changed();
}

void KMFTargetConfig::setRcDefaultPath ( const QString & v ) {
	if ( m_RcDefaultPath == v ) {
		return;
	}
	m_RcDefaultPath = v;
	changed();
}

void KMFTargetConfig::setInitPath ( const QString & v ) {
	if ( m_InitPath == v ) {
		return;
	}
	m_InitPath = v;
	changed();
}

void KMFTargetConfig::setDistribution ( const QString & v ) {
	if ( m_Distribution == v ) {
		return;
	}
	m_Distribution = v;
	changed();
}

void KMFTargetConfig::setOS ( const QString & v ) {
	if ( m_OS == v ) {
		return;
	}
	m_OS = v;
	changed();
}

const QDomDocument& KMFTargetConfig::getDOMTree() {
	// kdDebug() << "const QDomDocument& KMFTargetConfig::getDOMTree() " << endl;
	QDomDocument doc;
	QDomElement root = doc.createElement ( XML::TargetConfig_Element );
	NetfilterObject::saveUuid( root );
	root.setAttribute ( XML::Name_Attribute, name() );
	root.setAttribute ( XML::Description_Attribute, description() );

	QStringList ints = interfaces();
	for ( QStringList::Iterator it = ints.begin(); it != ints.end(); ++it ) {
		QDomElement interface = doc.createElement ( XML::Interface_Element );
		interface.setAttribute (  XML::Name_Attribute, *it );
		root.appendChild ( interface );
	}

	QDomElement os = doc.createElement ( XML::OS_Element );
	os.setAttribute (  XML::Name_Attribute, oS().lower() );
	root.appendChild ( os );

	QDomElement el_backend = doc.createElement ( XML::BackEnd_Element );
	el_backend.setAttribute (  XML::Name_Attribute, backend().lower() );
	root.appendChild ( el_backend );

	QDomElement el_distribution = doc.createElement ( XML::Distribution_Element );
	el_distribution.setAttribute (  XML::Name_Attribute, distribution() );
	root.appendChild ( el_distribution );

	QDomElement el_initPath = doc.createElement ( XML::InitPath_Element );
	el_initPath.setAttribute (  XML::Name_Attribute, initPath() );
	root.appendChild ( el_initPath );

	QDomElement el_IPTPath = doc.createElement ( XML::IPTPath_Element );
	el_IPTPath.setAttribute (  XML::Name_Attribute, IPTPath() );
	root.appendChild ( el_IPTPath );

	QDomElement el_modprobePath = doc.createElement ( XML::ModprobePath_Element );
	el_modprobePath.setAttribute (  XML::Name_Attribute, modprobePath() );
	root.appendChild ( el_modprobePath );

	QDomElement el_rcDefaultPath = doc.createElement ( XML::RcDefaultPath_Element );
	el_rcDefaultPath.setAttribute (  XML::Name_Attribute, rcDefaultPath() );
	root.appendChild ( el_rcDefaultPath );
	doc.appendChild ( root );
	return * ( new QDomDocument ( doc ) );
}

void KMFTargetConfig::loadXML ( const QDomDocument& doc, QStringList& errors ) {
	kdDebug() << "void KMFTargetConfig::loadXML( const QDomDocument& )" << endl;
	QDomElement root = doc.documentElement();
	loadXML ( root, errors );
}

void KMFTargetConfig::loadXML ( QDomNode root, QStringList& errors ) {
	kdDebug() << "void KMFTargetConfig::loadXML( QDomNode root )" << endl;
	NetfilterObject::loadUuid ( root, errors );
	QDomDocument protocol_doc;
	protocol_doc.appendChild ( root.cloneNode ( true ) );
	kdDebug() << "XML: " << protocol_doc.toString() << endl;


	QString name = "";
	QString desc = "";

	setDescription ( root.toElement().attribute ( XML::Description_Attribute ) );
	setName ( root.toElement().attribute ( XML::Name_Attribute ) );

	m_Interfaces.clear();

	QDomNode curr = root.firstChild();
	while ( !curr.isNull() ) {
		if ( curr.isElement() ) {
			kdDebug() << "Parsing Node: " << curr.nodeName() << endl;
			if ( ( curr.nodeName() == XML::Interface_Element ) ) {
				m_Interfaces.append ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::OS_Element ) ) {
				setOS ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::BackEnd_Element ) ) {
				setBackend ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::Distribution_Element ) ) {
				setDistribution ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::InitPath_Element ) ) {
				setInitPath ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::IPTPath_Element ) ) {
				setIPTPath ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::ModprobePath_Element ) ) {
				setModprobePath ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else if ( ( curr.nodeName() == XML::RcDefaultPath_Element ) ) {
				setRcDefaultPath ( curr.toElement().attribute (  XML::Name_Attribute ) );
			} else {
				// FIXME: Check Fro Errors
				kdDebug() << "KMFTargetConfig::loadXML - ERROR: unknown tag: " << curr.nodeName() << " inoring tag!" << endl;
			}
		}
		curr = curr.nextSibling();
	}
	kdDebug() << "Parsed Config: " << toString() << endl;
	changed();
}

QString KMFTargetConfig::toString() {
	QString s = QString (
					"Interfaces: " + m_Interfaces.join ( "," ) + "\n" +
					"OS: " + oS() + "\n" +
					"backend: " + backend() + "\n" +
					"distribution: " + distribution() + "\n" +
					"initPath: " + initPath() + "\n" +
					"IPTPath: " + IPTPath() + "\n" +
					"modprobePath: " + modprobePath() + "\n" +
					"rcDefaultPath: " + rcDefaultPath() );
	return s;

}

}

