//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfaceprotocol.h"

// QT includes
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidgetstack.h>
#include <qtextedit.h>
#include <qtimer.h>


// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfnethost.h"
#include "../core/kmferror.h"

#include "../kmfwidgets/kmflistviewitem.h"
#include "../kmfwidgets/kmfchecklistitem.h"
#include "../kmfwidgets/kmfnetworkwidget.h"
#include "../kmfwidgets/kmfnethostpropertieswidget.h"
#include "../kmfwidgets/kmfprotocolpropertieswidget.h"
#include "../kmfwidgets/kmfprotocollistview.h"

namespace KMF {
KMFGenericInterfaceProtocol::KMFGenericInterfaceProtocol( QWidget *parent, const char *name, WFlags f ) : KMyFirewallGenericInterfaceProtocolWidget( parent, name, f ) {
	loadIcons();
	m_contextMenu = new KPopupMenu( this, "m_contextMenu" );
//	m_lv_protocols->setFullWidth( true );
	
	// Network Widget
	m_network_widget = new KMFNetworkWidget( m_widgetStack, "m_network_widget" );
	m_widgetStack->addWidget( m_network_widget );
	connect( m_network_widget,SIGNAL( sigZoneChanged( KMFNetZone* ) ),
		this,SLOT( slotZoneChanged( KMFNetZone* ) ) );
	
	// Host widget
	m_nethostProperties_widget = new KMFNetHostPropertiesWidget( m_widgetStack, "m_nethostProperties_widget" );
	m_widgetStack->addWidget( m_nethostProperties_widget );
	
	connect( m_nethostProperties_widget, SIGNAL( sigHostAddressChanged( const QString& ) ),
		this, SLOT( slotAddressChanged( const QString& ) ) );
	
	// Protocol Widget
	m_protocolProperties_widget = new KMFProtocolPropertiesWidget( m_widgetStack, "m_protocolProperties_widget" );
	m_widgetStack->addWidget( m_protocolProperties_widget );
	
	
	// Protociol List View
	m_protocolLIstView = new KMFProtocolListView( m_protocolsFrame, "m_protocolLIstView" );
	
	QGridLayout *grid = new QGridLayout( m_protocolsFrame, 1, 1 );
	grid->addWidget( m_protocolLIstView, 0, 0 );
	
	connect( m_protocolLIstView,SIGNAL( sigProtocolClicked( KMFProtocolUsage*, bool ) ),
		this, SLOT( slotProtocolClicked( KMFProtocolUsage*, bool ) ) );
	
	connect( m_protocolLIstView,SIGNAL( sigProtocolCategoryClicked( KMFProtocolCategory* ) ),
		this, SLOT ( slotProtocolCategoryClicked( KMFProtocolCategory* ) ) );
		
	// Zone view
	connect( m_lv_zones, SIGNAL( pressed( QListViewItem* ) ) ,
		this, SLOT( slotNewItemSelected( QListViewItem* ) ) );
		
	connect( m_lv_zones, SIGNAL( contextMenuRequested ( QListViewItem*, const QPoint&, int ) ),
		this, SLOT( slotZoneRBM( QListViewItem*, const QPoint&, int ) ) );
	
	connect( m_lv_zones, SIGNAL( itemRenamed ( QListViewItem *, int, const QString & ) ) ,
		this, SLOT( slotRenameItem( QListViewItem *, int, const QString & ) ) );
		
	// Main win
	connect( m_c_restrictOutgoing, SIGNAL( clicked() ),
		this, SLOT( slotRestrictionChanged() ) );
	
	connect( m_c_allowIncoming, SIGNAL( clicked() ),
		this, SLOT( slotRestrictionChanged() ) );
	
	connect( m_zoneSelect, SIGNAL( activated( const QString& ) ),
		this, SLOT( slotCurrentZoneChanged( const QString& ) ) );	
		
	m_zone = 0;
	m_type = -1;
	m_protocolUsage = 0;
}


KMFGenericInterfaceProtocol::~KMFGenericInterfaceProtocol() {}

void KMFGenericInterfaceProtocol::loadDoc( KMFNetwork *net ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::loadDoc( KMFGenericDoc* doc )" << endl;
	m_doc = net;
	m_doc->currentDocAsGenericDoc()->incomingZone();
	m_zoneSelect->clear();
	m_zoneSelect->insertItem( i18n("Incoming Zone") );
	m_zoneSelect->insertItem( i18n("Outgoing Zone") );
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotUpdateView( NetfilterObject* ) {
	kdDebug() << "KMFGenericInterfaceProtocol::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotUpdateView() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotUpdateView()" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	m_lv_zones->clear();
	m_protocolLIstView->loadProtocols();
	m_protocolLIstView->setEnabled( false );
	
	m_c_allowIncoming->blockSignals( true );
	m_c_restrictOutgoing->blockSignals( true );
	m_c_allowIncoming->setChecked( m_doc->currentDocAsGenericDoc()->allowIncomingConnections() );
	m_c_restrictOutgoing->setChecked( m_doc->currentDocAsGenericDoc()->restrictOutgoingConnections() );
	m_c_allowIncoming->blockSignals( false );
	m_c_restrictOutgoing->blockSignals( false );
	
	QString zone = m_zoneSelect->currentText();
	if ( zone == i18n("Incoming Zone") ) {
		kdDebug() << "Showing Incoming Zone" << endl;
		KMFListViewItem *item = new KMFListViewItem( m_lv_zones, 0, m_doc->currentDocAsGenericDoc()->incomingZone() );
		item->setupZoneView();
	} else if ( zone == i18n("Outgoing Zone") ) {
		kdDebug() << "Showing Outgoing Zone" << endl;
		KMFListViewItem *item2 = new KMFListViewItem( m_lv_zones, 0, m_doc->currentDocAsGenericDoc()->outgoingZone() );
		item2->setupZoneView();
	}

	if ( ! m_doc->currentDocAsGenericDoc()->allowIncomingConnections() && ! m_doc->currentDocAsGenericDoc()->restrictOutgoingConnections() ) {
		m_lv_zones->setEnabled( false );
		m_protocolLIstView->setEnabled( false );
		m_widgetStack->setEnabled( false );
		return;
	}
	
	m_lv_zones->setEnabled( true );
	// m_protocolLIstView->setEnabled( true );
	m_widgetStack->setEnabled( true );

	if ( m_host ) {
		if ( KMFListViewItem *item = findItem( m_host->uuid() ) ) {
			m_lv_zones->setSelected( item, true );
		}
	} else if ( m_zone ) {
		if ( KMFListViewItem *item = findItem( m_zone->uuid() ) ) {
			m_lv_zones->setSelected( item, true );
		}
	}
	m_lv_zones->setSorting( 0 , false );
}

void KMFGenericInterfaceProtocol::slotRestrictionChanged() {
	m_doc->currentDocAsGenericDoc()->setRestrictOutgoingConnections( m_c_restrictOutgoing->isChecked() );
	m_doc->currentDocAsGenericDoc()->setAllowIncomingConnections( m_c_allowIncoming->isChecked() );
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotCurrentZoneChanged( const QString& ) {
	slotUpdateView();
}

void KMFGenericInterfaceProtocol::slotNewItemSelected( QListViewItem* item ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotNewItemSelected( QListViewItem* item )" << endl;
	if ( ! item ) {
		m_protocolLIstView->setEnabled( false );
		return ;
	}
	m_protocolUsage = 0;
	m_zone = 0;
	m_host = 0;

	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0 && kmfitem->type() == NetfilterObject::NETZONE ) {
		kdDebug() << "Selected NETZONE" << endl;
		m_widgetStack->raiseWidget( m_network_widget );
		m_zone = kmfitem->zone();
		if ( m_zone ) {
			kdDebug() << "kmfitem->zone() pointer is valid" << endl;
			kmfitem->setText( 0,m_zone->guiName() );
			kmfitem->setText( 1, "[" + m_zone->address()->toString() + i18n("/%1]").arg( m_zone->maskLength() ) );
			m_protocolLIstView->setZone( m_zone );
			m_protocolLIstView->setEnabled( true );
			m_network_widget->loadZone( m_zone );
			
			if ( m_zone->name() == "incoming_world" || m_zone->name() == "outgoing_world" || m_zone->readOnly() ) {
				m_network_widget->allowEdit( false );
			} else {
				m_network_widget->allowEdit( true );
			}
			 
		} 
	} else if ( kmfitem != 0 && kmfitem->type() == NetfilterObject::NETHOST ) {
		kdDebug() << "Selected NETHOST" << endl;
		m_widgetStack->raiseWidget( m_nethostProperties_widget );
		m_host = kmfitem->host();
		m_zone = m_host->zone();
		if ( m_host ) {
			kdDebug() << "kmfitem->host() pointer is valid" << endl;
			m_nethostProperties_widget->loadHost( m_host );
			m_protocolLIstView->setEnabled( true );
			m_protocolLIstView->setHost( m_host );
		} 
	} else {
		m_protocolLIstView->setEnabled( false );
	}
	kdDebug() << "Laving slotNewItemSelected()" << endl;
}

void KMFGenericInterfaceProtocol::slotZoneRBM( QListViewItem* item, const QPoint& point, int ) {
	if ( ! item )
		return ;
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	if ( kmfitem != 0  && kmfitem->type() == NetfilterObject::NETZONE ) {
		kdDebug() << "Setting up Zone RBM:" << endl;
		m_host = 0;
		m_zone = 0;
		m_zone = kmfitem->zone();
		if ( m_zone ) {
			m_contextMenu->clear();
			QString name = m_zone->name();
			QString lab_str = i18n("Zone: %1").arg( m_zone->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_new, i18n( "Add Host..." ), this, SLOT( slotAddHost() ) );

			
				m_contextMenu->insertSeparator();
				m_contextMenu->insertItem( icon_new, i18n( "Add Zone..." ), this, SLOT( slotAddZone() ) );
			if ( m_zone->name() != "incoming_world" && m_zone->name() != "outgoing_world" ) {
				m_contextMenu->insertItem( icon_rename, i18n( "Rename Zone..." ), this, SLOT( slotRenameZone() ) );
				m_contextMenu->insertSeparator();
				m_contextMenu->insertItem( icon_del, i18n( "Delete Zone" ), this, SLOT( slotDelZone() ) );
			}

			m_contextMenu->popup( point );
		}
	} else if ( kmfitem != 0  && kmfitem->type() == NetfilterObject::NETHOST ) {
		kdDebug() << "Setting up Host RBM:" << endl;
		m_host = 0;
		m_host = kmfitem->host();
		if ( m_host ) {
			m_contextMenu->clear();
			QString name = m_host->name();
			QString lab_str = i18n("Host: %1").arg( m_host->guiName() );
			m_contextMenu->insertTitle( icon_chain, lab_str );
			m_contextMenu->insertItem( icon_rename, i18n( "Rename Host..." ), this, SLOT( slotRenameHost() ) );
			m_contextMenu->insertItem( icon_rename, i18n( "Delete Host..." ), this, SLOT( slotDelHost() ) );
			m_contextMenu->popup( point );
		}
	}
}

void KMFGenericInterfaceProtocol::slotProtocolClicked( KMFProtocolUsage* protUsage, bool onOff ) {
	kdDebug() << " KMFGenericInterfaceProtocol::slotProtocolClicked( KMFProtocolUsage* protUsage, bool onOff )" << endl;
	if ( ! protUsage || ! m_zone ) {
		kdDebug() << "WARNING: no protUsage selected" << endl;
		return ;
	}
	m_widgetStack->raiseWidget( m_protocolProperties_widget );
	if ( m_zone && ! m_host ) {
		if ( onOff ) {
			m_protocolUsage = 0;
			if ( KMFProtocolUsage* pro = m_zone->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				m_protocolUsage = pro;
			} else { 
					KMFUndoEngine::instance()->startTransaction(
					m_zone,
					i18n("Add protocol %1 to zone %2.").arg( protUsage->protocol()->name() ).arg( m_zone->guiName() )
					);
					KMFProtocolUsage * pro = m_zone->addProtocolUsage( protUsage->protocol()->uuid(), protUsage->protocol()->getDOMTree() );
			
				if ( pro ) {
					kdDebug() << "Added Protocol to zone: " << m_zone-> name()  << endl;
					m_protocolUsage = pro;
					KMFUndoEngine::instance()->endTransaction();
				} else {
					KMFUndoEngine::instance()->abortTransaction();
				}
			} 
			
			if ( m_protocolUsage ) {
				m_protocolProperties_widget->loadProtocolUsage( m_protocolUsage );
			} 
		} else {
			m_protocolProperties_widget->loadProtocol( protUsage->protocol() );
			if ( m_zone->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				KMFUndoEngine::instance()->startTransaction(
					m_zone,
					i18n("Delete protocol %1 from zone %2.").arg( protUsage->protocol()->name() ).arg( m_zone->guiName() )
				);
				m_zone->delProtocolUsage( protUsage );
				KMFUndoEngine::instance()->endTransaction();
			}
		}

	} else if ( m_host ) {
		if ( onOff ) {
			m_protocolUsage = 0;
			
				if ( KMFProtocolUsage* pro = m_host->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				m_protocolUsage = pro;
			} else {
				KMFUndoEngine::instance()->startTransaction(
					m_host,
					i18n("Add protocol %1 to host %2.").arg( protUsage->protocol()->name() ).arg( m_host->guiName() )
					);
					KMFProtocolUsage * pro = m_host->addProtocolUsage( protUsage->protocol()->uuid(), protUsage->protocol() ->getDOMTree() );
			
				if ( pro ) {
					kdDebug() << "Added Protocol to host: " << m_host-> name()  << endl;
					m_protocolUsage = pro;
					KMFUndoEngine::instance()->endTransaction();
				} else {
					KMFUndoEngine::instance()->abortTransaction();
				}
			} 
			if ( m_protocolUsage ) {
				m_protocolProperties_widget->loadProtocolUsage( m_protocolUsage );
			} 
		} else {
			m_protocolProperties_widget->loadProtocol( protUsage->protocol() );
			if ( m_host->findProtocolUsageByProtocolUuid( protUsage->protocol()->uuid() ) ) {
				KMFUndoEngine::instance()->startTransaction(
					m_host,
					i18n("Delete protocol %1 from host %2.").arg( protUsage->protocol()->name() ).arg( m_host->guiName() )
				);
				m_host->delProtocolUsage( protUsage );
				KMFUndoEngine::instance()->endTransaction();
			}
		}
	}
}

void KMFGenericInterfaceProtocol::slotProtocolCategoryClicked( KMFProtocolCategory* protCat ) {
	kdDebug() << " KMFGenericInterfaceProtocol::slotProtocolCategoryClicked( KMFProtocolUsage* protUsage, bool onOff )" << endl;
	if ( ! protCat )  {
		return;
	}
	
	m_widgetStack->raiseWidget( m_protocolProperties_widget );
	m_protocolProperties_widget->loadProtocolCategory( protCat );
}




void KMFGenericInterfaceProtocol::slotAddZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddZone()" << endl;
	bool ok;
	QString name = KInputDialog::getText(i18n("New Zone"), i18n("Zone Name"),i18n("NewZone"), &ok, this );
	if ( !ok )
		return;
	
	
	if ( m_zoneSelect->currentText() == i18n("Incoming Zone") ) {
		QString s = "";
		s = s.setNum( m_doc->currentDocAsGenericDoc()->incomingZone()->zones().count() );
		KMFUndoEngine::instance()->startTransaction(
			m_doc->currentDocAsGenericDoc()->incomingZone(),
			i18n("Add Zone %1 to Incoming Zone").arg( name )
		);
		KMFNetZone * zone = m_doc->currentDocAsGenericDoc()->incomingZone()->addZone( "" + m_doc->currentDocAsGenericDoc()->incomingZone()->name() + "_z_" + s,  new KMFError() );
		if ( zone ) {
			zone->setGuiName( name );
			m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
		
	} else if ( m_zoneSelect->currentText() == i18n("Outgoing Zone") ) {
		QString s = "";
		s = s.setNum( m_doc->currentDocAsGenericDoc()->outgoingZone()->zones().count() );
		KMFUndoEngine::instance()->startTransaction(
			m_doc->currentDocAsGenericDoc()->outgoingZone(),
			i18n("Add Zone %1 to Outgoing Zone.").arg( name )
		);
		
		KMFNetZone * zone = m_doc->currentDocAsGenericDoc()->outgoingZone()->addZone( "" + m_doc->currentDocAsGenericDoc()->outgoingZone()->name() + "_z_" + s,  new KMFError() );
		if ( zone ) {
			zone->setGuiName( name );
			m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
	}
	
	
}

void KMFGenericInterfaceProtocol::slotDelZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotDelZone()" << endl;
	if ( ! m_zone )
		return;
	if ( m_zone->name() != "incoming_world" || m_zone->name() != "outgoing_world" ) {
		KMFUndoEngine::instance()->startTransaction(
			m_zone->zone(),
			i18n("Delete zone %1 from zone %2.").arg( m_zone->guiName() ).arg( m_zone->zone()->guiName() )
		);
		m_zone->zone()->delZone( m_zone );
		m_zone = 0;
		m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
		m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
		KMFUndoEngine::instance()->endTransaction();
		slotUpdateView();
	}
}

void KMFGenericInterfaceProtocol::slotAddHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddHost()" << endl;
	bool ok;
	QString name = KInputDialog::getText( i18n("New Host"), i18n("Host Name"),i18n("New Host"), &ok, this );
	if ( !ok )
		return;
	
	if ( m_zone ) {
		QString s = "";
		s = s.setNum( m_zone->hosts().count() );
		KMFUndoEngine::instance()->startTransaction( 
			m_zone,
			i18n("Add Host %1 to Zone: %2").arg( name ).arg( m_zone->guiName() )  
		);
		KMFNetHost * host = m_zone->addNetHost( "" + m_zone->name() + "_h_" + s,  * (new QDomDocument() ) );
		if ( host ) {
			host->setGuiName( name );
			KMFUndoEngine::instance()->endTransaction();			m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
			m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
			slotUpdateView();
		} else {
			KMFUndoEngine::instance()->abortTransaction();
		}
	}
}

void KMFGenericInterfaceProtocol::slotDelHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotDelHost()" << endl;
	if ( ! m_zone || ! m_host )
		return;
	KMFUndoEngine::instance()->startTransaction( 
		m_zone,
		i18n("Delete host %1 from zone: %2").arg( m_host->guiName() ).arg( m_zone->guiName() )  
	);
	m_zone->delHost( m_host );
	m_host = 0;
	m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
	m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
	KMFUndoEngine::instance()->endTransaction();
	slotUpdateView();
}

KMFListViewItem* KMFGenericInterfaceProtocol::findItem( const QUuid& obj_id ) {
	kdDebug() << "KMFListViewItem* KMFGenericInterfaceProtocol::findItem( int obj_id )" << endl;
	QListViewItem* root = m_lv_zones->firstChild();
	if ( ! root )
		return 0;
	QListViewItem* item = root->firstChild();
	while ( item ) {
// 		item->setText( 0, item->text(0) +"_searched" );
		if ( KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item ) ) {
			kdDebug() << "kmfitem->uuid(): " << kmfitem->uuid() <<
				" obj_id: " << obj_id << endl;
			
			if ( kmfitem->uuid() == obj_id ) {
				kdDebug() << "MATCHED" << endl;
				return kmfitem;
			}
		}
		item = item->itemBelow();
	}
	return 0;
}

// void KMFGenericInterfaceProtocol::slotAddressChanged( int, int, int, int ) {
// 
// 
// 
// }

void KMFGenericInterfaceProtocol::slotAddressChanged( const QString& ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotAddressChanged( const QString& )" << endl;
	if ( ! m_host ) {
		return;
	}
	slotUpdateView();
	if ( KMFListViewItem *item = findItem( m_host->uuid() ) ) {
		item->setText( 1, "[" + m_host->address()->toString() + "]" );
	}
}

void KMFGenericInterfaceProtocol::slotZoneChanged( KMFNetZone* z ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotZoneChanged( KMFNetZone* z )" << endl;
	if ( KMFListViewItem *item = findItem( z->uuid() ) ) {
		kdDebug() << "Updating item" << endl;
				item->setText( 1, "[" + z->address()->toString() + i18n("/%1]").arg( z->maskLength() ) );	
	}
	m_doc->currentDocAsGenericDoc()->incomingZone()->refreshNetworkTree();
	m_doc->currentDocAsGenericDoc()->outgoingZone()->refreshNetworkTree();
	slotUpdateView();
	
}


void KMFGenericInterfaceProtocol::slotRenameZone() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameZone()" << endl;
	if ( ! m_zone )
		return;
	if ( KMFListViewItem* item = findItem( m_zone->uuid() ) ) {
		item->setRenameEnabled( 0 ,true );
		item->startRename(0);
	}
}

void KMFGenericInterfaceProtocol::slotRenameHost() {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameHost()" << endl;
	if ( ! m_host )
		return;
	if ( KMFListViewItem* item = findItem( m_host->uuid() ) ) {
		item->setRenameEnabled( 0 ,true );
		item->startRename(0);
	}
}

void KMFGenericInterfaceProtocol::slotRenameItem( QListViewItem* item, int, const QString& name ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotRenameItem( QListViewItem* item, int, const QString& name )" << endl;
	if ( ! item )
		return;

	if ( name.isEmpty() ) {
		slotUpdateView();
		return;
	}

	if ( KMFListViewItem *kmfitem = dynamic_cast<KMFListViewItem*> (item) ) {
		if ( kmfitem->type() == NetfilterObject::NETZONE ) {
			KMFUndoEngine::instance()->startTransaction( 
				kmfitem->zone(),
				i18n("Rename zone %1 to %2.").arg( kmfitem->zone()->guiName() ).arg( name )  
			);
			
			kmfitem->zone()->setGuiName( name );
			kdDebug() << "Renaming Zone: " << kmfitem->zone()->name() << endl;
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
			return;
		}
	}
	
	if ( KMFListViewItem *kmfitem = dynamic_cast<KMFListViewItem*> (item) ) {
		if ( kmfitem->type() == NetfilterObject::NETHOST ) {
			KMFUndoEngine::instance()->startTransaction( 
				kmfitem->host(),
				i18n("Rename host %1 to %2.").arg( kmfitem->host()->guiName() ).arg( name )  
			);
			kmfitem->host()->setGuiName( name );
			kdDebug() << "Renaming Host: " << kmfitem->host()->name() << endl;
			KMFUndoEngine::instance()->endTransaction();
			slotUpdateView();
			return;
		}
	}
	
}
 
void KMFGenericInterfaceProtocol::loadIcons() {
	kdDebug() << "void KMFGenericInterfa::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "up";
	icon_up = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "down";
	icon_down = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editdelete";
	icon_del = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filenew";
	icon_new = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, KIcon::Small );


	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "text";
	icon_rename = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "rule-22";
	icon_rule = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "stop";
	icon_drop = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filesaveas";
	icon_log = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "undo";
	icon_return = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editclear";
	icon_cmd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editcopy";
	icon_copy = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "forward";
	icon_move = loader->loadIcon( icon_name, KIcon::Small );

}

}
#include "kmfgenericinterfaceprotocol.moc"
