/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditip.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditip.h"

namespace KMF {
KMFRuleOptionEditIP::KMFRuleOptionEditIP(QObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditIP::KMFRuleOptionEditIP(QObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditIP( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditIP::~KMFRuleOptionEditIP() {}

void KMFRuleOptionEditIP::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const QString& KMFRuleOptionEditIP::optionEditName() const {
	return *( new QString( i18n("IP Option") ) );
}
const QString& KMFRuleOptionEditIP::description() const {
	return *( new QString( i18n("This plugin manages the IP based options of iptables.") ) );
}

void KMFRuleOptionEditIP::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditIP::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleOptionEditIP::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditIP::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditIPFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditIPFactory::s_about = 0L;

KMFRuleOptionEditIPFactory::KMFRuleOptionEditIPFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditIPFactory" );
}

QObject* KMFRuleOptionEditIPFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleOptionEditIP( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditIPFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditIPFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_ip() {
		return new KMFRuleOptionEditIPFactory;
	}
}

}


#include "kmfruleoptioneditip.moc"
