#ifndef KNAP_HOTLISTPANEL_H
#define KNAP_HOTLISTPANEL_H

#include <qframe.h>
#include <qstringlist.h>

class KNAP_ListView;
class QListView;
class QLabel;
class QPushButton;
class QListViewItem;
class SongInfo;
class QPopupMenu;

class KNAP_HotlistPanel
 : public QFrame
{
   Q_OBJECT
signals:
   void sendcommand(const char *comm);
//   void user_added(const char *); // called after add user button is pressed     
//   void user_browse(const char *); // after a user pressed
//   void user_removed(const char *); // after a user is removed by menu
private slots:
   void addUser(); // prompt for and add a user - called by add button
//   void remUser( QListViewItem *);
   void getInfo( QListViewItem *);
   void dblclickDownload(QListViewItem *);
   void popupMenu( QListViewItem *, const QPoint &, int );

   void popupDownload();
   void popupOfflineRemove();
   void popupOnlineRemove();

   void popupMessage();
   void popupPing();
   void popupOnlineWhois();
   void popupOfflineWhois();

   void popupIgnore();
   void popupUnignore();
public slots:
   void addUser(const char *,bool online=false);
   void remUser(const char *);
public:
   KNAP_HotlistPanel(QWidget *parent,const char *name);
   virtual ~KNAP_HotlistPanel();

   QStringList getUsers();

   void clearSonglist();
   void addSong(const SongInfo *song);
   void endSonglist(const char *userdata);

   void setOffline();
private:
   void saveUsers();
   void loadUsers();

   void runCommand(QListView *view,const QString &comm);
   
   KNAP_ListView *onlineview;
   KNAP_ListView *offlineview;
   KNAP_ListView *songview;
   QLabel *stats;
   QPushButton *add;

   QPopupMenu *popupmenu;

   QString user;
};


#endif // KNAP_HOTLISTPANEL_H
