/***************************************************************************
                          searchpanel.h  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHPANEL_H
#define SEARCHPANEL_H

#include <qframe.h>
#include <qlist.h>

//class ExtComboBox;
class QComboBox;
class QLineEdit;
class KNAP_ListView;
class QListViewItem;
class QPoint;
class KSocket;
class QPopupMenu;
class QPushButton;
class QLabel;

class SongInfo;

/**the search panel, including the  results list and the search type etc.

  *@author John Donoghue
  */

class KNAP_SearchPanel 
//: public QWidget 
 : public QFrame 
{
   Q_OBJECT

signals:
  void sendcommand(const char *);

  // signal for return pressed in thye search text box
//  void search(const char *);

  // signal for selection of download from popup menu
//  void download(QListViewItem *);

//  void download(SongInfo *);
  
  // signal when ping selected from popup
//  void ping(const char *);
//  void whois(const char *);
//  void addFriend(const char *);


public slots:
  // clear the listview
  void clearSearch();


private slots:
  // internal slots
  void calcSearch();
  void popupSearch ( QListViewItem *, const QPoint &, int );
  void popupSearchDownload();

  void popupPing();
  void popupWhois();
  void popupAddFriend();

  void popupShowPath();

//  void searchComboActivated(int);
  void optionComboActivated(int);
//  void optimizeLevel();

  void dblclickSearchDownload( QListViewItem *item );
public: 
  KNAP_SearchPanel(QWidget *parent=0, const char *name=0);
  virtual ~KNAP_SearchPanel();

  void addSearchItem(SongInfo *song /*,bool showsearchpath=false*/);

  bool showSearchPath() const;
  void setShowSearchPath(bool yes);
  void setMultiSelect(bool yes);

  // save / retrieve search lists from prefs
  void loadSearchPrefs();
  void saveSearchPrefs();

private:
  void setExtraOptionsEnabled(bool enable);
  QComboBox *createCompareValueCB(const char *name);

  QString getServerCompareString(int pos);


private:
//  QList<SongInfo>* results;
//  QComboBox *optimizeoption;

  QPopupMenu *searchpopupmenu;

  QLineEdit *searchtext;
  QLineEdit *grouptext;

//  QComboBox *searchoption;
  KNAP_ListView *searchlistview;
  QPushButton *searchbutton;

  QComboBox *speedoption;
  QComboBox *speedtext;

  QComboBox *bitrateoption;
  QComboBox *bitratetext;

  QComboBox *freqoption;
  QComboBox *freqtext;

  QLineEdit *resultstext;

  QLabel *stats;

  bool showsearchpath;
  bool multiselect;

 // static const double optvalues[8];
};

#endif
