/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Dec 25 11:44:02 CST 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>

#include "knapster2.h"
//#include "knapster.h"

#include "../config.h"

static const char *description =
	I18N_NOOP("Knapster2 is a KDE2 clone of the Windows Napster Client");
	
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "knapster2", I18N_NOOP("Knapster2"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2000, John Donoghue");
  aboutData.addAuthor("John Donoghue",0, "donoghue@chariot.net.au");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a("knapster2");
  Knapster2 *knapster2 = new Knapster2("knapster2");
  //KnapsterWindow *knapster2 = new KnapsterWindow();
  a.setMainWidget(knapster2);
  knapster2->show();  

  return a.exec();
}
