/***************************************************************************
                                 dock.h
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DOCK_H
#define DOCK_H

#include <qwidget.h>
#include <qcolor.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qfont.h>
#include <qtooltip.h>
#include <kwin.h>
#include <stdio.h>
#include <stdlib.h>

class Dock : public QWidget {
	Q_OBJECT
public:

	Dock(QWidget *mainwin = 0, QWidget *parent = 0, const char *name = 0);
	~Dock();

	void setGrid(bool);
	void setOn(bool);
	void setText(bool);
	void setSoft(bool);

	void setFill(int);
	void setCol(int);
	void setSpd(int);
	void setDirection(bool);
	void setScale(int);

private:

	void mousePressEvent(QMouseEvent *);
	void paintEvent(QPaintEvent *);

	int *buf, pos, i, i2, col, spd, fill, scale, tmp, tmp2, tmp3, old;
	bool grid, text, soft, on, direction;

public slots:

	void setClr(void);
	void step(float);

signals:

	void mouseClick(QMouseEvent *);
};

#endif




