
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SCALEDIALOG_H
#define __SCALEDIALOG_H

#include <kdialogbase.h>

/**
 * A dialog used to select the scale for a network load diagram.
 */
class ScaleDialog : public KDialogBase {
    Q_OBJECT

    public:
        /**
         * Constructor.
         */
        ScaleDialog(int defaultScale, const QString & title, QWidget* parent);

        /**
         * Returns the scale currently selected in the dialog.
         * This is valid after the dialog has closed.
         */
        int getScale() const;

    private slots:
        /**
         * Updates the scale variable to reflect the latest changes in
         * the scale entry box.
         */
        virtual void updateScale(const QString&);

    private:
        int scale;
            /**< The scale currently selected in the scale entry box. */
};

#endif
